/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a virtual service returned by a describe operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualServiceData implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualServiceData.Builder, VirtualServiceData> {
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("meshName").getter(getter(VirtualServiceData::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()).build();

    private static final SdkField<ResourceMetadata> METADATA_FIELD = SdkField
            .<ResourceMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(VirtualServiceData::metadata)).setter(setter(Builder::metadata))
            .constructor(ResourceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<VirtualServiceSpec> SPEC_FIELD = SdkField
            .<VirtualServiceSpec> builder(MarshallingType.SDK_POJO).memberName("spec").getter(getter(VirtualServiceData::spec))
            .setter(setter(Builder::spec)).constructor(VirtualServiceSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<VirtualServiceStatus> STATUS_FIELD = SdkField
            .<VirtualServiceStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(VirtualServiceData::status)).setter(setter(Builder::status))
            .constructor(VirtualServiceStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> VIRTUAL_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualServiceName").getter(getter(VirtualServiceData::virtualServiceName))
            .setter(setter(Builder::virtualServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualServiceName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESH_NAME_FIELD,
            METADATA_FIELD, SPEC_FIELD, STATUS_FIELD, VIRTUAL_SERVICE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String meshName;

    private final ResourceMetadata metadata;

    private final VirtualServiceSpec spec;

    private final VirtualServiceStatus status;

    private final String virtualServiceName;

    private VirtualServiceData(BuilderImpl builder) {
        this.meshName = builder.meshName;
        this.metadata = builder.metadata;
        this.spec = builder.spec;
        this.status = builder.status;
        this.virtualServiceName = builder.virtualServiceName;
    }

    /**
     * <p>
     * The name of the service mesh that the virtual service resides in.
     * </p>
     * 
     * @return The name of the service mesh that the virtual service resides in.
     */
    public String meshName() {
        return meshName;
    }

    /**
     * Returns the value of the Metadata property for this object.
     * 
     * @return The value of the Metadata property for this object.
     */
    public ResourceMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * The specifications of the virtual service.
     * </p>
     * 
     * @return The specifications of the virtual service.
     */
    public VirtualServiceSpec spec() {
        return spec;
    }

    /**
     * <p>
     * The current status of the virtual service.
     * </p>
     * 
     * @return The current status of the virtual service.
     */
    public VirtualServiceStatus status() {
        return status;
    }

    /**
     * <p>
     * The name of the virtual service.
     * </p>
     * 
     * @return The name of the virtual service.
     */
    public String virtualServiceName() {
        return virtualServiceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(virtualServiceName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualServiceData)) {
            return false;
        }
        VirtualServiceData other = (VirtualServiceData) obj;
        return Objects.equals(meshName(), other.meshName()) && Objects.equals(metadata(), other.metadata())
                && Objects.equals(spec(), other.spec()) && Objects.equals(status(), other.status())
                && Objects.equals(virtualServiceName(), other.virtualServiceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VirtualServiceData").add("MeshName", meshName()).add("Metadata", metadata()).add("Spec", spec())
                .add("Status", status()).add("VirtualServiceName", virtualServiceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "virtualServiceName":
            return Optional.ofNullable(clazz.cast(virtualServiceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualServiceData, T> g) {
        return obj -> g.apply((VirtualServiceData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualServiceData> {
        /**
         * <p>
         * The name of the service mesh that the virtual service resides in.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh that the virtual service resides in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * @param metadata
         *        The new value for the Metadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(ResourceMetadata metadata);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * This is a convenience that creates an instance of the {@link ResourceMetadata.Builder} avoiding the need to
         * create one manually via {@link ResourceMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #metadata(ResourceMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link ResourceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(ResourceMetadata)
         */
        default Builder metadata(Consumer<ResourceMetadata.Builder> metadata) {
            return metadata(ResourceMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * The specifications of the virtual service.
         * </p>
         * 
         * @param spec
         *        The specifications of the virtual service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(VirtualServiceSpec spec);

        /**
         * <p>
         * The specifications of the virtual service.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualServiceSpec.Builder} avoiding the need to
         * create one manually via {@link VirtualServiceSpec#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualServiceSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #spec(VirtualServiceSpec)}.
         * 
         * @param spec
         *        a consumer that will call methods on {@link VirtualServiceSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spec(VirtualServiceSpec)
         */
        default Builder spec(Consumer<VirtualServiceSpec.Builder> spec) {
            return spec(VirtualServiceSpec.builder().applyMutation(spec).build());
        }

        /**
         * <p>
         * The current status of the virtual service.
         * </p>
         * 
         * @param status
         *        The current status of the virtual service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(VirtualServiceStatus status);

        /**
         * <p>
         * The current status of the virtual service.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualServiceStatus.Builder} avoiding the need
         * to create one manually via {@link VirtualServiceStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualServiceStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(VirtualServiceStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link VirtualServiceStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(VirtualServiceStatus)
         */
        default Builder status(Consumer<VirtualServiceStatus.Builder> status) {
            return status(VirtualServiceStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The name of the virtual service.
         * </p>
         * 
         * @param virtualServiceName
         *        The name of the virtual service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualServiceName(String virtualServiceName);
    }

    static final class BuilderImpl implements Builder {
        private String meshName;

        private ResourceMetadata metadata;

        private VirtualServiceSpec spec;

        private VirtualServiceStatus status;

        private String virtualServiceName;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualServiceData model) {
            meshName(model.meshName);
            metadata(model.metadata);
            spec(model.spec);
            status(model.status);
            virtualServiceName(model.virtualServiceName);
        }

        public final String getMeshName() {
            return meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final ResourceMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(ResourceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(ResourceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final VirtualServiceSpec.Builder getSpec() {
            return spec != null ? spec.toBuilder() : null;
        }

        @Override
        public final Builder spec(VirtualServiceSpec spec) {
            this.spec = spec;
            return this;
        }

        public final void setSpec(VirtualServiceSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        public final VirtualServiceStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(VirtualServiceStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(VirtualServiceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final String getVirtualServiceName() {
            return virtualServiceName;
        }

        @Override
        public final Builder virtualServiceName(String virtualServiceName) {
            this.virtualServiceName = virtualServiceName;
            return this;
        }

        public final void setVirtualServiceName(String virtualServiceName) {
            this.virtualServiceName = virtualServiceName;
        }

        @Override
        public VirtualServiceData build() {
            return new VirtualServiceData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
