/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <zonbook></zonbook><xhtml></xhtml>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTagsForResourceRequest extends AppMeshRequest implements
        ToCopyableBuilder<ListTagsForResourceRequest.Builder, ListTagsForResourceRequest> {
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("limit")
            .getter(getter(ListTagsForResourceRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTagsForResourceRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(ListTagsForResourceRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD, NEXT_TOKEN_FIELD,
            RESOURCE_ARN_FIELD));

    private final Integer limit;

    private final String nextToken;

    private final String resourceArn;

    private ListTagsForResourceRequest(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * The maximum number of tag results returned by <code>ListTagsForResource</code> in paginated output. When this
     * parameter is used, <code>ListTagsForResource</code> returns only <code>limit</code> results in a single page
     * along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by
     * sending another <code>ListTagsForResource</code> request with the returned <code>nextToken</code> value. This
     * value can be between 1 and 100. If you don't use this parameter, <code>ListTagsForResource</code> returns up to
     * 100 results and a <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of tag results returned by <code>ListTagsForResource</code> in paginated output. When
     *         this parameter is used, <code>ListTagsForResource</code> returns only <code>limit</code> results in a
     *         single page along with a <code>nextToken</code> response element. You can see the remaining results of
     *         the initial request by sending another <code>ListTagsForResource</code> request with the returned
     *         <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter,
     *         <code>ListTagsForResource</code> returns up to 100 results and a <code>nextToken</code> value if
     *         applicable.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>ListTagsForResource</code> request
     * where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>nextToken</code> value.
     * </p>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>ListTagsForResource</code>
     *         request where <code>limit</code> was used and the results exceeded the value of that parameter.
     *         Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the resource to list the tags for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the resource to list the tags for.
     */
    public String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceRequest)) {
            return false;
        }
        ListTagsForResourceRequest other = (ListTagsForResourceRequest) obj;
        return Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTagsForResourceRequest").add("Limit", limit()).add("NextToken", nextToken())
                .add("ResourceArn", resourceArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTagsForResourceRequest, T> g) {
        return obj -> g.apply((ListTagsForResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTagsForResourceRequest> {
        /**
         * <p>
         * The maximum number of tag results returned by <code>ListTagsForResource</code> in paginated output. When this
         * parameter is used, <code>ListTagsForResource</code> returns only <code>limit</code> results in a single page
         * along with a <code>nextToken</code> response element. You can see the remaining results of the initial
         * request by sending another <code>ListTagsForResource</code> request with the returned <code>nextToken</code>
         * value. This value can be between 1 and 100. If you don't use this parameter, <code>ListTagsForResource</code>
         * returns up to 100 results and a <code>nextToken</code> value if applicable.
         * </p>
         * 
         * @param limit
         *        The maximum number of tag results returned by <code>ListTagsForResource</code> in paginated output.
         *        When this parameter is used, <code>ListTagsForResource</code> returns only <code>limit</code> results
         *        in a single page along with a <code>nextToken</code> response element. You can see the remaining
         *        results of the initial request by sending another <code>ListTagsForResource</code> request with the
         *        returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this
         *        parameter, <code>ListTagsForResource</code> returns up to 100 results and a <code>nextToken</code>
         *        value if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>ListTagsForResource</code> request
         * where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues
         * from the end of the previous results that returned the <code>nextToken</code> value.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>ListTagsForResource</code>
         *        request where <code>limit</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>nextToken</code>
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the resource to list the tags for.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) that identifies the resource to list the tags for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppMeshRequest.BuilderImpl implements Builder {
        private Integer limit;

        private String nextToken;

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourceRequest model) {
            super(model);
            limit(model.limit);
            nextToken(model.nextToken);
            resourceArn(model.resourceArn);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTagsForResourceRequest build() {
            return new ListTagsForResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
