/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVirtualGatewaysResponse extends AppMeshResponse implements
        ToCopyableBuilder<ListVirtualGatewaysResponse.Builder, ListVirtualGatewaysResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListVirtualGatewaysResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<VirtualGatewayRef>> VIRTUAL_GATEWAYS_FIELD = SdkField
            .<List<VirtualGatewayRef>> builder(MarshallingType.LIST)
            .memberName("virtualGateways")
            .getter(getter(ListVirtualGatewaysResponse::virtualGateways))
            .setter(setter(Builder::virtualGateways))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGateways").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VirtualGatewayRef> builder(MarshallingType.SDK_POJO)
                                            .constructor(VirtualGatewayRef::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            VIRTUAL_GATEWAYS_FIELD));

    private final String nextToken;

    private final List<VirtualGatewayRef> virtualGateways;

    private ListVirtualGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.virtualGateways = builder.virtualGateways;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListVirtualGateways</code> request. When the
     * results of a <code>ListVirtualGateways</code> request exceed <code>limit</code>, you can use this value to
     * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListVirtualGateways</code> request. When
     *         the results of a <code>ListVirtualGateways</code> request exceed <code>limit</code>, you can use this
     *         value to retrieve the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the VirtualGateways property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasVirtualGateways() {
        return virtualGateways != null && !(virtualGateways instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of existing virtual gateways for the specified service mesh.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVirtualGateways()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of existing virtual gateways for the specified service mesh.
     */
    public List<VirtualGatewayRef> virtualGateways() {
        return virtualGateways;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasVirtualGateways() ? virtualGateways() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualGatewaysResponse)) {
            return false;
        }
        ListVirtualGatewaysResponse other = (ListVirtualGatewaysResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasVirtualGateways() == other.hasVirtualGateways()
                && Objects.equals(virtualGateways(), other.virtualGateways());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListVirtualGatewaysResponse").add("NextToken", nextToken())
                .add("VirtualGateways", hasVirtualGateways() ? virtualGateways() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "virtualGateways":
            return Optional.ofNullable(clazz.cast(virtualGateways()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVirtualGatewaysResponse, T> g) {
        return obj -> g.apply((ListVirtualGatewaysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListVirtualGatewaysResponse> {
        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListVirtualGateways</code> request. When the
         * results of a <code>ListVirtualGateways</code> request exceed <code>limit</code>, you can use this value to
         * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListVirtualGateways</code> request. When
         *        the results of a <code>ListVirtualGateways</code> request exceed <code>limit</code>, you can use this
         *        value to retrieve the next page of results. This value is <code>null</code> when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of existing virtual gateways for the specified service mesh.
         * </p>
         * 
         * @param virtualGateways
         *        The list of existing virtual gateways for the specified service mesh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGateways(Collection<VirtualGatewayRef> virtualGateways);

        /**
         * <p>
         * The list of existing virtual gateways for the specified service mesh.
         * </p>
         * 
         * @param virtualGateways
         *        The list of existing virtual gateways for the specified service mesh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGateways(VirtualGatewayRef... virtualGateways);

        /**
         * <p>
         * The list of existing virtual gateways for the specified service mesh.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VirtualGatewayRef>.Builder} avoiding the
         * need to create one manually via {@link List<VirtualGatewayRef>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VirtualGatewayRef>.Builder#build()} is called immediately
         * and its result is passed to {@link #virtualGateways(List<VirtualGatewayRef>)}.
         * 
         * @param virtualGateways
         *        a consumer that will call methods on {@link List<VirtualGatewayRef>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualGateways(List<VirtualGatewayRef>)
         */
        Builder virtualGateways(Consumer<VirtualGatewayRef.Builder>... virtualGateways);
    }

    static final class BuilderImpl extends AppMeshResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<VirtualGatewayRef> virtualGateways = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualGatewaysResponse model) {
            super(model);
            nextToken(model.nextToken);
            virtualGateways(model.virtualGateways);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VirtualGatewayRef.Builder> getVirtualGateways() {
            if (virtualGateways instanceof SdkAutoConstructList) {
                return null;
            }
            return virtualGateways != null ? virtualGateways.stream().map(VirtualGatewayRef::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder virtualGateways(Collection<VirtualGatewayRef> virtualGateways) {
            this.virtualGateways = VirtualGatewayListCopier.copy(virtualGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualGateways(VirtualGatewayRef... virtualGateways) {
            virtualGateways(Arrays.asList(virtualGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualGateways(Consumer<VirtualGatewayRef.Builder>... virtualGateways) {
            virtualGateways(Stream.of(virtualGateways).map(c -> VirtualGatewayRef.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVirtualGateways(Collection<VirtualGatewayRef.BuilderImpl> virtualGateways) {
            this.virtualGateways = VirtualGatewayListCopier.copyFromBuilder(virtualGateways);
        }

        @Override
        public ListVirtualGatewaysResponse build() {
            return new ListVirtualGatewaysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
