/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <zonbook></zonbook><xhtml></xhtml>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRoutesResponse extends AppMeshResponse implements
        ToCopyableBuilder<ListRoutesResponse.Builder, ListRoutesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRoutesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<RouteRef>> ROUTES_FIELD = SdkField
            .<List<RouteRef>> builder(MarshallingType.LIST)
            .memberName("routes")
            .getter(getter(ListRoutesResponse::routes))
            .setter(setter(Builder::routes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteRef> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteRef::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NEXT_TOKEN_FIELD, ROUTES_FIELD));

    private final String nextToken;

    private final List<RouteRef> routes;

    private ListRoutesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.routes = builder.routes;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListRoutes</code> request. When the results of a
     * <code>ListRoutes</code> request exceed <code>limit</code>, you can use this value to retrieve the next page of
     * results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListRoutes</code> request. When the results
     *         of a <code>ListRoutes</code> request exceed <code>limit</code>, you can use this value to retrieve the
     *         next page of results. This value is <code>null</code> when there are no more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Routes property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRoutes() {
        return routes != null && !(routes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of existing routes for the specified service mesh and virtual router.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRoutes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of existing routes for the specified service mesh and virtual router.
     */
    public List<RouteRef> routes() {
        return routes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutes() ? routes() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoutesResponse)) {
            return false;
        }
        ListRoutesResponse other = (ListRoutesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasRoutes() == other.hasRoutes()
                && Objects.equals(routes(), other.routes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListRoutesResponse").add("NextToken", nextToken()).add("Routes", hasRoutes() ? routes() : null)
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "routes":
            return Optional.ofNullable(clazz.cast(routes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRoutesResponse, T> g) {
        return obj -> g.apply((ListRoutesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRoutesResponse> {
        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListRoutes</code> request. When the results of
         * a <code>ListRoutes</code> request exceed <code>limit</code>, you can use this value to retrieve the next page
         * of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListRoutes</code> request. When the
         *        results of a <code>ListRoutes</code> request exceed <code>limit</code>, you can use this value to
         *        retrieve the next page of results. This value is <code>null</code> when there are no more results to
         *        return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of existing routes for the specified service mesh and virtual router.
         * </p>
         * 
         * @param routes
         *        The list of existing routes for the specified service mesh and virtual router.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Collection<RouteRef> routes);

        /**
         * <p>
         * The list of existing routes for the specified service mesh and virtual router.
         * </p>
         * 
         * @param routes
         *        The list of existing routes for the specified service mesh and virtual router.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(RouteRef... routes);

        /**
         * <p>
         * The list of existing routes for the specified service mesh and virtual router.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RouteRef>.Builder} avoiding the need to
         * create one manually via {@link List<RouteRef>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RouteRef>.Builder#build()} is called immediately and its
         * result is passed to {@link #routes(List<RouteRef>)}.
         * 
         * @param routes
         *        a consumer that will call methods on {@link List<RouteRef>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routes(List<RouteRef>)
         */
        Builder routes(Consumer<RouteRef.Builder>... routes);
    }

    static final class BuilderImpl extends AppMeshResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RouteRef> routes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoutesResponse model) {
            super(model);
            nextToken(model.nextToken);
            routes(model.routes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<RouteRef.Builder> getRoutes() {
            if (routes instanceof SdkAutoConstructList) {
                return null;
            }
            return routes != null ? routes.stream().map(RouteRef::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routes(Collection<RouteRef> routes) {
            this.routes = RouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(RouteRef... routes) {
            routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<RouteRef.Builder>... routes) {
            routes(Stream.of(routes).map(c -> RouteRef.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoutes(Collection<RouteRef.BuilderImpl> routes) {
            this.routes = RouteListCopier.copyFromBuilder(routes);
        }

        @Override
        public ListRoutesResponse build() {
            return new ListRoutesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
