/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the type of virtual gateway connection pool.
 * </p>
 * <p>
 * Only one protocol is used at a time and should be the same protocol as the one chosen under port mapping.
 * </p>
 * <p>
 * If not present the default value for <code>maxPendingRequests</code> is <code>2147483647</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayConnectionPool implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayConnectionPool.Builder, VirtualGatewayConnectionPool> {
    private static final SdkField<VirtualGatewayGrpcConnectionPool> GRPC_FIELD = SdkField
            .<VirtualGatewayGrpcConnectionPool> builder(MarshallingType.SDK_POJO).memberName("grpc")
            .getter(getter(VirtualGatewayConnectionPool::grpc)).setter(setter(Builder::grpc))
            .constructor(VirtualGatewayGrpcConnectionPool::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grpc").build()).build();

    private static final SdkField<VirtualGatewayHttpConnectionPool> HTTP_FIELD = SdkField
            .<VirtualGatewayHttpConnectionPool> builder(MarshallingType.SDK_POJO).memberName("http")
            .getter(getter(VirtualGatewayConnectionPool::http)).setter(setter(Builder::http))
            .constructor(VirtualGatewayHttpConnectionPool::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("http").build()).build();

    private static final SdkField<VirtualGatewayHttp2ConnectionPool> HTTP2_FIELD = SdkField
            .<VirtualGatewayHttp2ConnectionPool> builder(MarshallingType.SDK_POJO).memberName("http2")
            .getter(getter(VirtualGatewayConnectionPool::http2)).setter(setter(Builder::http2))
            .constructor(VirtualGatewayHttp2ConnectionPool::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("http2").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRPC_FIELD, HTTP_FIELD,
            HTTP2_FIELD));

    private static final long serialVersionUID = 1L;

    private final VirtualGatewayGrpcConnectionPool grpc;

    private final VirtualGatewayHttpConnectionPool http;

    private final VirtualGatewayHttp2ConnectionPool http2;

    private VirtualGatewayConnectionPool(BuilderImpl builder) {
        this.grpc = builder.grpc;
        this.http = builder.http;
        this.http2 = builder.http2;
    }

    /**
     * <p>
     * An object that represents a type of connection pool.
     * </p>
     * 
     * @return An object that represents a type of connection pool.
     */
    public VirtualGatewayGrpcConnectionPool grpc() {
        return grpc;
    }

    /**
     * <p>
     * An object that represents a type of connection pool.
     * </p>
     * 
     * @return An object that represents a type of connection pool.
     */
    public VirtualGatewayHttpConnectionPool http() {
        return http;
    }

    /**
     * <p>
     * An object that represents a type of connection pool.
     * </p>
     * 
     * @return An object that represents a type of connection pool.
     */
    public VirtualGatewayHttp2ConnectionPool http2() {
        return http2;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(grpc());
        hashCode = 31 * hashCode + Objects.hashCode(http());
        hashCode = 31 * hashCode + Objects.hashCode(http2());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayConnectionPool)) {
            return false;
        }
        VirtualGatewayConnectionPool other = (VirtualGatewayConnectionPool) obj;
        return Objects.equals(grpc(), other.grpc()) && Objects.equals(http(), other.http())
                && Objects.equals(http2(), other.http2());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VirtualGatewayConnectionPool").add("Grpc", grpc()).add("Http", http()).add("Http2", http2())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "grpc":
            return Optional.ofNullable(clazz.cast(grpc()));
        case "http":
            return Optional.ofNullable(clazz.cast(http()));
        case "http2":
            return Optional.ofNullable(clazz.cast(http2()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayConnectionPool, T> g) {
        return obj -> g.apply((VirtualGatewayConnectionPool) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayConnectionPool> {
        /**
         * <p>
         * An object that represents a type of connection pool.
         * </p>
         * 
         * @param grpc
         *        An object that represents a type of connection pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grpc(VirtualGatewayGrpcConnectionPool grpc);

        /**
         * <p>
         * An object that represents a type of connection pool.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualGatewayGrpcConnectionPool.Builder}
         * avoiding the need to create one manually via {@link VirtualGatewayGrpcConnectionPool#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayGrpcConnectionPool.Builder#build()} is called
         * immediately and its result is passed to {@link #grpc(VirtualGatewayGrpcConnectionPool)}.
         * 
         * @param grpc
         *        a consumer that will call methods on {@link VirtualGatewayGrpcConnectionPool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grpc(VirtualGatewayGrpcConnectionPool)
         */
        default Builder grpc(Consumer<VirtualGatewayGrpcConnectionPool.Builder> grpc) {
            return grpc(VirtualGatewayGrpcConnectionPool.builder().applyMutation(grpc).build());
        }

        /**
         * <p>
         * An object that represents a type of connection pool.
         * </p>
         * 
         * @param http
         *        An object that represents a type of connection pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder http(VirtualGatewayHttpConnectionPool http);

        /**
         * <p>
         * An object that represents a type of connection pool.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualGatewayHttpConnectionPool.Builder}
         * avoiding the need to create one manually via {@link VirtualGatewayHttpConnectionPool#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayHttpConnectionPool.Builder#build()} is called
         * immediately and its result is passed to {@link #http(VirtualGatewayHttpConnectionPool)}.
         * 
         * @param http
         *        a consumer that will call methods on {@link VirtualGatewayHttpConnectionPool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #http(VirtualGatewayHttpConnectionPool)
         */
        default Builder http(Consumer<VirtualGatewayHttpConnectionPool.Builder> http) {
            return http(VirtualGatewayHttpConnectionPool.builder().applyMutation(http).build());
        }

        /**
         * <p>
         * An object that represents a type of connection pool.
         * </p>
         * 
         * @param http2
         *        An object that represents a type of connection pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder http2(VirtualGatewayHttp2ConnectionPool http2);

        /**
         * <p>
         * An object that represents a type of connection pool.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualGatewayHttp2ConnectionPool.Builder}
         * avoiding the need to create one manually via {@link VirtualGatewayHttp2ConnectionPool#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayHttp2ConnectionPool.Builder#build()} is called
         * immediately and its result is passed to {@link #http2(VirtualGatewayHttp2ConnectionPool)}.
         * 
         * @param http2
         *        a consumer that will call methods on {@link VirtualGatewayHttp2ConnectionPool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #http2(VirtualGatewayHttp2ConnectionPool)
         */
        default Builder http2(Consumer<VirtualGatewayHttp2ConnectionPool.Builder> http2) {
            return http2(VirtualGatewayHttp2ConnectionPool.builder().applyMutation(http2).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VirtualGatewayGrpcConnectionPool grpc;

        private VirtualGatewayHttpConnectionPool http;

        private VirtualGatewayHttp2ConnectionPool http2;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayConnectionPool model) {
            grpc(model.grpc);
            http(model.http);
            http2(model.http2);
        }

        public final VirtualGatewayGrpcConnectionPool.Builder getGrpc() {
            return grpc != null ? grpc.toBuilder() : null;
        }

        @Override
        public final Builder grpc(VirtualGatewayGrpcConnectionPool grpc) {
            this.grpc = grpc;
            return this;
        }

        public final void setGrpc(VirtualGatewayGrpcConnectionPool.BuilderImpl grpc) {
            this.grpc = grpc != null ? grpc.build() : null;
        }

        public final VirtualGatewayHttpConnectionPool.Builder getHttp() {
            return http != null ? http.toBuilder() : null;
        }

        @Override
        public final Builder http(VirtualGatewayHttpConnectionPool http) {
            this.http = http;
            return this;
        }

        public final void setHttp(VirtualGatewayHttpConnectionPool.BuilderImpl http) {
            this.http = http != null ? http.build() : null;
        }

        public final VirtualGatewayHttp2ConnectionPool.Builder getHttp2() {
            return http2 != null ? http2.toBuilder() : null;
        }

        @Override
        public final Builder http2(VirtualGatewayHttp2ConnectionPool http2) {
            this.http2 = http2;
            return this;
        }

        public final void setHttp2(VirtualGatewayHttp2ConnectionPool.BuilderImpl http2) {
            this.http2 = http2 != null ? http2.build() : null;
        }

        @Override
        public VirtualGatewayConnectionPool build() {
            return new VirtualGatewayConnectionPool(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
