/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the specification of a virtual router.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualRouterSpec implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualRouterSpec.Builder, VirtualRouterSpec> {
    private static final SdkField<List<VirtualRouterListener>> LISTENERS_FIELD = SdkField
            .<List<VirtualRouterListener>> builder(MarshallingType.LIST)
            .memberName("listeners")
            .getter(getter(VirtualRouterSpec::listeners))
            .setter(setter(Builder::listeners))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listeners").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VirtualRouterListener> builder(MarshallingType.SDK_POJO)
                                            .constructor(VirtualRouterListener::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<VirtualRouterListener> listeners;

    private VirtualRouterSpec(BuilderImpl builder) {
        this.listeners = builder.listeners;
    }

    /**
     * Returns true if the Listeners property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasListeners() {
        return listeners != null && !(listeners instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The listeners that the virtual router is expected to receive inbound traffic from. You can specify one listener.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasListeners()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The listeners that the virtual router is expected to receive inbound traffic from. You can specify one
     *         listener.
     */
    public List<VirtualRouterListener> listeners() {
        return listeners;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasListeners() ? listeners() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualRouterSpec)) {
            return false;
        }
        VirtualRouterSpec other = (VirtualRouterSpec) obj;
        return hasListeners() == other.hasListeners() && Objects.equals(listeners(), other.listeners());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VirtualRouterSpec").add("Listeners", hasListeners() ? listeners() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "listeners":
            return Optional.ofNullable(clazz.cast(listeners()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualRouterSpec, T> g) {
        return obj -> g.apply((VirtualRouterSpec) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualRouterSpec> {
        /**
         * <p>
         * The listeners that the virtual router is expected to receive inbound traffic from. You can specify one
         * listener.
         * </p>
         * 
         * @param listeners
         *        The listeners that the virtual router is expected to receive inbound traffic from. You can specify one
         *        listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listeners(Collection<VirtualRouterListener> listeners);

        /**
         * <p>
         * The listeners that the virtual router is expected to receive inbound traffic from. You can specify one
         * listener.
         * </p>
         * 
         * @param listeners
         *        The listeners that the virtual router is expected to receive inbound traffic from. You can specify one
         *        listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listeners(VirtualRouterListener... listeners);

        /**
         * <p>
         * The listeners that the virtual router is expected to receive inbound traffic from. You can specify one
         * listener.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VirtualRouterListener>.Builder} avoiding
         * the need to create one manually via {@link List<VirtualRouterListener>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VirtualRouterListener>.Builder#build()} is called
         * immediately and its result is passed to {@link #listeners(List<VirtualRouterListener>)}.
         * 
         * @param listeners
         *        a consumer that will call methods on {@link List<VirtualRouterListener>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listeners(List<VirtualRouterListener>)
         */
        Builder listeners(Consumer<VirtualRouterListener.Builder>... listeners);
    }

    static final class BuilderImpl implements Builder {
        private List<VirtualRouterListener> listeners = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualRouterSpec model) {
            listeners(model.listeners);
        }

        public final Collection<VirtualRouterListener.Builder> getListeners() {
            if (listeners instanceof SdkAutoConstructList) {
                return null;
            }
            return listeners != null ? listeners.stream().map(VirtualRouterListener::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder listeners(Collection<VirtualRouterListener> listeners) {
            this.listeners = VirtualRouterListenersCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(VirtualRouterListener... listeners) {
            listeners(Arrays.asList(listeners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Consumer<VirtualRouterListener.Builder>... listeners) {
            listeners(Stream.of(listeners).map(c -> VirtualRouterListener.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setListeners(Collection<VirtualRouterListener.BuilderImpl> listeners) {
            this.listeners = VirtualRouterListenersCopier.copyFromBuilder(listeners);
        }

        @Override
        public VirtualRouterSpec build() {
            return new VirtualRouterSpec(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
