/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a Transport Layer Security (TLS) client policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayClientPolicyTls implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayClientPolicyTls.Builder, VirtualGatewayClientPolicyTls> {
    private static final SdkField<Boolean> ENFORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enforce").getter(getter(VirtualGatewayClientPolicyTls::enforce)).setter(setter(Builder::enforce))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enforce").build()).build();

    private static final SdkField<List<Integer>> PORTS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("ports")
            .getter(getter(VirtualGatewayClientPolicyTls::ports))
            .setter(setter(Builder::ports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VirtualGatewayTlsValidationContext> VALIDATION_FIELD = SdkField
            .<VirtualGatewayTlsValidationContext> builder(MarshallingType.SDK_POJO).memberName("validation")
            .getter(getter(VirtualGatewayClientPolicyTls::validation)).setter(setter(Builder::validation))
            .constructor(VirtualGatewayTlsValidationContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENFORCE_FIELD, PORTS_FIELD,
            VALIDATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enforce;

    private final List<Integer> ports;

    private final VirtualGatewayTlsValidationContext validation;

    private VirtualGatewayClientPolicyTls(BuilderImpl builder) {
        this.enforce = builder.enforce;
        this.ports = builder.ports;
        this.validation = builder.validation;
    }

    /**
     * <p>
     * Whether the policy is enforced. The default is <code>True</code>, if a value isn't specified.
     * </p>
     * 
     * @return Whether the policy is enforced. The default is <code>True</code>, if a value isn't specified.
     */
    public final Boolean enforce() {
        return enforce;
    }

    /**
     * Returns true if the Ports property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPorts() {
        return ports != null && !(ports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more ports that the policy is enforced for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPorts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more ports that the policy is enforced for.
     */
    public final List<Integer> ports() {
        return ports;
    }

    /**
     * <p>
     * A reference to an object that represents a TLS validation context.
     * </p>
     * 
     * @return A reference to an object that represents a TLS validation context.
     */
    public final VirtualGatewayTlsValidationContext validation() {
        return validation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enforce());
        hashCode = 31 * hashCode + Objects.hashCode(hasPorts() ? ports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(validation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayClientPolicyTls)) {
            return false;
        }
        VirtualGatewayClientPolicyTls other = (VirtualGatewayClientPolicyTls) obj;
        return Objects.equals(enforce(), other.enforce()) && hasPorts() == other.hasPorts()
                && Objects.equals(ports(), other.ports()) && Objects.equals(validation(), other.validation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualGatewayClientPolicyTls").add("Enforce", enforce())
                .add("Ports", hasPorts() ? ports() : null).add("Validation", validation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enforce":
            return Optional.ofNullable(clazz.cast(enforce()));
        case "ports":
            return Optional.ofNullable(clazz.cast(ports()));
        case "validation":
            return Optional.ofNullable(clazz.cast(validation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayClientPolicyTls, T> g) {
        return obj -> g.apply((VirtualGatewayClientPolicyTls) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayClientPolicyTls> {
        /**
         * <p>
         * Whether the policy is enforced. The default is <code>True</code>, if a value isn't specified.
         * </p>
         * 
         * @param enforce
         *        Whether the policy is enforced. The default is <code>True</code>, if a value isn't specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enforce(Boolean enforce);

        /**
         * <p>
         * One or more ports that the policy is enforced for.
         * </p>
         * 
         * @param ports
         *        One or more ports that the policy is enforced for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ports(Collection<Integer> ports);

        /**
         * <p>
         * One or more ports that the policy is enforced for.
         * </p>
         * 
         * @param ports
         *        One or more ports that the policy is enforced for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ports(Integer... ports);

        /**
         * <p>
         * A reference to an object that represents a TLS validation context.
         * </p>
         * 
         * @param validation
         *        A reference to an object that represents a TLS validation context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validation(VirtualGatewayTlsValidationContext validation);

        /**
         * <p>
         * A reference to an object that represents a TLS validation context.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualGatewayTlsValidationContext.Builder}
         * avoiding the need to create one manually via {@link VirtualGatewayTlsValidationContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayTlsValidationContext.Builder#build()} is called
         * immediately and its result is passed to {@link #validation(VirtualGatewayTlsValidationContext)}.
         * 
         * @param validation
         *        a consumer that will call methods on {@link VirtualGatewayTlsValidationContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validation(VirtualGatewayTlsValidationContext)
         */
        default Builder validation(Consumer<VirtualGatewayTlsValidationContext.Builder> validation) {
            return validation(VirtualGatewayTlsValidationContext.builder().applyMutation(validation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enforce;

        private List<Integer> ports = DefaultSdkAutoConstructList.getInstance();

        private VirtualGatewayTlsValidationContext validation;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayClientPolicyTls model) {
            enforce(model.enforce);
            ports(model.ports);
            validation(model.validation);
        }

        public final Boolean getEnforce() {
            return enforce;
        }

        @Override
        public final Builder enforce(Boolean enforce) {
            this.enforce = enforce;
            return this;
        }

        public final void setEnforce(Boolean enforce) {
            this.enforce = enforce;
        }

        public final Collection<Integer> getPorts() {
            if (ports instanceof SdkAutoConstructList) {
                return null;
            }
            return ports;
        }

        @Override
        public final Builder ports(Collection<Integer> ports) {
            this.ports = PortSetCopier.copy(ports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ports(Integer... ports) {
            ports(Arrays.asList(ports));
            return this;
        }

        public final void setPorts(Collection<Integer> ports) {
            this.ports = PortSetCopier.copy(ports);
        }

        public final VirtualGatewayTlsValidationContext.Builder getValidation() {
            return validation != null ? validation.toBuilder() : null;
        }

        @Override
        public final Builder validation(VirtualGatewayTlsValidationContext validation) {
            this.validation = validation;
            return this;
        }

        public final void setValidation(VirtualGatewayTlsValidationContext.BuilderImpl validation) {
            this.validation = validation != null ? validation.build() : null;
        }

        @Override
        public VirtualGatewayClientPolicyTls build() {
            return new VirtualGatewayClientPolicyTls(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
