/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a virtual node returned by a list operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualNodeRef implements SdkPojo, Serializable, ToCopyableBuilder<VirtualNodeRef.Builder, VirtualNodeRef> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(VirtualNodeRef::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(VirtualNodeRef::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(VirtualNodeRef::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("meshName").getter(getter(VirtualNodeRef::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()).build();

    private static final SdkField<String> MESH_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("meshOwner").getter(getter(VirtualNodeRef::meshOwner)).setter(setter(Builder::meshOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshOwner").build()).build();

    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceOwner").getter(getter(VirtualNodeRef::resourceOwner)).setter(setter(Builder::resourceOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwner").build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("version")
            .getter(getter(VirtualNodeRef::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> VIRTUAL_NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualNodeName").getter(getter(VirtualNodeRef::virtualNodeName))
            .setter(setter(Builder::virtualNodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualNodeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            LAST_UPDATED_AT_FIELD, MESH_NAME_FIELD, MESH_OWNER_FIELD, RESOURCE_OWNER_FIELD, VERSION_FIELD,
            VIRTUAL_NODE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String meshName;

    private final String meshOwner;

    private final String resourceOwner;

    private final Long version;

    private final String virtualNodeName;

    private VirtualNodeRef(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.meshName = builder.meshName;
        this.meshOwner = builder.meshOwner;
        this.resourceOwner = builder.resourceOwner;
        this.version = builder.version;
        this.virtualNodeName = builder.virtualNodeName;
    }

    /**
     * <p>
     * The full Amazon Resource Name (ARN) for the virtual node.
     * </p>
     * 
     * @return The full Amazon Resource Name (ARN) for the virtual node.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Unix epoch timestamp in seconds for when the resource was created.
     * </p>
     * 
     * @return The Unix epoch timestamp in seconds for when the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix epoch timestamp in seconds for when the resource was last updated.
     * </p>
     * 
     * @return The Unix epoch timestamp in seconds for when the resource was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The name of the service mesh that the virtual node resides in.
     * </p>
     * 
     * @return The name of the service mesh that the virtual node resides in.
     */
    public final String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the
     * account that shared the mesh with your account. For more information about mesh sharing, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
     * </p>
     * 
     * @return The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of
     *         the account that shared the mesh with your account. For more information about mesh sharing, see <a
     *         href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
     */
    public final String meshOwner() {
        return meshOwner;
    }

    /**
     * <p>
     * The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's the ID of the mesh
     * owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
     * </p>
     * 
     * @return The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's the ID of the
     *         mesh owner or of another account that the mesh is shared with. For more information about mesh sharing,
     *         see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared
     *         meshes</a>.
     */
    public final String resourceOwner() {
        return resourceOwner;
    }

    /**
     * <p>
     * The version of the resource. Resources are created at version 1, and this version is incremented each time that
     * they're updated.
     * </p>
     * 
     * @return The version of the resource. Resources are created at version 1, and this version is incremented each
     *         time that they're updated.
     */
    public final Long version() {
        return version;
    }

    /**
     * <p>
     * The name of the virtual node.
     * </p>
     * 
     * @return The name of the virtual node.
     */
    public final String virtualNodeName() {
        return virtualNodeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(meshOwner());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwner());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(virtualNodeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualNodeRef)) {
            return false;
        }
        VirtualNodeRef other = (VirtualNodeRef) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(meshName(), other.meshName())
                && Objects.equals(meshOwner(), other.meshOwner()) && Objects.equals(resourceOwner(), other.resourceOwner())
                && Objects.equals(version(), other.version()) && Objects.equals(virtualNodeName(), other.virtualNodeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualNodeRef").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).add("MeshName", meshName()).add("MeshOwner", meshOwner())
                .add("ResourceOwner", resourceOwner()).add("Version", version()).add("VirtualNodeName", virtualNodeName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "meshOwner":
            return Optional.ofNullable(clazz.cast(meshOwner()));
        case "resourceOwner":
            return Optional.ofNullable(clazz.cast(resourceOwner()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "virtualNodeName":
            return Optional.ofNullable(clazz.cast(virtualNodeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualNodeRef, T> g) {
        return obj -> g.apply((VirtualNodeRef) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualNodeRef> {
        /**
         * <p>
         * The full Amazon Resource Name (ARN) for the virtual node.
         * </p>
         * 
         * @param arn
         *        The full Amazon Resource Name (ARN) for the virtual node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Unix epoch timestamp in seconds for when the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix epoch timestamp in seconds for when the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix epoch timestamp in seconds for when the resource was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The Unix epoch timestamp in seconds for when the resource was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The name of the service mesh that the virtual node resides in.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh that the virtual node resides in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the
         * account that shared the mesh with your account. For more information about mesh sharing, see <a
         * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
         * </p>
         * 
         * @param meshOwner
         *        The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID
         *        of the account that shared the mesh with your account. For more information about mesh sharing, see <a
         *        href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared
         *        meshes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshOwner(String meshOwner);

        /**
         * <p>
         * The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's the ID of the mesh
         * owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a
         * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
         * </p>
         * 
         * @param resourceOwner
         *        The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's the ID of
         *        the mesh owner or of another account that the mesh is shared with. For more information about mesh
         *        sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with
         *        shared meshes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceOwner(String resourceOwner);

        /**
         * <p>
         * The version of the resource. Resources are created at version 1, and this version is incremented each time
         * that they're updated.
         * </p>
         * 
         * @param version
         *        The version of the resource. Resources are created at version 1, and this version is incremented each
         *        time that they're updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The name of the virtual node.
         * </p>
         * 
         * @param virtualNodeName
         *        The name of the virtual node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualNodeName(String virtualNodeName);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String meshName;

        private String meshOwner;

        private String resourceOwner;

        private Long version;

        private String virtualNodeName;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualNodeRef model) {
            arn(model.arn);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            meshName(model.meshName);
            meshOwner(model.meshOwner);
            resourceOwner(model.resourceOwner);
            version(model.version);
            virtualNodeName(model.virtualNodeName);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getMeshName() {
            return meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final String getMeshOwner() {
            return meshOwner;
        }

        @Override
        public final Builder meshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
            return this;
        }

        public final void setMeshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
        }

        public final String getResourceOwner() {
            return resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        public final Long getVersion() {
            return version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public final String getVirtualNodeName() {
            return virtualNodeName;
        }

        @Override
        public final Builder virtualNodeName(String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
            return this;
        }

        public final void setVirtualNodeName(String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
        }

        @Override
        public VirtualNodeRef build() {
            return new VirtualNodeRef(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
