/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a Transport Layer Security (TLS) validation context trust.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TlsValidationContextTrust implements SdkPojo, Serializable,
        ToCopyableBuilder<TlsValidationContextTrust.Builder, TlsValidationContextTrust> {
    private static final SdkField<TlsValidationContextAcmTrust> ACM_FIELD = SdkField
            .<TlsValidationContextAcmTrust> builder(MarshallingType.SDK_POJO).memberName("acm")
            .getter(getter(TlsValidationContextTrust::acm)).setter(setter(Builder::acm))
            .constructor(TlsValidationContextAcmTrust::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acm").build()).build();

    private static final SdkField<TlsValidationContextFileTrust> FILE_FIELD = SdkField
            .<TlsValidationContextFileTrust> builder(MarshallingType.SDK_POJO).memberName("file")
            .getter(getter(TlsValidationContextTrust::file)).setter(setter(Builder::file))
            .constructor(TlsValidationContextFileTrust::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACM_FIELD, FILE_FIELD));

    private static final long serialVersionUID = 1L;

    private final TlsValidationContextAcmTrust acm;

    private final TlsValidationContextFileTrust file;

    private TlsValidationContextTrust(BuilderImpl builder) {
        this.acm = builder.acm;
        this.file = builder.file;
    }

    /**
     * <p>
     * A reference to an object that represents a TLS validation context trust for an AWS Certicate Manager (ACM)
     * certificate.
     * </p>
     * 
     * @return A reference to an object that represents a TLS validation context trust for an AWS Certicate Manager
     *         (ACM) certificate.
     */
    public final TlsValidationContextAcmTrust acm() {
        return acm;
    }

    /**
     * <p>
     * An object that represents a TLS validation context trust for a local file.
     * </p>
     * 
     * @return An object that represents a TLS validation context trust for a local file.
     */
    public final TlsValidationContextFileTrust file() {
        return file;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acm());
        hashCode = 31 * hashCode + Objects.hashCode(file());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TlsValidationContextTrust)) {
            return false;
        }
        TlsValidationContextTrust other = (TlsValidationContextTrust) obj;
        return Objects.equals(acm(), other.acm()) && Objects.equals(file(), other.file());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TlsValidationContextTrust").add("Acm", acm()).add("File", file()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acm":
            return Optional.ofNullable(clazz.cast(acm()));
        case "file":
            return Optional.ofNullable(clazz.cast(file()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TlsValidationContextTrust, T> g) {
        return obj -> g.apply((TlsValidationContextTrust) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TlsValidationContextTrust> {
        /**
         * <p>
         * A reference to an object that represents a TLS validation context trust for an AWS Certicate Manager (ACM)
         * certificate.
         * </p>
         * 
         * @param acm
         *        A reference to an object that represents a TLS validation context trust for an AWS Certicate Manager
         *        (ACM) certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acm(TlsValidationContextAcmTrust acm);

        /**
         * <p>
         * A reference to an object that represents a TLS validation context trust for an AWS Certicate Manager (ACM)
         * certificate.
         * </p>
         * This is a convenience that creates an instance of the {@link TlsValidationContextAcmTrust.Builder} avoiding
         * the need to create one manually via {@link TlsValidationContextAcmTrust#builder()}.
         *
         * When the {@link Consumer} completes, {@link TlsValidationContextAcmTrust.Builder#build()} is called
         * immediately and its result is passed to {@link #acm(TlsValidationContextAcmTrust)}.
         * 
         * @param acm
         *        a consumer that will call methods on {@link TlsValidationContextAcmTrust.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acm(TlsValidationContextAcmTrust)
         */
        default Builder acm(Consumer<TlsValidationContextAcmTrust.Builder> acm) {
            return acm(TlsValidationContextAcmTrust.builder().applyMutation(acm).build());
        }

        /**
         * <p>
         * An object that represents a TLS validation context trust for a local file.
         * </p>
         * 
         * @param file
         *        An object that represents a TLS validation context trust for a local file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(TlsValidationContextFileTrust file);

        /**
         * <p>
         * An object that represents a TLS validation context trust for a local file.
         * </p>
         * This is a convenience that creates an instance of the {@link TlsValidationContextFileTrust.Builder} avoiding
         * the need to create one manually via {@link TlsValidationContextFileTrust#builder()}.
         *
         * When the {@link Consumer} completes, {@link TlsValidationContextFileTrust.Builder#build()} is called
         * immediately and its result is passed to {@link #file(TlsValidationContextFileTrust)}.
         * 
         * @param file
         *        a consumer that will call methods on {@link TlsValidationContextFileTrust.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #file(TlsValidationContextFileTrust)
         */
        default Builder file(Consumer<TlsValidationContextFileTrust.Builder> file) {
            return file(TlsValidationContextFileTrust.builder().applyMutation(file).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TlsValidationContextAcmTrust acm;

        private TlsValidationContextFileTrust file;

        private BuilderImpl() {
        }

        private BuilderImpl(TlsValidationContextTrust model) {
            acm(model.acm);
            file(model.file);
        }

        public final TlsValidationContextAcmTrust.Builder getAcm() {
            return acm != null ? acm.toBuilder() : null;
        }

        @Override
        public final Builder acm(TlsValidationContextAcmTrust acm) {
            this.acm = acm;
            return this;
        }

        public final void setAcm(TlsValidationContextAcmTrust.BuilderImpl acm) {
            this.acm = acm != null ? acm.build() : null;
        }

        public final TlsValidationContextFileTrust.Builder getFile() {
            return file != null ? file.toBuilder() : null;
        }

        @Override
        public final Builder file(TlsValidationContextFileTrust file) {
            this.file = file;
            return this;
        }

        public final void setFile(TlsValidationContextFileTrust.BuilderImpl file) {
            this.file = file != null ? file.build() : null;
        }

        @Override
        public TlsValidationContextTrust build() {
            return new TlsValidationContextTrust(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
