/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a gateway route specification. Specify one gateway route type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GatewayRouteSpec implements SdkPojo, Serializable,
        ToCopyableBuilder<GatewayRouteSpec.Builder, GatewayRouteSpec> {
    private static final SdkField<GrpcGatewayRoute> GRPC_ROUTE_FIELD = SdkField
            .<GrpcGatewayRoute> builder(MarshallingType.SDK_POJO).memberName("grpcRoute")
            .getter(getter(GatewayRouteSpec::grpcRoute)).setter(setter(Builder::grpcRoute))
            .constructor(GrpcGatewayRoute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grpcRoute").build()).build();

    private static final SdkField<HttpGatewayRoute> HTTP2_ROUTE_FIELD = SdkField
            .<HttpGatewayRoute> builder(MarshallingType.SDK_POJO).memberName("http2Route")
            .getter(getter(GatewayRouteSpec::http2Route)).setter(setter(Builder::http2Route))
            .constructor(HttpGatewayRoute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("http2Route").build()).build();

    private static final SdkField<HttpGatewayRoute> HTTP_ROUTE_FIELD = SdkField
            .<HttpGatewayRoute> builder(MarshallingType.SDK_POJO).memberName("httpRoute")
            .getter(getter(GatewayRouteSpec::httpRoute)).setter(setter(Builder::httpRoute))
            .constructor(HttpGatewayRoute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpRoute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRPC_ROUTE_FIELD,
            HTTP2_ROUTE_FIELD, HTTP_ROUTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final GrpcGatewayRoute grpcRoute;

    private final HttpGatewayRoute http2Route;

    private final HttpGatewayRoute httpRoute;

    private GatewayRouteSpec(BuilderImpl builder) {
        this.grpcRoute = builder.grpcRoute;
        this.http2Route = builder.http2Route;
        this.httpRoute = builder.httpRoute;
    }

    /**
     * <p>
     * An object that represents the specification of a gRPC gateway route.
     * </p>
     * 
     * @return An object that represents the specification of a gRPC gateway route.
     */
    public final GrpcGatewayRoute grpcRoute() {
        return grpcRoute;
    }

    /**
     * <p>
     * An object that represents the specification of an HTTP/2 gateway route.
     * </p>
     * 
     * @return An object that represents the specification of an HTTP/2 gateway route.
     */
    public final HttpGatewayRoute http2Route() {
        return http2Route;
    }

    /**
     * <p>
     * An object that represents the specification of an HTTP gateway route.
     * </p>
     * 
     * @return An object that represents the specification of an HTTP gateway route.
     */
    public final HttpGatewayRoute httpRoute() {
        return httpRoute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(grpcRoute());
        hashCode = 31 * hashCode + Objects.hashCode(http2Route());
        hashCode = 31 * hashCode + Objects.hashCode(httpRoute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayRouteSpec)) {
            return false;
        }
        GatewayRouteSpec other = (GatewayRouteSpec) obj;
        return Objects.equals(grpcRoute(), other.grpcRoute()) && Objects.equals(http2Route(), other.http2Route())
                && Objects.equals(httpRoute(), other.httpRoute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GatewayRouteSpec").add("GrpcRoute", grpcRoute()).add("Http2Route", http2Route())
                .add("HttpRoute", httpRoute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "grpcRoute":
            return Optional.ofNullable(clazz.cast(grpcRoute()));
        case "http2Route":
            return Optional.ofNullable(clazz.cast(http2Route()));
        case "httpRoute":
            return Optional.ofNullable(clazz.cast(httpRoute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GatewayRouteSpec, T> g) {
        return obj -> g.apply((GatewayRouteSpec) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GatewayRouteSpec> {
        /**
         * <p>
         * An object that represents the specification of a gRPC gateway route.
         * </p>
         * 
         * @param grpcRoute
         *        An object that represents the specification of a gRPC gateway route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grpcRoute(GrpcGatewayRoute grpcRoute);

        /**
         * <p>
         * An object that represents the specification of a gRPC gateway route.
         * </p>
         * This is a convenience that creates an instance of the {@link GrpcGatewayRoute.Builder} avoiding the need to
         * create one manually via {@link GrpcGatewayRoute#builder()}.
         *
         * When the {@link Consumer} completes, {@link GrpcGatewayRoute.Builder#build()} is called immediately and its
         * result is passed to {@link #grpcRoute(GrpcGatewayRoute)}.
         * 
         * @param grpcRoute
         *        a consumer that will call methods on {@link GrpcGatewayRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grpcRoute(GrpcGatewayRoute)
         */
        default Builder grpcRoute(Consumer<GrpcGatewayRoute.Builder> grpcRoute) {
            return grpcRoute(GrpcGatewayRoute.builder().applyMutation(grpcRoute).build());
        }

        /**
         * <p>
         * An object that represents the specification of an HTTP/2 gateway route.
         * </p>
         * 
         * @param http2Route
         *        An object that represents the specification of an HTTP/2 gateway route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder http2Route(HttpGatewayRoute http2Route);

        /**
         * <p>
         * An object that represents the specification of an HTTP/2 gateway route.
         * </p>
         * This is a convenience that creates an instance of the {@link HttpGatewayRoute.Builder} avoiding the need to
         * create one manually via {@link HttpGatewayRoute#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpGatewayRoute.Builder#build()} is called immediately and its
         * result is passed to {@link #http2Route(HttpGatewayRoute)}.
         * 
         * @param http2Route
         *        a consumer that will call methods on {@link HttpGatewayRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #http2Route(HttpGatewayRoute)
         */
        default Builder http2Route(Consumer<HttpGatewayRoute.Builder> http2Route) {
            return http2Route(HttpGatewayRoute.builder().applyMutation(http2Route).build());
        }

        /**
         * <p>
         * An object that represents the specification of an HTTP gateway route.
         * </p>
         * 
         * @param httpRoute
         *        An object that represents the specification of an HTTP gateway route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpRoute(HttpGatewayRoute httpRoute);

        /**
         * <p>
         * An object that represents the specification of an HTTP gateway route.
         * </p>
         * This is a convenience that creates an instance of the {@link HttpGatewayRoute.Builder} avoiding the need to
         * create one manually via {@link HttpGatewayRoute#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpGatewayRoute.Builder#build()} is called immediately and its
         * result is passed to {@link #httpRoute(HttpGatewayRoute)}.
         * 
         * @param httpRoute
         *        a consumer that will call methods on {@link HttpGatewayRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpRoute(HttpGatewayRoute)
         */
        default Builder httpRoute(Consumer<HttpGatewayRoute.Builder> httpRoute) {
            return httpRoute(HttpGatewayRoute.builder().applyMutation(httpRoute).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GrpcGatewayRoute grpcRoute;

        private HttpGatewayRoute http2Route;

        private HttpGatewayRoute httpRoute;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayRouteSpec model) {
            grpcRoute(model.grpcRoute);
            http2Route(model.http2Route);
            httpRoute(model.httpRoute);
        }

        public final GrpcGatewayRoute.Builder getGrpcRoute() {
            return grpcRoute != null ? grpcRoute.toBuilder() : null;
        }

        @Override
        public final Builder grpcRoute(GrpcGatewayRoute grpcRoute) {
            this.grpcRoute = grpcRoute;
            return this;
        }

        public final void setGrpcRoute(GrpcGatewayRoute.BuilderImpl grpcRoute) {
            this.grpcRoute = grpcRoute != null ? grpcRoute.build() : null;
        }

        public final HttpGatewayRoute.Builder getHttp2Route() {
            return http2Route != null ? http2Route.toBuilder() : null;
        }

        @Override
        public final Builder http2Route(HttpGatewayRoute http2Route) {
            this.http2Route = http2Route;
            return this;
        }

        public final void setHttp2Route(HttpGatewayRoute.BuilderImpl http2Route) {
            this.http2Route = http2Route != null ? http2Route.build() : null;
        }

        public final HttpGatewayRoute.Builder getHttpRoute() {
            return httpRoute != null ? httpRoute.toBuilder() : null;
        }

        @Override
        public final Builder httpRoute(HttpGatewayRoute httpRoute) {
            this.httpRoute = httpRoute;
            return this;
        }

        public final void setHttpRoute(HttpGatewayRoute.BuilderImpl httpRoute) {
            this.httpRoute = httpRoute != null ? httpRoute.build() : null;
        }

        @Override
        public GatewayRouteSpec build() {
            return new GatewayRouteSpec(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
