/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <zonbook></zonbook><xhtml></xhtml>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVirtualNodeRequest extends AppMeshRequest implements
        ToCopyableBuilder<UpdateVirtualNodeRequest.Builder, UpdateVirtualNodeRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateVirtualNodeRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("meshName").getter(getter(UpdateVirtualNodeRequest::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()).build();

    private static final SdkField<String> MESH_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("meshOwner").getter(getter(UpdateVirtualNodeRequest::meshOwner)).setter(setter(Builder::meshOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("meshOwner").build()).build();

    private static final SdkField<VirtualNodeSpec> SPEC_FIELD = SdkField.<VirtualNodeSpec> builder(MarshallingType.SDK_POJO)
            .memberName("spec").getter(getter(UpdateVirtualNodeRequest::spec)).setter(setter(Builder::spec))
            .constructor(VirtualNodeSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<String> VIRTUAL_NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualNodeName").getter(getter(UpdateVirtualNodeRequest::virtualNodeName))
            .setter(setter(Builder::virtualNodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualNodeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            MESH_NAME_FIELD, MESH_OWNER_FIELD, SPEC_FIELD, VIRTUAL_NODE_NAME_FIELD));

    private final String clientToken;

    private final String meshName;

    private final String meshOwner;

    private final VirtualNodeSpec spec;

    private final String virtualNodeName;

    private UpdateVirtualNodeRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.meshName = builder.meshName;
        this.meshOwner = builder.meshOwner;
        this.spec = builder.spec;
        this.virtualNodeName = builder.virtualNodeName;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters,
     * numbers, hyphens, and underscores are allowed.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
     *         letters, numbers, hyphens, and underscores are allowed.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name of the service mesh that the virtual node resides in.
     * </p>
     * 
     * @return The name of the service mesh that the virtual node resides in.
     */
    public final String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the
     * account that shared the mesh with your account. For more information about mesh sharing, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
     * </p>
     * 
     * @return The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of
     *         the account that shared the mesh with your account. For more information about mesh sharing, see <a
     *         href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
     */
    public final String meshOwner() {
        return meshOwner;
    }

    /**
     * <p>
     * The new virtual node specification to apply. This overwrites the existing data.
     * </p>
     * 
     * @return The new virtual node specification to apply. This overwrites the existing data.
     */
    public final VirtualNodeSpec spec() {
        return spec;
    }

    /**
     * <p>
     * The name of the virtual node to update.
     * </p>
     * 
     * @return The name of the virtual node to update.
     */
    public final String virtualNodeName() {
        return virtualNodeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(meshOwner());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(virtualNodeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVirtualNodeRequest)) {
            return false;
        }
        UpdateVirtualNodeRequest other = (UpdateVirtualNodeRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(meshName(), other.meshName())
                && Objects.equals(meshOwner(), other.meshOwner()) && Objects.equals(spec(), other.spec())
                && Objects.equals(virtualNodeName(), other.virtualNodeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVirtualNodeRequest").add("ClientToken", clientToken()).add("MeshName", meshName())
                .add("MeshOwner", meshOwner()).add("Spec", spec()).add("VirtualNodeName", virtualNodeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "meshOwner":
            return Optional.ofNullable(clazz.cast(meshOwner()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "virtualNodeName":
            return Optional.ofNullable(clazz.cast(virtualNodeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVirtualNodeRequest, T> g) {
        return obj -> g.apply((UpdateVirtualNodeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateVirtualNodeRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
         * letters, numbers, hyphens, and underscores are allowed.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
         *        letters, numbers, hyphens, and underscores are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name of the service mesh that the virtual node resides in.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh that the virtual node resides in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the
         * account that shared the mesh with your account. For more information about mesh sharing, see <a
         * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
         * </p>
         * 
         * @param meshOwner
         *        The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID
         *        of the account that shared the mesh with your account. For more information about mesh sharing, see <a
         *        href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared
         *        meshes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshOwner(String meshOwner);

        /**
         * <p>
         * The new virtual node specification to apply. This overwrites the existing data.
         * </p>
         * 
         * @param spec
         *        The new virtual node specification to apply. This overwrites the existing data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(VirtualNodeSpec spec);

        /**
         * <p>
         * The new virtual node specification to apply. This overwrites the existing data.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualNodeSpec.Builder} avoiding the need to
         * create one manually via {@link VirtualNodeSpec#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualNodeSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #spec(VirtualNodeSpec)}.
         * 
         * @param spec
         *        a consumer that will call methods on {@link VirtualNodeSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spec(VirtualNodeSpec)
         */
        default Builder spec(Consumer<VirtualNodeSpec.Builder> spec) {
            return spec(VirtualNodeSpec.builder().applyMutation(spec).build());
        }

        /**
         * <p>
         * The name of the virtual node to update.
         * </p>
         * 
         * @param virtualNodeName
         *        The name of the virtual node to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualNodeName(String virtualNodeName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppMeshRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String meshName;

        private String meshOwner;

        private VirtualNodeSpec spec;

        private String virtualNodeName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVirtualNodeRequest model) {
            super(model);
            clientToken(model.clientToken);
            meshName(model.meshName);
            meshOwner(model.meshOwner);
            spec(model.spec);
            virtualNodeName(model.virtualNodeName);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getMeshName() {
            return meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final String getMeshOwner() {
            return meshOwner;
        }

        @Override
        public final Builder meshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
            return this;
        }

        public final void setMeshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
        }

        public final VirtualNodeSpec.Builder getSpec() {
            return spec != null ? spec.toBuilder() : null;
        }

        @Override
        public final Builder spec(VirtualNodeSpec spec) {
            this.spec = spec;
            return this;
        }

        public final void setSpec(VirtualNodeSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        public final String getVirtualNodeName() {
            return virtualNodeName;
        }

        @Override
        public final Builder virtualNodeName(String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
            return this;
        }

        public final void setVirtualNodeName(String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVirtualNodeRequest build() {
            return new UpdateVirtualNodeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
