/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a virtual gateway's listener's Transport Layer Security (TLS) Secret Discovery Service
 * validation context trust. The proxy must be configured with a local SDS provider via a Unix Domain Socket. See App
 * Mesh <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">TLS documentation</a> for more info.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayTlsValidationContextSdsTrust implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayTlsValidationContextSdsTrust.Builder, VirtualGatewayTlsValidationContextSdsTrust> {
    private static final SdkField<String> SECRET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretName").getter(getter(VirtualGatewayTlsValidationContextSdsTrust::secretName))
            .setter(setter(Builder::secretName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String secretName;

    private VirtualGatewayTlsValidationContextSdsTrust(BuilderImpl builder) {
        this.secretName = builder.secretName;
    }

    /**
     * <p>
     * A reference to an object that represents the name of the secret for a virtual gateway's Transport Layer Security
     * (TLS) Secret Discovery Service validation context trust.
     * </p>
     * 
     * @return A reference to an object that represents the name of the secret for a virtual gateway's Transport Layer
     *         Security (TLS) Secret Discovery Service validation context trust.
     */
    public final String secretName() {
        return secretName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayTlsValidationContextSdsTrust)) {
            return false;
        }
        VirtualGatewayTlsValidationContextSdsTrust other = (VirtualGatewayTlsValidationContextSdsTrust) obj;
        return Objects.equals(secretName(), other.secretName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualGatewayTlsValidationContextSdsTrust").add("SecretName", secretName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "secretName":
            return Optional.ofNullable(clazz.cast(secretName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayTlsValidationContextSdsTrust, T> g) {
        return obj -> g.apply((VirtualGatewayTlsValidationContextSdsTrust) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayTlsValidationContextSdsTrust> {
        /**
         * <p>
         * A reference to an object that represents the name of the secret for a virtual gateway's Transport Layer
         * Security (TLS) Secret Discovery Service validation context trust.
         * </p>
         * 
         * @param secretName
         *        A reference to an object that represents the name of the secret for a virtual gateway's Transport
         *        Layer Security (TLS) Secret Discovery Service validation context trust.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretName(String secretName);
    }

    static final class BuilderImpl implements Builder {
        private String secretName;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayTlsValidationContextSdsTrust model) {
            secretName(model.secretName);
        }

        public final String getSecretName() {
            return secretName;
        }

        @Override
        public final Builder secretName(String secretName) {
            this.secretName = secretName;
            return this;
        }

        public final void setSecretName(String secretName) {
            this.secretName = secretName;
        }

        @Override
        public VirtualGatewayTlsValidationContextSdsTrust build() {
            return new VirtualGatewayTlsValidationContextSdsTrust(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
