/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the provider for a virtual service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualServiceProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualServiceProvider.Builder, VirtualServiceProvider> {
    private static final SdkField<VirtualNodeServiceProvider> VIRTUAL_NODE_FIELD = SdkField
            .<VirtualNodeServiceProvider> builder(MarshallingType.SDK_POJO).memberName("virtualNode")
            .getter(getter(VirtualServiceProvider::virtualNode)).setter(setter(Builder::virtualNode))
            .constructor(VirtualNodeServiceProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualNode").build()).build();

    private static final SdkField<VirtualRouterServiceProvider> VIRTUAL_ROUTER_FIELD = SdkField
            .<VirtualRouterServiceProvider> builder(MarshallingType.SDK_POJO).memberName("virtualRouter")
            .getter(getter(VirtualServiceProvider::virtualRouter)).setter(setter(Builder::virtualRouter))
            .constructor(VirtualRouterServiceProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualRouter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_NODE_FIELD,
            VIRTUAL_ROUTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final VirtualNodeServiceProvider virtualNode;

    private final VirtualRouterServiceProvider virtualRouter;

    private VirtualServiceProvider(BuilderImpl builder) {
        this.virtualNode = builder.virtualNode;
        this.virtualRouter = builder.virtualRouter;
    }

    /**
     * <p>
     * The virtual node associated with a virtual service.
     * </p>
     * 
     * @return The virtual node associated with a virtual service.
     */
    public final VirtualNodeServiceProvider virtualNode() {
        return virtualNode;
    }

    /**
     * <p>
     * The virtual router associated with a virtual service.
     * </p>
     * 
     * @return The virtual router associated with a virtual service.
     */
    public final VirtualRouterServiceProvider virtualRouter() {
        return virtualRouter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(virtualNode());
        hashCode = 31 * hashCode + Objects.hashCode(virtualRouter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualServiceProvider)) {
            return false;
        }
        VirtualServiceProvider other = (VirtualServiceProvider) obj;
        return Objects.equals(virtualNode(), other.virtualNode()) && Objects.equals(virtualRouter(), other.virtualRouter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualServiceProvider").add("VirtualNode", virtualNode()).add("VirtualRouter", virtualRouter())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualNode":
            return Optional.ofNullable(clazz.cast(virtualNode()));
        case "virtualRouter":
            return Optional.ofNullable(clazz.cast(virtualRouter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualServiceProvider, T> g) {
        return obj -> g.apply((VirtualServiceProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualServiceProvider> {
        /**
         * <p>
         * The virtual node associated with a virtual service.
         * </p>
         * 
         * @param virtualNode
         *        The virtual node associated with a virtual service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualNode(VirtualNodeServiceProvider virtualNode);

        /**
         * <p>
         * The virtual node associated with a virtual service.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualNodeServiceProvider.Builder} avoiding the
         * need to create one manually via {@link VirtualNodeServiceProvider#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualNodeServiceProvider.Builder#build()} is called immediately
         * and its result is passed to {@link #virtualNode(VirtualNodeServiceProvider)}.
         * 
         * @param virtualNode
         *        a consumer that will call methods on {@link VirtualNodeServiceProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualNode(VirtualNodeServiceProvider)
         */
        default Builder virtualNode(Consumer<VirtualNodeServiceProvider.Builder> virtualNode) {
            return virtualNode(VirtualNodeServiceProvider.builder().applyMutation(virtualNode).build());
        }

        /**
         * <p>
         * The virtual router associated with a virtual service.
         * </p>
         * 
         * @param virtualRouter
         *        The virtual router associated with a virtual service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualRouter(VirtualRouterServiceProvider virtualRouter);

        /**
         * <p>
         * The virtual router associated with a virtual service.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualRouterServiceProvider.Builder} avoiding
         * the need to create one manually via {@link VirtualRouterServiceProvider#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualRouterServiceProvider.Builder#build()} is called
         * immediately and its result is passed to {@link #virtualRouter(VirtualRouterServiceProvider)}.
         * 
         * @param virtualRouter
         *        a consumer that will call methods on {@link VirtualRouterServiceProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualRouter(VirtualRouterServiceProvider)
         */
        default Builder virtualRouter(Consumer<VirtualRouterServiceProvider.Builder> virtualRouter) {
            return virtualRouter(VirtualRouterServiceProvider.builder().applyMutation(virtualRouter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VirtualNodeServiceProvider virtualNode;

        private VirtualRouterServiceProvider virtualRouter;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualServiceProvider model) {
            virtualNode(model.virtualNode);
            virtualRouter(model.virtualRouter);
        }

        public final VirtualNodeServiceProvider.Builder getVirtualNode() {
            return virtualNode != null ? virtualNode.toBuilder() : null;
        }

        @Override
        public final Builder virtualNode(VirtualNodeServiceProvider virtualNode) {
            this.virtualNode = virtualNode;
            return this;
        }

        public final void setVirtualNode(VirtualNodeServiceProvider.BuilderImpl virtualNode) {
            this.virtualNode = virtualNode != null ? virtualNode.build() : null;
        }

        public final VirtualRouterServiceProvider.Builder getVirtualRouter() {
            return virtualRouter != null ? virtualRouter.toBuilder() : null;
        }

        @Override
        public final Builder virtualRouter(VirtualRouterServiceProvider virtualRouter) {
            this.virtualRouter = virtualRouter;
            return this;
        }

        public final void setVirtualRouter(VirtualRouterServiceProvider.BuilderImpl virtualRouter) {
            this.virtualRouter = virtualRouter != null ? virtualRouter.build() : null;
        }

        @Override
        public VirtualServiceProvider build() {
            return new VirtualServiceProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
