/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the service discovery information for a virtual node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceDiscovery implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceDiscovery.Builder, ServiceDiscovery> {
    private static final SdkField<AwsCloudMapServiceDiscovery> AWS_CLOUD_MAP_FIELD = SdkField
            .<AwsCloudMapServiceDiscovery> builder(MarshallingType.SDK_POJO).memberName("awsCloudMap")
            .getter(getter(ServiceDiscovery::awsCloudMap)).setter(setter(Builder::awsCloudMap))
            .constructor(AwsCloudMapServiceDiscovery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsCloudMap").build()).build();

    private static final SdkField<DnsServiceDiscovery> DNS_FIELD = SdkField
            .<DnsServiceDiscovery> builder(MarshallingType.SDK_POJO).memberName("dns").getter(getter(ServiceDiscovery::dns))
            .setter(setter(Builder::dns)).constructor(DnsServiceDiscovery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dns").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AWS_CLOUD_MAP_FIELD, DNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsCloudMapServiceDiscovery awsCloudMap;

    private final DnsServiceDiscovery dns;

    private ServiceDiscovery(BuilderImpl builder) {
        this.awsCloudMap = builder.awsCloudMap;
        this.dns = builder.dns;
    }

    /**
     * <p>
     * Specifies any AWS Cloud Map information for the virtual node.
     * </p>
     * 
     * @return Specifies any AWS Cloud Map information for the virtual node.
     */
    public AwsCloudMapServiceDiscovery awsCloudMap() {
        return awsCloudMap;
    }

    /**
     * <p>
     * Specifies the DNS information for the virtual node.
     * </p>
     * 
     * @return Specifies the DNS information for the virtual node.
     */
    public DnsServiceDiscovery dns() {
        return dns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsCloudMap());
        hashCode = 31 * hashCode + Objects.hashCode(dns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDiscovery)) {
            return false;
        }
        ServiceDiscovery other = (ServiceDiscovery) obj;
        return Objects.equals(awsCloudMap(), other.awsCloudMap()) && Objects.equals(dns(), other.dns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServiceDiscovery").add("AwsCloudMap", awsCloudMap()).add("Dns", dns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsCloudMap":
            return Optional.ofNullable(clazz.cast(awsCloudMap()));
        case "dns":
            return Optional.ofNullable(clazz.cast(dns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceDiscovery, T> g) {
        return obj -> g.apply((ServiceDiscovery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceDiscovery> {
        /**
         * <p>
         * Specifies any AWS Cloud Map information for the virtual node.
         * </p>
         * 
         * @param awsCloudMap
         *        Specifies any AWS Cloud Map information for the virtual node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsCloudMap(AwsCloudMapServiceDiscovery awsCloudMap);

        /**
         * <p>
         * Specifies any AWS Cloud Map information for the virtual node.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsCloudMapServiceDiscovery.Builder} avoiding
         * the need to create one manually via {@link AwsCloudMapServiceDiscovery#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsCloudMapServiceDiscovery.Builder#build()} is called
         * immediately and its result is passed to {@link #awsCloudMap(AwsCloudMapServiceDiscovery)}.
         * 
         * @param awsCloudMap
         *        a consumer that will call methods on {@link AwsCloudMapServiceDiscovery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsCloudMap(AwsCloudMapServiceDiscovery)
         */
        default Builder awsCloudMap(Consumer<AwsCloudMapServiceDiscovery.Builder> awsCloudMap) {
            return awsCloudMap(AwsCloudMapServiceDiscovery.builder().applyMutation(awsCloudMap).build());
        }

        /**
         * <p>
         * Specifies the DNS information for the virtual node.
         * </p>
         * 
         * @param dns
         *        Specifies the DNS information for the virtual node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dns(DnsServiceDiscovery dns);

        /**
         * <p>
         * Specifies the DNS information for the virtual node.
         * </p>
         * This is a convenience that creates an instance of the {@link DnsServiceDiscovery.Builder} avoiding the need
         * to create one manually via {@link DnsServiceDiscovery#builder()}.
         *
         * When the {@link Consumer} completes, {@link DnsServiceDiscovery.Builder#build()} is called immediately and
         * its result is passed to {@link #dns(DnsServiceDiscovery)}.
         * 
         * @param dns
         *        a consumer that will call methods on {@link DnsServiceDiscovery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dns(DnsServiceDiscovery)
         */
        default Builder dns(Consumer<DnsServiceDiscovery.Builder> dns) {
            return dns(DnsServiceDiscovery.builder().applyMutation(dns).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsCloudMapServiceDiscovery awsCloudMap;

        private DnsServiceDiscovery dns;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceDiscovery model) {
            awsCloudMap(model.awsCloudMap);
            dns(model.dns);
        }

        public final AwsCloudMapServiceDiscovery.Builder getAwsCloudMap() {
            return awsCloudMap != null ? awsCloudMap.toBuilder() : null;
        }

        @Override
        public final Builder awsCloudMap(AwsCloudMapServiceDiscovery awsCloudMap) {
            this.awsCloudMap = awsCloudMap;
            return this;
        }

        public final void setAwsCloudMap(AwsCloudMapServiceDiscovery.BuilderImpl awsCloudMap) {
            this.awsCloudMap = awsCloudMap != null ? awsCloudMap.build() : null;
        }

        public final DnsServiceDiscovery.Builder getDns() {
            return dns != null ? dns.toBuilder() : null;
        }

        @Override
        public final Builder dns(DnsServiceDiscovery dns) {
            this.dns = dns;
            return this;
        }

        public final void setDns(DnsServiceDiscovery.BuilderImpl dns) {
            this.dns = dns != null ? dns.build() : null;
        }

        @Override
        public ServiceDiscovery build() {
            return new ServiceDiscovery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
