/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the specification of a service mesh resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewaySpec implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewaySpec.Builder, VirtualGatewaySpec> {
    private static final SdkField<VirtualGatewayBackendDefaults> BACKEND_DEFAULTS_FIELD = SdkField
            .<VirtualGatewayBackendDefaults> builder(MarshallingType.SDK_POJO).memberName("backendDefaults")
            .getter(getter(VirtualGatewaySpec::backendDefaults)).setter(setter(Builder::backendDefaults))
            .constructor(VirtualGatewayBackendDefaults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendDefaults").build()).build();

    private static final SdkField<List<VirtualGatewayListener>> LISTENERS_FIELD = SdkField
            .<List<VirtualGatewayListener>> builder(MarshallingType.LIST)
            .memberName("listeners")
            .getter(getter(VirtualGatewaySpec::listeners))
            .setter(setter(Builder::listeners))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listeners").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VirtualGatewayListener> builder(MarshallingType.SDK_POJO)
                                            .constructor(VirtualGatewayListener::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VirtualGatewayLogging> LOGGING_FIELD = SdkField
            .<VirtualGatewayLogging> builder(MarshallingType.SDK_POJO).memberName("logging")
            .getter(getter(VirtualGatewaySpec::logging)).setter(setter(Builder::logging))
            .constructor(VirtualGatewayLogging::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKEND_DEFAULTS_FIELD,
            LISTENERS_FIELD, LOGGING_FIELD));

    private static final long serialVersionUID = 1L;

    private final VirtualGatewayBackendDefaults backendDefaults;

    private final List<VirtualGatewayListener> listeners;

    private final VirtualGatewayLogging logging;

    private VirtualGatewaySpec(BuilderImpl builder) {
        this.backendDefaults = builder.backendDefaults;
        this.listeners = builder.listeners;
        this.logging = builder.logging;
    }

    /**
     * <p>
     * A reference to an object that represents the defaults for backends.
     * </p>
     * 
     * @return A reference to an object that represents the defaults for backends.
     */
    public VirtualGatewayBackendDefaults backendDefaults() {
        return backendDefaults;
    }

    /**
     * Returns true if the Listeners property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasListeners() {
        return listeners != null && !(listeners instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The listeners that the mesh endpoint is expected to receive inbound traffic from. You can specify one listener.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasListeners()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The listeners that the mesh endpoint is expected to receive inbound traffic from. You can specify one
     *         listener.
     */
    public List<VirtualGatewayListener> listeners() {
        return listeners;
    }

    /**
     * Returns the value of the Logging property for this object.
     * 
     * @return The value of the Logging property for this object.
     */
    public VirtualGatewayLogging logging() {
        return logging;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backendDefaults());
        hashCode = 31 * hashCode + Objects.hashCode(listeners());
        hashCode = 31 * hashCode + Objects.hashCode(logging());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewaySpec)) {
            return false;
        }
        VirtualGatewaySpec other = (VirtualGatewaySpec) obj;
        return Objects.equals(backendDefaults(), other.backendDefaults()) && Objects.equals(listeners(), other.listeners())
                && Objects.equals(logging(), other.logging());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VirtualGatewaySpec").add("BackendDefaults", backendDefaults()).add("Listeners", listeners())
                .add("Logging", logging()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "backendDefaults":
            return Optional.ofNullable(clazz.cast(backendDefaults()));
        case "listeners":
            return Optional.ofNullable(clazz.cast(listeners()));
        case "logging":
            return Optional.ofNullable(clazz.cast(logging()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewaySpec, T> g) {
        return obj -> g.apply((VirtualGatewaySpec) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewaySpec> {
        /**
         * <p>
         * A reference to an object that represents the defaults for backends.
         * </p>
         * 
         * @param backendDefaults
         *        A reference to an object that represents the defaults for backends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendDefaults(VirtualGatewayBackendDefaults backendDefaults);

        /**
         * <p>
         * A reference to an object that represents the defaults for backends.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualGatewayBackendDefaults.Builder} avoiding
         * the need to create one manually via {@link VirtualGatewayBackendDefaults#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayBackendDefaults.Builder#build()} is called
         * immediately and its result is passed to {@link #backendDefaults(VirtualGatewayBackendDefaults)}.
         * 
         * @param backendDefaults
         *        a consumer that will call methods on {@link VirtualGatewayBackendDefaults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backendDefaults(VirtualGatewayBackendDefaults)
         */
        default Builder backendDefaults(Consumer<VirtualGatewayBackendDefaults.Builder> backendDefaults) {
            return backendDefaults(VirtualGatewayBackendDefaults.builder().applyMutation(backendDefaults).build());
        }

        /**
         * <p>
         * The listeners that the mesh endpoint is expected to receive inbound traffic from. You can specify one
         * listener.
         * </p>
         * 
         * @param listeners
         *        The listeners that the mesh endpoint is expected to receive inbound traffic from. You can specify one
         *        listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listeners(Collection<VirtualGatewayListener> listeners);

        /**
         * <p>
         * The listeners that the mesh endpoint is expected to receive inbound traffic from. You can specify one
         * listener.
         * </p>
         * 
         * @param listeners
         *        The listeners that the mesh endpoint is expected to receive inbound traffic from. You can specify one
         *        listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listeners(VirtualGatewayListener... listeners);

        /**
         * <p>
         * The listeners that the mesh endpoint is expected to receive inbound traffic from. You can specify one
         * listener.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VirtualGatewayListener>.Builder} avoiding
         * the need to create one manually via {@link List<VirtualGatewayListener>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VirtualGatewayListener>.Builder#build()} is called
         * immediately and its result is passed to {@link #listeners(List<VirtualGatewayListener>)}.
         * 
         * @param listeners
         *        a consumer that will call methods on {@link List<VirtualGatewayListener>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listeners(List<VirtualGatewayListener>)
         */
        Builder listeners(Consumer<VirtualGatewayListener.Builder>... listeners);

        /**
         * Sets the value of the Logging property for this object.
         *
         * @param logging
         *        The new value for the Logging property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logging(VirtualGatewayLogging logging);

        /**
         * Sets the value of the Logging property for this object.
         *
         * This is a convenience that creates an instance of the {@link VirtualGatewayLogging.Builder} avoiding the need
         * to create one manually via {@link VirtualGatewayLogging#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayLogging.Builder#build()} is called immediately and
         * its result is passed to {@link #logging(VirtualGatewayLogging)}.
         * 
         * @param logging
         *        a consumer that will call methods on {@link VirtualGatewayLogging.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logging(VirtualGatewayLogging)
         */
        default Builder logging(Consumer<VirtualGatewayLogging.Builder> logging) {
            return logging(VirtualGatewayLogging.builder().applyMutation(logging).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VirtualGatewayBackendDefaults backendDefaults;

        private List<VirtualGatewayListener> listeners = DefaultSdkAutoConstructList.getInstance();

        private VirtualGatewayLogging logging;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewaySpec model) {
            backendDefaults(model.backendDefaults);
            listeners(model.listeners);
            logging(model.logging);
        }

        public final VirtualGatewayBackendDefaults.Builder getBackendDefaults() {
            return backendDefaults != null ? backendDefaults.toBuilder() : null;
        }

        @Override
        public final Builder backendDefaults(VirtualGatewayBackendDefaults backendDefaults) {
            this.backendDefaults = backendDefaults;
            return this;
        }

        public final void setBackendDefaults(VirtualGatewayBackendDefaults.BuilderImpl backendDefaults) {
            this.backendDefaults = backendDefaults != null ? backendDefaults.build() : null;
        }

        public final Collection<VirtualGatewayListener.Builder> getListeners() {
            return listeners != null ? listeners.stream().map(VirtualGatewayListener::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder listeners(Collection<VirtualGatewayListener> listeners) {
            this.listeners = VirtualGatewayListenersCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(VirtualGatewayListener... listeners) {
            listeners(Arrays.asList(listeners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Consumer<VirtualGatewayListener.Builder>... listeners) {
            listeners(Stream.of(listeners).map(c -> VirtualGatewayListener.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setListeners(Collection<VirtualGatewayListener.BuilderImpl> listeners) {
            this.listeners = VirtualGatewayListenersCopier.copyFromBuilder(listeners);
        }

        public final VirtualGatewayLogging.Builder getLogging() {
            return logging != null ? logging.toBuilder() : null;
        }

        @Override
        public final Builder logging(VirtualGatewayLogging logging) {
            this.logging = logging;
            return this;
        }

        public final void setLogging(VirtualGatewayLogging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        @Override
        public VirtualGatewaySpec build() {
            return new VirtualGatewaySpec(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
