/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGatewayRouteRequest extends AppMeshRequest implements
        ToCopyableBuilder<CreateGatewayRouteRequest.Builder, CreateGatewayRouteRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateGatewayRouteRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> GATEWAY_ROUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayRouteName").getter(getter(CreateGatewayRouteRequest::gatewayRouteName))
            .setter(setter(Builder::gatewayRouteName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayRouteName").build()).build();

    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("meshName").getter(getter(CreateGatewayRouteRequest::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()).build();

    private static final SdkField<String> MESH_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("meshOwner").getter(getter(CreateGatewayRouteRequest::meshOwner)).setter(setter(Builder::meshOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("meshOwner").build()).build();

    private static final SdkField<GatewayRouteSpec> SPEC_FIELD = SdkField.<GatewayRouteSpec> builder(MarshallingType.SDK_POJO)
            .memberName("spec").getter(getter(CreateGatewayRouteRequest::spec)).setter(setter(Builder::spec))
            .constructor(GatewayRouteSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<List<TagRef>> TAGS_FIELD = SdkField
            .<List<TagRef>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateGatewayRouteRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagRef> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagRef::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VIRTUAL_GATEWAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualGatewayName").getter(getter(CreateGatewayRouteRequest::virtualGatewayName))
            .setter(setter(Builder::virtualGatewayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualGatewayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            GATEWAY_ROUTE_NAME_FIELD, MESH_NAME_FIELD, MESH_OWNER_FIELD, SPEC_FIELD, TAGS_FIELD, VIRTUAL_GATEWAY_NAME_FIELD));

    private final String clientToken;

    private final String gatewayRouteName;

    private final String meshName;

    private final String meshOwner;

    private final GatewayRouteSpec spec;

    private final List<TagRef> tags;

    private final String virtualGatewayName;

    private CreateGatewayRouteRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.gatewayRouteName = builder.gatewayRouteName;
        this.meshName = builder.meshName;
        this.meshOwner = builder.meshOwner;
        this.spec = builder.spec;
        this.tags = builder.tags;
        this.virtualGatewayName = builder.virtualGatewayName;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters,
     * numbers, hyphens, and underscores are allowed.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
     *         letters, numbers, hyphens, and underscores are allowed.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name to use for the gateway route.
     * </p>
     * 
     * @return The name to use for the gateway route.
     */
    public final String gatewayRouteName() {
        return gatewayRouteName;
    }

    /**
     * <p>
     * The name of the service mesh to create the gateway route in.
     * </p>
     * 
     * @return The name of the service mesh to create the gateway route in.
     */
    public final String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you
     * specify must share the mesh with your account before you can create the resource in the service mesh. For more
     * information about mesh sharing, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
     * </p>
     * 
     * @return The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account
     *         that you specify must share the mesh with your account before you can create the resource in the service
     *         mesh. For more information about mesh sharing, see <a
     *         href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
     */
    public final String meshOwner() {
        return meshOwner;
    }

    /**
     * <p>
     * The gateway route specification to apply.
     * </p>
     * 
     * @return The gateway route specification to apply.
     */
    public final GatewayRouteSpec spec() {
        return spec;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional metadata that you can apply to the gateway route to assist with categorization and organization. Each
     * tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character
     * length of 128 characters, and tag values can have a maximum length of 256 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Optional metadata that you can apply to the gateway route to assist with categorization and organization.
     *         Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum
     *         character length of 128 characters, and tag values can have a maximum length of 256 characters.
     */
    public final List<TagRef> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of the virtual gateway to associate the gateway route with. If the virtual gateway is in a shared mesh,
     * then you must be the owner of the virtual gateway resource.
     * </p>
     * 
     * @return The name of the virtual gateway to associate the gateway route with. If the virtual gateway is in a
     *         shared mesh, then you must be the owner of the virtual gateway resource.
     */
    public final String virtualGatewayName() {
        return virtualGatewayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayRouteName());
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(meshOwner());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(virtualGatewayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGatewayRouteRequest)) {
            return false;
        }
        CreateGatewayRouteRequest other = (CreateGatewayRouteRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(gatewayRouteName(), other.gatewayRouteName())
                && Objects.equals(meshName(), other.meshName()) && Objects.equals(meshOwner(), other.meshOwner())
                && Objects.equals(spec(), other.spec()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(virtualGatewayName(), other.virtualGatewayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGatewayRouteRequest").add("ClientToken", clientToken())
                .add("GatewayRouteName", gatewayRouteName()).add("MeshName", meshName()).add("MeshOwner", meshOwner())
                .add("Spec", spec()).add("Tags", hasTags() ? tags() : null).add("VirtualGatewayName", virtualGatewayName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "gatewayRouteName":
            return Optional.ofNullable(clazz.cast(gatewayRouteName()));
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "meshOwner":
            return Optional.ofNullable(clazz.cast(meshOwner()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "virtualGatewayName":
            return Optional.ofNullable(clazz.cast(virtualGatewayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGatewayRouteRequest, T> g) {
        return obj -> g.apply((CreateGatewayRouteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGatewayRouteRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
         * letters, numbers, hyphens, and underscores are allowed.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
         *        letters, numbers, hyphens, and underscores are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name to use for the gateway route.
         * </p>
         * 
         * @param gatewayRouteName
         *        The name to use for the gateway route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayRouteName(String gatewayRouteName);

        /**
         * <p>
         * The name of the service mesh to create the gateway route in.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh to create the gateway route in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that
         * you specify must share the mesh with your account before you can create the resource in the service mesh. For
         * more information about mesh sharing, see <a
         * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
         * </p>
         * 
         * @param meshOwner
         *        The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account
         *        that you specify must share the mesh with your account before you can create the resource in the
         *        service mesh. For more information about mesh sharing, see <a
         *        href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared
         *        meshes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshOwner(String meshOwner);

        /**
         * <p>
         * The gateway route specification to apply.
         * </p>
         * 
         * @param spec
         *        The gateway route specification to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(GatewayRouteSpec spec);

        /**
         * <p>
         * The gateway route specification to apply.
         * </p>
         * This is a convenience that creates an instance of the {@link GatewayRouteSpec.Builder} avoiding the need to
         * create one manually via {@link GatewayRouteSpec#builder()}.
         *
         * When the {@link Consumer} completes, {@link GatewayRouteSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #spec(GatewayRouteSpec)}.
         * 
         * @param spec
         *        a consumer that will call methods on {@link GatewayRouteSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spec(GatewayRouteSpec)
         */
        default Builder spec(Consumer<GatewayRouteSpec.Builder> spec) {
            return spec(GatewayRouteSpec.builder().applyMutation(spec).build());
        }

        /**
         * <p>
         * Optional metadata that you can apply to the gateway route to assist with categorization and organization.
         * Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum
         * character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * 
         * @param tags
         *        Optional metadata that you can apply to the gateway route to assist with categorization and
         *        organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can
         *        have a maximum character length of 128 characters, and tag values can have a maximum length of 256
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagRef> tags);

        /**
         * <p>
         * Optional metadata that you can apply to the gateway route to assist with categorization and organization.
         * Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum
         * character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * 
         * @param tags
         *        Optional metadata that you can apply to the gateway route to assist with categorization and
         *        organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can
         *        have a maximum character length of 128 characters, and tag values can have a maximum length of 256
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagRef... tags);

        /**
         * <p>
         * Optional metadata that you can apply to the gateway route to assist with categorization and organization.
         * Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum
         * character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagRef>.Builder} avoiding the need to
         * create one manually via {@link List<TagRef>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagRef>.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<TagRef>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<TagRef>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<TagRef>)
         */
        Builder tags(Consumer<TagRef.Builder>... tags);

        /**
         * <p>
         * The name of the virtual gateway to associate the gateway route with. If the virtual gateway is in a shared
         * mesh, then you must be the owner of the virtual gateway resource.
         * </p>
         * 
         * @param virtualGatewayName
         *        The name of the virtual gateway to associate the gateway route with. If the virtual gateway is in a
         *        shared mesh, then you must be the owner of the virtual gateway resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGatewayName(String virtualGatewayName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppMeshRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String gatewayRouteName;

        private String meshName;

        private String meshOwner;

        private GatewayRouteSpec spec;

        private List<TagRef> tags = DefaultSdkAutoConstructList.getInstance();

        private String virtualGatewayName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGatewayRouteRequest model) {
            super(model);
            clientToken(model.clientToken);
            gatewayRouteName(model.gatewayRouteName);
            meshName(model.meshName);
            meshOwner(model.meshOwner);
            spec(model.spec);
            tags(model.tags);
            virtualGatewayName(model.virtualGatewayName);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getGatewayRouteName() {
            return gatewayRouteName;
        }

        @Override
        public final Builder gatewayRouteName(String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
            return this;
        }

        public final void setGatewayRouteName(String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
        }

        public final String getMeshName() {
            return meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final String getMeshOwner() {
            return meshOwner;
        }

        @Override
        public final Builder meshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
            return this;
        }

        public final void setMeshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
        }

        public final GatewayRouteSpec.Builder getSpec() {
            return spec != null ? spec.toBuilder() : null;
        }

        @Override
        public final Builder spec(GatewayRouteSpec spec) {
            this.spec = spec;
            return this;
        }

        public final void setSpec(GatewayRouteSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        public final Collection<TagRef.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(TagRef::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<TagRef> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagRef... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagRef.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagRef.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<TagRef.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVirtualGatewayName() {
            return virtualGatewayName;
        }

        @Override
        public final Builder virtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
            return this;
        }

        public final void setVirtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGatewayRouteRequest build() {
            return new CreateGatewayRouteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
