/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the action to take if a match is determined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpGatewayRouteAction implements SdkPojo, Serializable,
        ToCopyableBuilder<HttpGatewayRouteAction.Builder, HttpGatewayRouteAction> {
    private static final SdkField<GatewayRouteTarget> TARGET_FIELD = SdkField
            .<GatewayRouteTarget> builder(MarshallingType.SDK_POJO).memberName("target")
            .getter(getter(HttpGatewayRouteAction::target)).setter(setter(Builder::target))
            .constructor(GatewayRouteTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD));

    private static final long serialVersionUID = 1L;

    private final GatewayRouteTarget target;

    private HttpGatewayRouteAction(BuilderImpl builder) {
        this.target = builder.target;
    }

    /**
     * <p>
     * An object that represents the target that traffic is routed to when a request matches the gateway route.
     * </p>
     * 
     * @return An object that represents the target that traffic is routed to when a request matches the gateway route.
     */
    public final GatewayRouteTarget target() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(target());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpGatewayRouteAction)) {
            return false;
        }
        HttpGatewayRouteAction other = (HttpGatewayRouteAction) obj;
        return Objects.equals(target(), other.target());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpGatewayRouteAction").add("Target", target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpGatewayRouteAction, T> g) {
        return obj -> g.apply((HttpGatewayRouteAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpGatewayRouteAction> {
        /**
         * <p>
         * An object that represents the target that traffic is routed to when a request matches the gateway route.
         * </p>
         * 
         * @param target
         *        An object that represents the target that traffic is routed to when a request matches the gateway
         *        route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(GatewayRouteTarget target);

        /**
         * <p>
         * An object that represents the target that traffic is routed to when a request matches the gateway route.
         * </p>
         * This is a convenience that creates an instance of the {@link GatewayRouteTarget.Builder} avoiding the need to
         * create one manually via {@link GatewayRouteTarget#builder()}.
         *
         * When the {@link Consumer} completes, {@link GatewayRouteTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #target(GatewayRouteTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link GatewayRouteTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(GatewayRouteTarget)
         */
        default Builder target(Consumer<GatewayRouteTarget.Builder> target) {
            return target(GatewayRouteTarget.builder().applyMutation(target).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GatewayRouteTarget target;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpGatewayRouteAction model) {
            target(model.target);
        }

        public final GatewayRouteTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        @Override
        public final Builder target(GatewayRouteTarget target) {
            this.target = target;
            return this;
        }

        public final void setTarget(GatewayRouteTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public HttpGatewayRouteAction build() {
            return new HttpGatewayRouteAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
