/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a listener's Transport Layer Security (TLS) certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayListenerTlsCertificate implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayListenerTlsCertificate.Builder, VirtualGatewayListenerTlsCertificate> {
    private static final SdkField<VirtualGatewayListenerTlsAcmCertificate> ACM_FIELD = SdkField
            .<VirtualGatewayListenerTlsAcmCertificate> builder(MarshallingType.SDK_POJO).memberName("acm")
            .getter(getter(VirtualGatewayListenerTlsCertificate::acm)).setter(setter(Builder::acm))
            .constructor(VirtualGatewayListenerTlsAcmCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acm").build()).build();

    private static final SdkField<VirtualGatewayListenerTlsFileCertificate> FILE_FIELD = SdkField
            .<VirtualGatewayListenerTlsFileCertificate> builder(MarshallingType.SDK_POJO).memberName("file")
            .getter(getter(VirtualGatewayListenerTlsCertificate::file)).setter(setter(Builder::file))
            .constructor(VirtualGatewayListenerTlsFileCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()).build();

    private static final SdkField<VirtualGatewayListenerTlsSdsCertificate> SDS_FIELD = SdkField
            .<VirtualGatewayListenerTlsSdsCertificate> builder(MarshallingType.SDK_POJO).memberName("sds")
            .getter(getter(VirtualGatewayListenerTlsCertificate::sds)).setter(setter(Builder::sds))
            .constructor(VirtualGatewayListenerTlsSdsCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACM_FIELD, FILE_FIELD,
            SDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final VirtualGatewayListenerTlsAcmCertificate acm;

    private final VirtualGatewayListenerTlsFileCertificate file;

    private final VirtualGatewayListenerTlsSdsCertificate sds;

    private VirtualGatewayListenerTlsCertificate(BuilderImpl builder) {
        this.acm = builder.acm;
        this.file = builder.file;
        this.sds = builder.sds;
    }

    /**
     * <p>
     * A reference to an object that represents an AWS Certicate Manager (ACM) certificate.
     * </p>
     * 
     * @return A reference to an object that represents an AWS Certicate Manager (ACM) certificate.
     */
    public final VirtualGatewayListenerTlsAcmCertificate acm() {
        return acm;
    }

    /**
     * <p>
     * A reference to an object that represents a local file certificate.
     * </p>
     * 
     * @return A reference to an object that represents a local file certificate.
     */
    public final VirtualGatewayListenerTlsFileCertificate file() {
        return file;
    }

    /**
     * <p>
     * A reference to an object that represents a virtual gateway's listener's Secret Discovery Service certificate.
     * </p>
     * 
     * @return A reference to an object that represents a virtual gateway's listener's Secret Discovery Service
     *         certificate.
     */
    public final VirtualGatewayListenerTlsSdsCertificate sds() {
        return sds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acm());
        hashCode = 31 * hashCode + Objects.hashCode(file());
        hashCode = 31 * hashCode + Objects.hashCode(sds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayListenerTlsCertificate)) {
            return false;
        }
        VirtualGatewayListenerTlsCertificate other = (VirtualGatewayListenerTlsCertificate) obj;
        return Objects.equals(acm(), other.acm()) && Objects.equals(file(), other.file()) && Objects.equals(sds(), other.sds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualGatewayListenerTlsCertificate").add("Acm", acm()).add("File", file()).add("Sds", sds())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acm":
            return Optional.ofNullable(clazz.cast(acm()));
        case "file":
            return Optional.ofNullable(clazz.cast(file()));
        case "sds":
            return Optional.ofNullable(clazz.cast(sds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayListenerTlsCertificate, T> g) {
        return obj -> g.apply((VirtualGatewayListenerTlsCertificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayListenerTlsCertificate> {
        /**
         * <p>
         * A reference to an object that represents an AWS Certicate Manager (ACM) certificate.
         * </p>
         * 
         * @param acm
         *        A reference to an object that represents an AWS Certicate Manager (ACM) certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acm(VirtualGatewayListenerTlsAcmCertificate acm);

        /**
         * <p>
         * A reference to an object that represents an AWS Certicate Manager (ACM) certificate.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualGatewayListenerTlsAcmCertificate.Builder}
         * avoiding the need to create one manually via {@link VirtualGatewayListenerTlsAcmCertificate#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayListenerTlsAcmCertificate.Builder#build()} is
         * called immediately and its result is passed to {@link #acm(VirtualGatewayListenerTlsAcmCertificate)}.
         * 
         * @param acm
         *        a consumer that will call methods on {@link VirtualGatewayListenerTlsAcmCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acm(VirtualGatewayListenerTlsAcmCertificate)
         */
        default Builder acm(Consumer<VirtualGatewayListenerTlsAcmCertificate.Builder> acm) {
            return acm(VirtualGatewayListenerTlsAcmCertificate.builder().applyMutation(acm).build());
        }

        /**
         * <p>
         * A reference to an object that represents a local file certificate.
         * </p>
         * 
         * @param file
         *        A reference to an object that represents a local file certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(VirtualGatewayListenerTlsFileCertificate file);

        /**
         * <p>
         * A reference to an object that represents a local file certificate.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link VirtualGatewayListenerTlsFileCertificate.Builder} avoiding the need to create one manually via
         * {@link VirtualGatewayListenerTlsFileCertificate#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayListenerTlsFileCertificate.Builder#build()} is
         * called immediately and its result is passed to {@link #file(VirtualGatewayListenerTlsFileCertificate)}.
         * 
         * @param file
         *        a consumer that will call methods on {@link VirtualGatewayListenerTlsFileCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #file(VirtualGatewayListenerTlsFileCertificate)
         */
        default Builder file(Consumer<VirtualGatewayListenerTlsFileCertificate.Builder> file) {
            return file(VirtualGatewayListenerTlsFileCertificate.builder().applyMutation(file).build());
        }

        /**
         * <p>
         * A reference to an object that represents a virtual gateway's listener's Secret Discovery Service certificate.
         * </p>
         * 
         * @param sds
         *        A reference to an object that represents a virtual gateway's listener's Secret Discovery Service
         *        certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sds(VirtualGatewayListenerTlsSdsCertificate sds);

        /**
         * <p>
         * A reference to an object that represents a virtual gateway's listener's Secret Discovery Service certificate.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualGatewayListenerTlsSdsCertificate.Builder}
         * avoiding the need to create one manually via {@link VirtualGatewayListenerTlsSdsCertificate#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayListenerTlsSdsCertificate.Builder#build()} is
         * called immediately and its result is passed to {@link #sds(VirtualGatewayListenerTlsSdsCertificate)}.
         * 
         * @param sds
         *        a consumer that will call methods on {@link VirtualGatewayListenerTlsSdsCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sds(VirtualGatewayListenerTlsSdsCertificate)
         */
        default Builder sds(Consumer<VirtualGatewayListenerTlsSdsCertificate.Builder> sds) {
            return sds(VirtualGatewayListenerTlsSdsCertificate.builder().applyMutation(sds).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VirtualGatewayListenerTlsAcmCertificate acm;

        private VirtualGatewayListenerTlsFileCertificate file;

        private VirtualGatewayListenerTlsSdsCertificate sds;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayListenerTlsCertificate model) {
            acm(model.acm);
            file(model.file);
            sds(model.sds);
        }

        public final VirtualGatewayListenerTlsAcmCertificate.Builder getAcm() {
            return acm != null ? acm.toBuilder() : null;
        }

        @Override
        public final Builder acm(VirtualGatewayListenerTlsAcmCertificate acm) {
            this.acm = acm;
            return this;
        }

        public final void setAcm(VirtualGatewayListenerTlsAcmCertificate.BuilderImpl acm) {
            this.acm = acm != null ? acm.build() : null;
        }

        public final VirtualGatewayListenerTlsFileCertificate.Builder getFile() {
            return file != null ? file.toBuilder() : null;
        }

        @Override
        public final Builder file(VirtualGatewayListenerTlsFileCertificate file) {
            this.file = file;
            return this;
        }

        public final void setFile(VirtualGatewayListenerTlsFileCertificate.BuilderImpl file) {
            this.file = file != null ? file.build() : null;
        }

        public final VirtualGatewayListenerTlsSdsCertificate.Builder getSds() {
            return sds != null ? sds.toBuilder() : null;
        }

        @Override
        public final Builder sds(VirtualGatewayListenerTlsSdsCertificate sds) {
            this.sds = sds;
            return this;
        }

        public final void setSds(VirtualGatewayListenerTlsSdsCertificate.BuilderImpl sds) {
            this.sds = sds != null ? sds.build() : null;
        }

        @Override
        public VirtualGatewayListenerTlsCertificate build() {
            return new VirtualGatewayListenerTlsCertificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
