/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a gRPC route type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrpcRoute implements SdkPojo, Serializable, ToCopyableBuilder<GrpcRoute.Builder, GrpcRoute> {
    private static final SdkField<GrpcRouteAction> ACTION_FIELD = SdkField.<GrpcRouteAction> builder(MarshallingType.SDK_POJO)
            .memberName("action").getter(getter(GrpcRoute::action)).setter(setter(Builder::action))
            .constructor(GrpcRouteAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<GrpcRouteMatch> MATCH_FIELD = SdkField.<GrpcRouteMatch> builder(MarshallingType.SDK_POJO)
            .memberName("match").getter(getter(GrpcRoute::match)).setter(setter(Builder::match))
            .constructor(GrpcRouteMatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()).build();

    private static final SdkField<GrpcRetryPolicy> RETRY_POLICY_FIELD = SdkField
            .<GrpcRetryPolicy> builder(MarshallingType.SDK_POJO).memberName("retryPolicy").getter(getter(GrpcRoute::retryPolicy))
            .setter(setter(Builder::retryPolicy)).constructor(GrpcRetryPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryPolicy").build()).build();

    private static final SdkField<GrpcTimeout> TIMEOUT_FIELD = SdkField.<GrpcTimeout> builder(MarshallingType.SDK_POJO)
            .memberName("timeout").getter(getter(GrpcRoute::timeout)).setter(setter(Builder::timeout))
            .constructor(GrpcTimeout::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, MATCH_FIELD,
            RETRY_POLICY_FIELD, TIMEOUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final GrpcRouteAction action;

    private final GrpcRouteMatch match;

    private final GrpcRetryPolicy retryPolicy;

    private final GrpcTimeout timeout;

    private GrpcRoute(BuilderImpl builder) {
        this.action = builder.action;
        this.match = builder.match;
        this.retryPolicy = builder.retryPolicy;
        this.timeout = builder.timeout;
    }

    /**
     * <p>
     * An object that represents the action to take if a match is determined.
     * </p>
     * 
     * @return An object that represents the action to take if a match is determined.
     */
    public final GrpcRouteAction action() {
        return action;
    }

    /**
     * <p>
     * An object that represents the criteria for determining a request match.
     * </p>
     * 
     * @return An object that represents the criteria for determining a request match.
     */
    public final GrpcRouteMatch match() {
        return match;
    }

    /**
     * <p>
     * An object that represents a retry policy.
     * </p>
     * 
     * @return An object that represents a retry policy.
     */
    public final GrpcRetryPolicy retryPolicy() {
        return retryPolicy;
    }

    /**
     * <p>
     * An object that represents types of timeouts.
     * </p>
     * 
     * @return An object that represents types of timeouts.
     */
    public final GrpcTimeout timeout() {
        return timeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(match());
        hashCode = 31 * hashCode + Objects.hashCode(retryPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrpcRoute)) {
            return false;
        }
        GrpcRoute other = (GrpcRoute) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(match(), other.match())
                && Objects.equals(retryPolicy(), other.retryPolicy()) && Objects.equals(timeout(), other.timeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GrpcRoute").add("Action", action()).add("Match", match()).add("RetryPolicy", retryPolicy())
                .add("Timeout", timeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "match":
            return Optional.ofNullable(clazz.cast(match()));
        case "retryPolicy":
            return Optional.ofNullable(clazz.cast(retryPolicy()));
        case "timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrpcRoute, T> g) {
        return obj -> g.apply((GrpcRoute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GrpcRoute> {
        /**
         * <p>
         * An object that represents the action to take if a match is determined.
         * </p>
         * 
         * @param action
         *        An object that represents the action to take if a match is determined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(GrpcRouteAction action);

        /**
         * <p>
         * An object that represents the action to take if a match is determined.
         * </p>
         * This is a convenience that creates an instance of the {@link GrpcRouteAction.Builder} avoiding the need to
         * create one manually via {@link GrpcRouteAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link GrpcRouteAction.Builder#build()} is called immediately and its
         * result is passed to {@link #action(GrpcRouteAction)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link GrpcRouteAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(GrpcRouteAction)
         */
        default Builder action(Consumer<GrpcRouteAction.Builder> action) {
            return action(GrpcRouteAction.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * An object that represents the criteria for determining a request match.
         * </p>
         * 
         * @param match
         *        An object that represents the criteria for determining a request match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder match(GrpcRouteMatch match);

        /**
         * <p>
         * An object that represents the criteria for determining a request match.
         * </p>
         * This is a convenience that creates an instance of the {@link GrpcRouteMatch.Builder} avoiding the need to
         * create one manually via {@link GrpcRouteMatch#builder()}.
         *
         * When the {@link Consumer} completes, {@link GrpcRouteMatch.Builder#build()} is called immediately and its
         * result is passed to {@link #match(GrpcRouteMatch)}.
         * 
         * @param match
         *        a consumer that will call methods on {@link GrpcRouteMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #match(GrpcRouteMatch)
         */
        default Builder match(Consumer<GrpcRouteMatch.Builder> match) {
            return match(GrpcRouteMatch.builder().applyMutation(match).build());
        }

        /**
         * <p>
         * An object that represents a retry policy.
         * </p>
         * 
         * @param retryPolicy
         *        An object that represents a retry policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryPolicy(GrpcRetryPolicy retryPolicy);

        /**
         * <p>
         * An object that represents a retry policy.
         * </p>
         * This is a convenience that creates an instance of the {@link GrpcRetryPolicy.Builder} avoiding the need to
         * create one manually via {@link GrpcRetryPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link GrpcRetryPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #retryPolicy(GrpcRetryPolicy)}.
         * 
         * @param retryPolicy
         *        a consumer that will call methods on {@link GrpcRetryPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryPolicy(GrpcRetryPolicy)
         */
        default Builder retryPolicy(Consumer<GrpcRetryPolicy.Builder> retryPolicy) {
            return retryPolicy(GrpcRetryPolicy.builder().applyMutation(retryPolicy).build());
        }

        /**
         * <p>
         * An object that represents types of timeouts.
         * </p>
         * 
         * @param timeout
         *        An object that represents types of timeouts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(GrpcTimeout timeout);

        /**
         * <p>
         * An object that represents types of timeouts.
         * </p>
         * This is a convenience that creates an instance of the {@link GrpcTimeout.Builder} avoiding the need to create
         * one manually via {@link GrpcTimeout#builder()}.
         *
         * When the {@link Consumer} completes, {@link GrpcTimeout.Builder#build()} is called immediately and its result
         * is passed to {@link #timeout(GrpcTimeout)}.
         * 
         * @param timeout
         *        a consumer that will call methods on {@link GrpcTimeout.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeout(GrpcTimeout)
         */
        default Builder timeout(Consumer<GrpcTimeout.Builder> timeout) {
            return timeout(GrpcTimeout.builder().applyMutation(timeout).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GrpcRouteAction action;

        private GrpcRouteMatch match;

        private GrpcRetryPolicy retryPolicy;

        private GrpcTimeout timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(GrpcRoute model) {
            action(model.action);
            match(model.match);
            retryPolicy(model.retryPolicy);
            timeout(model.timeout);
        }

        public final GrpcRouteAction.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        @Override
        public final Builder action(GrpcRouteAction action) {
            this.action = action;
            return this;
        }

        public final void setAction(GrpcRouteAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        public final GrpcRouteMatch.Builder getMatch() {
            return match != null ? match.toBuilder() : null;
        }

        @Override
        public final Builder match(GrpcRouteMatch match) {
            this.match = match;
            return this;
        }

        public final void setMatch(GrpcRouteMatch.BuilderImpl match) {
            this.match = match != null ? match.build() : null;
        }

        public final GrpcRetryPolicy.Builder getRetryPolicy() {
            return retryPolicy != null ? retryPolicy.toBuilder() : null;
        }

        @Override
        public final Builder retryPolicy(GrpcRetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public final void setRetryPolicy(GrpcRetryPolicy.BuilderImpl retryPolicy) {
            this.retryPolicy = retryPolicy != null ? retryPolicy.build() : null;
        }

        public final GrpcTimeout.Builder getTimeout() {
            return timeout != null ? timeout.toBuilder() : null;
        }

        @Override
        public final Builder timeout(GrpcTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(GrpcTimeout.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        @Override
        public GrpcRoute build() {
            return new GrpcRoute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
