/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the action to take if a match is determined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrpcRouteAction implements SdkPojo, Serializable, ToCopyableBuilder<GrpcRouteAction.Builder, GrpcRouteAction> {
    private static final SdkField<List<WeightedTarget>> WEIGHTED_TARGETS_FIELD = SdkField
            .<List<WeightedTarget>> builder(MarshallingType.LIST)
            .memberName("weightedTargets")
            .getter(getter(GrpcRouteAction::weightedTargets))
            .setter(setter(Builder::weightedTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weightedTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WeightedTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(WeightedTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEIGHTED_TARGETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<WeightedTarget> weightedTargets;

    private GrpcRouteAction(BuilderImpl builder) {
        this.weightedTargets = builder.weightedTargets;
    }

    /**
     * Returns true if the WeightedTargets property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasWeightedTargets() {
        return weightedTargets != null && !(weightedTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that represents the targets that traffic is routed to when a request matches the route.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWeightedTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An object that represents the targets that traffic is routed to when a request matches the route.
     */
    public final List<WeightedTarget> weightedTargets() {
        return weightedTargets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasWeightedTargets() ? weightedTargets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrpcRouteAction)) {
            return false;
        }
        GrpcRouteAction other = (GrpcRouteAction) obj;
        return hasWeightedTargets() == other.hasWeightedTargets() && Objects.equals(weightedTargets(), other.weightedTargets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GrpcRouteAction").add("WeightedTargets", hasWeightedTargets() ? weightedTargets() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "weightedTargets":
            return Optional.ofNullable(clazz.cast(weightedTargets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrpcRouteAction, T> g) {
        return obj -> g.apply((GrpcRouteAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GrpcRouteAction> {
        /**
         * <p>
         * An object that represents the targets that traffic is routed to when a request matches the route.
         * </p>
         * 
         * @param weightedTargets
         *        An object that represents the targets that traffic is routed to when a request matches the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightedTargets(Collection<WeightedTarget> weightedTargets);

        /**
         * <p>
         * An object that represents the targets that traffic is routed to when a request matches the route.
         * </p>
         * 
         * @param weightedTargets
         *        An object that represents the targets that traffic is routed to when a request matches the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightedTargets(WeightedTarget... weightedTargets);

        /**
         * <p>
         * An object that represents the targets that traffic is routed to when a request matches the route.
         * </p>
         * This is a convenience that creates an instance of the {@link List<WeightedTarget>.Builder} avoiding the need
         * to create one manually via {@link List<WeightedTarget>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WeightedTarget>.Builder#build()} is called immediately and
         * its result is passed to {@link #weightedTargets(List<WeightedTarget>)}.
         * 
         * @param weightedTargets
         *        a consumer that will call methods on {@link List<WeightedTarget>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #weightedTargets(List<WeightedTarget>)
         */
        Builder weightedTargets(Consumer<WeightedTarget.Builder>... weightedTargets);
    }

    static final class BuilderImpl implements Builder {
        private List<WeightedTarget> weightedTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GrpcRouteAction model) {
            weightedTargets(model.weightedTargets);
        }

        public final List<WeightedTarget.Builder> getWeightedTargets() {
            List<WeightedTarget.Builder> result = WeightedTargetsCopier.copyToBuilder(this.weightedTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder weightedTargets(Collection<WeightedTarget> weightedTargets) {
            this.weightedTargets = WeightedTargetsCopier.copy(weightedTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weightedTargets(WeightedTarget... weightedTargets) {
            weightedTargets(Arrays.asList(weightedTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weightedTargets(Consumer<WeightedTarget.Builder>... weightedTargets) {
            weightedTargets(Stream.of(weightedTargets).map(c -> WeightedTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setWeightedTargets(Collection<WeightedTarget.BuilderImpl> weightedTargets) {
            this.weightedTargets = WeightedTargetsCopier.copyFromBuilder(weightedTargets);
        }

        @Override
        public GrpcRouteAction build() {
            return new GrpcRouteAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
