/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the gateway route host name to rewrite.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GatewayRouteHostnameRewrite implements SdkPojo, Serializable,
        ToCopyableBuilder<GatewayRouteHostnameRewrite.Builder, GatewayRouteHostnameRewrite> {
    private static final SdkField<String> DEFAULT_TARGET_HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultTargetHostname").getter(getter(GatewayRouteHostnameRewrite::defaultTargetHostnameAsString))
            .setter(setter(Builder::defaultTargetHostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTargetHostname").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DEFAULT_TARGET_HOSTNAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String defaultTargetHostname;

    private GatewayRouteHostnameRewrite(BuilderImpl builder) {
        this.defaultTargetHostname = builder.defaultTargetHostname;
    }

    /**
     * <p>
     * The default target host name to write to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultTargetHostname} will return {@link DefaultGatewayRouteRewrite#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #defaultTargetHostnameAsString}.
     * </p>
     * 
     * @return The default target host name to write to.
     * @see DefaultGatewayRouteRewrite
     */
    public final DefaultGatewayRouteRewrite defaultTargetHostname() {
        return DefaultGatewayRouteRewrite.fromValue(defaultTargetHostname);
    }

    /**
     * <p>
     * The default target host name to write to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultTargetHostname} will return {@link DefaultGatewayRouteRewrite#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #defaultTargetHostnameAsString}.
     * </p>
     * 
     * @return The default target host name to write to.
     * @see DefaultGatewayRouteRewrite
     */
    public final String defaultTargetHostnameAsString() {
        return defaultTargetHostname;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultTargetHostnameAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayRouteHostnameRewrite)) {
            return false;
        }
        GatewayRouteHostnameRewrite other = (GatewayRouteHostnameRewrite) obj;
        return Objects.equals(defaultTargetHostnameAsString(), other.defaultTargetHostnameAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GatewayRouteHostnameRewrite").add("DefaultTargetHostname", defaultTargetHostnameAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultTargetHostname":
            return Optional.ofNullable(clazz.cast(defaultTargetHostnameAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GatewayRouteHostnameRewrite, T> g) {
        return obj -> g.apply((GatewayRouteHostnameRewrite) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GatewayRouteHostnameRewrite> {
        /**
         * <p>
         * The default target host name to write to.
         * </p>
         * 
         * @param defaultTargetHostname
         *        The default target host name to write to.
         * @see DefaultGatewayRouteRewrite
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultGatewayRouteRewrite
         */
        Builder defaultTargetHostname(String defaultTargetHostname);

        /**
         * <p>
         * The default target host name to write to.
         * </p>
         * 
         * @param defaultTargetHostname
         *        The default target host name to write to.
         * @see DefaultGatewayRouteRewrite
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultGatewayRouteRewrite
         */
        Builder defaultTargetHostname(DefaultGatewayRouteRewrite defaultTargetHostname);
    }

    static final class BuilderImpl implements Builder {
        private String defaultTargetHostname;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayRouteHostnameRewrite model) {
            defaultTargetHostname(model.defaultTargetHostname);
        }

        public final String getDefaultTargetHostname() {
            return defaultTargetHostname;
        }

        @Override
        public final Builder defaultTargetHostname(String defaultTargetHostname) {
            this.defaultTargetHostname = defaultTargetHostname;
            return this;
        }

        @Override
        public final Builder defaultTargetHostname(DefaultGatewayRouteRewrite defaultTargetHostname) {
            this.defaultTargetHostname(defaultTargetHostname == null ? null : defaultTargetHostname.toString());
            return this;
        }

        public final void setDefaultTargetHostname(String defaultTargetHostname) {
            this.defaultTargetHostname = defaultTargetHostname;
        }

        @Override
        public GatewayRouteHostnameRewrite build() {
            return new GatewayRouteHostnameRewrite(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
