/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents timeouts for different protocols.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListenerTimeout implements SdkPojo, Serializable, ToCopyableBuilder<ListenerTimeout.Builder, ListenerTimeout> {
    private static final SdkField<GrpcTimeout> GRPC_FIELD = SdkField.<GrpcTimeout> builder(MarshallingType.SDK_POJO)
            .memberName("grpc").getter(getter(ListenerTimeout::grpc)).setter(setter(Builder::grpc))
            .constructor(GrpcTimeout::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grpc").build()).build();

    private static final SdkField<HttpTimeout> HTTP_FIELD = SdkField.<HttpTimeout> builder(MarshallingType.SDK_POJO)
            .memberName("http").getter(getter(ListenerTimeout::http)).setter(setter(Builder::http))
            .constructor(HttpTimeout::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("http").build()).build();

    private static final SdkField<HttpTimeout> HTTP2_FIELD = SdkField.<HttpTimeout> builder(MarshallingType.SDK_POJO)
            .memberName("http2").getter(getter(ListenerTimeout::http2)).setter(setter(Builder::http2))
            .constructor(HttpTimeout::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("http2").build()).build();

    private static final SdkField<TcpTimeout> TCP_FIELD = SdkField.<TcpTimeout> builder(MarshallingType.SDK_POJO)
            .memberName("tcp").getter(getter(ListenerTimeout::tcp)).setter(setter(Builder::tcp)).constructor(TcpTimeout::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tcp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRPC_FIELD, HTTP_FIELD,
            HTTP2_FIELD, TCP_FIELD));

    private static final long serialVersionUID = 1L;

    private final GrpcTimeout grpc;

    private final HttpTimeout http;

    private final HttpTimeout http2;

    private final TcpTimeout tcp;

    private ListenerTimeout(BuilderImpl builder) {
        this.grpc = builder.grpc;
        this.http = builder.http;
        this.http2 = builder.http2;
        this.tcp = builder.tcp;
    }

    /**
     * <p>
     * An object that represents types of timeouts.
     * </p>
     * 
     * @return An object that represents types of timeouts.
     */
    public final GrpcTimeout grpc() {
        return grpc;
    }

    /**
     * <p>
     * An object that represents types of timeouts.
     * </p>
     * 
     * @return An object that represents types of timeouts.
     */
    public final HttpTimeout http() {
        return http;
    }

    /**
     * <p>
     * An object that represents types of timeouts.
     * </p>
     * 
     * @return An object that represents types of timeouts.
     */
    public final HttpTimeout http2() {
        return http2;
    }

    /**
     * <p>
     * An object that represents types of timeouts.
     * </p>
     * 
     * @return An object that represents types of timeouts.
     */
    public final TcpTimeout tcp() {
        return tcp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(grpc());
        hashCode = 31 * hashCode + Objects.hashCode(http());
        hashCode = 31 * hashCode + Objects.hashCode(http2());
        hashCode = 31 * hashCode + Objects.hashCode(tcp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListenerTimeout)) {
            return false;
        }
        ListenerTimeout other = (ListenerTimeout) obj;
        return Objects.equals(grpc(), other.grpc()) && Objects.equals(http(), other.http())
                && Objects.equals(http2(), other.http2()) && Objects.equals(tcp(), other.tcp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListenerTimeout").add("Grpc", grpc()).add("Http", http()).add("Http2", http2())
                .add("Tcp", tcp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "grpc":
            return Optional.ofNullable(clazz.cast(grpc()));
        case "http":
            return Optional.ofNullable(clazz.cast(http()));
        case "http2":
            return Optional.ofNullable(clazz.cast(http2()));
        case "tcp":
            return Optional.ofNullable(clazz.cast(tcp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListenerTimeout, T> g) {
        return obj -> g.apply((ListenerTimeout) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListenerTimeout> {
        /**
         * <p>
         * An object that represents types of timeouts.
         * </p>
         * 
         * @param grpc
         *        An object that represents types of timeouts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grpc(GrpcTimeout grpc);

        /**
         * <p>
         * An object that represents types of timeouts.
         * </p>
         * This is a convenience that creates an instance of the {@link GrpcTimeout.Builder} avoiding the need to create
         * one manually via {@link GrpcTimeout#builder()}.
         *
         * When the {@link Consumer} completes, {@link GrpcTimeout.Builder#build()} is called immediately and its result
         * is passed to {@link #grpc(GrpcTimeout)}.
         * 
         * @param grpc
         *        a consumer that will call methods on {@link GrpcTimeout.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grpc(GrpcTimeout)
         */
        default Builder grpc(Consumer<GrpcTimeout.Builder> grpc) {
            return grpc(GrpcTimeout.builder().applyMutation(grpc).build());
        }

        /**
         * <p>
         * An object that represents types of timeouts.
         * </p>
         * 
         * @param http
         *        An object that represents types of timeouts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder http(HttpTimeout http);

        /**
         * <p>
         * An object that represents types of timeouts.
         * </p>
         * This is a convenience that creates an instance of the {@link HttpTimeout.Builder} avoiding the need to create
         * one manually via {@link HttpTimeout#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpTimeout.Builder#build()} is called immediately and its result
         * is passed to {@link #http(HttpTimeout)}.
         * 
         * @param http
         *        a consumer that will call methods on {@link HttpTimeout.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #http(HttpTimeout)
         */
        default Builder http(Consumer<HttpTimeout.Builder> http) {
            return http(HttpTimeout.builder().applyMutation(http).build());
        }

        /**
         * <p>
         * An object that represents types of timeouts.
         * </p>
         * 
         * @param http2
         *        An object that represents types of timeouts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder http2(HttpTimeout http2);

        /**
         * <p>
         * An object that represents types of timeouts.
         * </p>
         * This is a convenience that creates an instance of the {@link HttpTimeout.Builder} avoiding the need to create
         * one manually via {@link HttpTimeout#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpTimeout.Builder#build()} is called immediately and its result
         * is passed to {@link #http2(HttpTimeout)}.
         * 
         * @param http2
         *        a consumer that will call methods on {@link HttpTimeout.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #http2(HttpTimeout)
         */
        default Builder http2(Consumer<HttpTimeout.Builder> http2) {
            return http2(HttpTimeout.builder().applyMutation(http2).build());
        }

        /**
         * <p>
         * An object that represents types of timeouts.
         * </p>
         * 
         * @param tcp
         *        An object that represents types of timeouts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tcp(TcpTimeout tcp);

        /**
         * <p>
         * An object that represents types of timeouts.
         * </p>
         * This is a convenience that creates an instance of the {@link TcpTimeout.Builder} avoiding the need to create
         * one manually via {@link TcpTimeout#builder()}.
         *
         * When the {@link Consumer} completes, {@link TcpTimeout.Builder#build()} is called immediately and its result
         * is passed to {@link #tcp(TcpTimeout)}.
         * 
         * @param tcp
         *        a consumer that will call methods on {@link TcpTimeout.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tcp(TcpTimeout)
         */
        default Builder tcp(Consumer<TcpTimeout.Builder> tcp) {
            return tcp(TcpTimeout.builder().applyMutation(tcp).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GrpcTimeout grpc;

        private HttpTimeout http;

        private HttpTimeout http2;

        private TcpTimeout tcp;

        private BuilderImpl() {
        }

        private BuilderImpl(ListenerTimeout model) {
            grpc(model.grpc);
            http(model.http);
            http2(model.http2);
            tcp(model.tcp);
        }

        public final GrpcTimeout.Builder getGrpc() {
            return grpc != null ? grpc.toBuilder() : null;
        }

        @Override
        public final Builder grpc(GrpcTimeout grpc) {
            this.grpc = grpc;
            return this;
        }

        public final void setGrpc(GrpcTimeout.BuilderImpl grpc) {
            this.grpc = grpc != null ? grpc.build() : null;
        }

        public final HttpTimeout.Builder getHttp() {
            return http != null ? http.toBuilder() : null;
        }

        @Override
        public final Builder http(HttpTimeout http) {
            this.http = http;
            return this;
        }

        public final void setHttp(HttpTimeout.BuilderImpl http) {
            this.http = http != null ? http.build() : null;
        }

        public final HttpTimeout.Builder getHttp2() {
            return http2 != null ? http2.toBuilder() : null;
        }

        @Override
        public final Builder http2(HttpTimeout http2) {
            this.http2 = http2;
            return this;
        }

        public final void setHttp2(HttpTimeout.BuilderImpl http2) {
            this.http2 = http2 != null ? http2.build() : null;
        }

        public final TcpTimeout.Builder getTcp() {
            return tcp != null ? tcp.toBuilder() : null;
        }

        @Override
        public final Builder tcp(TcpTimeout tcp) {
            this.tcp = tcp;
            return this;
        }

        public final void setTcp(TcpTimeout.BuilderImpl tcp) {
            this.tcp = tcp != null ? tcp.build() : null;
        }

        @Override
        public ListenerTimeout build() {
            return new ListenerTimeout(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
