/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGatewayRoutesResponse extends AppMeshResponse implements
        ToCopyableBuilder<ListGatewayRoutesResponse.Builder, ListGatewayRoutesResponse> {
    private static final SdkField<List<GatewayRouteRef>> GATEWAY_ROUTES_FIELD = SdkField
            .<List<GatewayRouteRef>> builder(MarshallingType.LIST)
            .memberName("gatewayRoutes")
            .getter(getter(ListGatewayRoutesResponse::gatewayRoutes))
            .setter(setter(Builder::gatewayRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayRoutes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GatewayRouteRef> builder(MarshallingType.SDK_POJO)
                                            .constructor(GatewayRouteRef::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListGatewayRoutesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ROUTES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<GatewayRouteRef> gatewayRoutes;

    private final String nextToken;

    private ListGatewayRoutesResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayRoutes = builder.gatewayRoutes;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the GatewayRoutes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasGatewayRoutes() {
        return gatewayRoutes != null && !(gatewayRoutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of existing gateway routes for the specified service mesh and virtual gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGatewayRoutes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of existing gateway routes for the specified service mesh and virtual gateway.
     */
    public final List<GatewayRouteRef> gatewayRoutes() {
        return gatewayRoutes;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListGatewayRoutes</code> request. When the results
     * of a <code>ListGatewayRoutes</code> request exceed <code>limit</code>, you can use this value to retrieve the
     * next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListGatewayRoutes</code> request. When the
     *         results of a <code>ListGatewayRoutes</code> request exceed <code>limit</code>, you can use this value to
     *         retrieve the next page of results. This value is <code>null</code> when there are no more results to
     *         return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGatewayRoutes() ? gatewayRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGatewayRoutesResponse)) {
            return false;
        }
        ListGatewayRoutesResponse other = (ListGatewayRoutesResponse) obj;
        return hasGatewayRoutes() == other.hasGatewayRoutes() && Objects.equals(gatewayRoutes(), other.gatewayRoutes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGatewayRoutesResponse").add("GatewayRoutes", hasGatewayRoutes() ? gatewayRoutes() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayRoutes":
            return Optional.ofNullable(clazz.cast(gatewayRoutes()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGatewayRoutesResponse, T> g) {
        return obj -> g.apply((ListGatewayRoutesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListGatewayRoutesResponse> {
        /**
         * <p>
         * The list of existing gateway routes for the specified service mesh and virtual gateway.
         * </p>
         * 
         * @param gatewayRoutes
         *        The list of existing gateway routes for the specified service mesh and virtual gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayRoutes(Collection<GatewayRouteRef> gatewayRoutes);

        /**
         * <p>
         * The list of existing gateway routes for the specified service mesh and virtual gateway.
         * </p>
         * 
         * @param gatewayRoutes
         *        The list of existing gateway routes for the specified service mesh and virtual gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayRoutes(GatewayRouteRef... gatewayRoutes);

        /**
         * <p>
         * The list of existing gateway routes for the specified service mesh and virtual gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GatewayRouteRef>.Builder} avoiding the need
         * to create one manually via {@link List<GatewayRouteRef>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GatewayRouteRef>.Builder#build()} is called immediately and
         * its result is passed to {@link #gatewayRoutes(List<GatewayRouteRef>)}.
         * 
         * @param gatewayRoutes
         *        a consumer that will call methods on {@link List<GatewayRouteRef>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gatewayRoutes(List<GatewayRouteRef>)
         */
        Builder gatewayRoutes(Consumer<GatewayRouteRef.Builder>... gatewayRoutes);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListGatewayRoutes</code> request. When the
         * results of a <code>ListGatewayRoutes</code> request exceed <code>limit</code>, you can use this value to
         * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListGatewayRoutes</code> request. When
         *        the results of a <code>ListGatewayRoutes</code> request exceed <code>limit</code>, you can use this
         *        value to retrieve the next page of results. This value is <code>null</code> when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppMeshResponse.BuilderImpl implements Builder {
        private List<GatewayRouteRef> gatewayRoutes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGatewayRoutesResponse model) {
            super(model);
            gatewayRoutes(model.gatewayRoutes);
            nextToken(model.nextToken);
        }

        public final List<GatewayRouteRef.Builder> getGatewayRoutes() {
            List<GatewayRouteRef.Builder> result = GatewayRouteListCopier.copyToBuilder(this.gatewayRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder gatewayRoutes(Collection<GatewayRouteRef> gatewayRoutes) {
            this.gatewayRoutes = GatewayRouteListCopier.copy(gatewayRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayRoutes(GatewayRouteRef... gatewayRoutes) {
            gatewayRoutes(Arrays.asList(gatewayRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayRoutes(Consumer<GatewayRouteRef.Builder>... gatewayRoutes) {
            gatewayRoutes(Stream.of(gatewayRoutes).map(c -> GatewayRouteRef.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGatewayRoutes(Collection<GatewayRouteRef.BuilderImpl> gatewayRoutes) {
            this.gatewayRoutes = GatewayRouteListCopier.copyFromBuilder(gatewayRoutes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListGatewayRoutesResponse build() {
            return new ListGatewayRoutesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
