/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the DNS service discovery information for your virtual node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DnsServiceDiscovery implements SdkPojo, Serializable,
        ToCopyableBuilder<DnsServiceDiscovery.Builder, DnsServiceDiscovery> {
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostname").getter(getter(DnsServiceDiscovery::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()).build();

    private static final SdkField<String> RESPONSE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responseType").getter(getter(DnsServiceDiscovery::responseTypeAsString))
            .setter(setter(Builder::responseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTNAME_FIELD,
            RESPONSE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hostname;

    private final String responseType;

    private DnsServiceDiscovery(BuilderImpl builder) {
        this.hostname = builder.hostname;
        this.responseType = builder.responseType;
    }

    /**
     * <p>
     * Specifies the DNS service discovery hostname for the virtual node.
     * </p>
     * 
     * @return Specifies the DNS service discovery hostname for the virtual node.
     */
    public final String hostname() {
        return hostname;
    }

    /**
     * <p>
     * Specifies the DNS response type for the virtual node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #responseType} will
     * return {@link DnsResponseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #responseTypeAsString}.
     * </p>
     * 
     * @return Specifies the DNS response type for the virtual node.
     * @see DnsResponseType
     */
    public final DnsResponseType responseType() {
        return DnsResponseType.fromValue(responseType);
    }

    /**
     * <p>
     * Specifies the DNS response type for the virtual node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #responseType} will
     * return {@link DnsResponseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #responseTypeAsString}.
     * </p>
     * 
     * @return Specifies the DNS response type for the virtual node.
     * @see DnsResponseType
     */
    public final String responseTypeAsString() {
        return responseType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(responseTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsServiceDiscovery)) {
            return false;
        }
        DnsServiceDiscovery other = (DnsServiceDiscovery) obj;
        return Objects.equals(hostname(), other.hostname())
                && Objects.equals(responseTypeAsString(), other.responseTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DnsServiceDiscovery").add("Hostname", hostname()).add("ResponseType", responseTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "responseType":
            return Optional.ofNullable(clazz.cast(responseTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DnsServiceDiscovery, T> g) {
        return obj -> g.apply((DnsServiceDiscovery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DnsServiceDiscovery> {
        /**
         * <p>
         * Specifies the DNS service discovery hostname for the virtual node.
         * </p>
         * 
         * @param hostname
         *        Specifies the DNS service discovery hostname for the virtual node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * Specifies the DNS response type for the virtual node.
         * </p>
         * 
         * @param responseType
         *        Specifies the DNS response type for the virtual node.
         * @see DnsResponseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsResponseType
         */
        Builder responseType(String responseType);

        /**
         * <p>
         * Specifies the DNS response type for the virtual node.
         * </p>
         * 
         * @param responseType
         *        Specifies the DNS response type for the virtual node.
         * @see DnsResponseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsResponseType
         */
        Builder responseType(DnsResponseType responseType);
    }

    static final class BuilderImpl implements Builder {
        private String hostname;

        private String responseType;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsServiceDiscovery model) {
            hostname(model.hostname);
            responseType(model.responseType);
        }

        public final String getHostname() {
            return hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getResponseType() {
            return responseType;
        }

        @Override
        public final Builder responseType(String responseType) {
            this.responseType = responseType;
            return this;
        }

        @Override
        public final Builder responseType(DnsResponseType responseType) {
            this.responseType(responseType == null ? null : responseType.toString());
            return this;
        }

        public final void setResponseType(String responseType) {
            this.responseType = responseType;
        }

        @Override
        public DnsServiceDiscovery build() {
            return new DnsServiceDiscovery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
