/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a listener's Transport Layer Security (TLS) validation context trust.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListenerTlsValidationContextTrust implements SdkPojo, Serializable,
        ToCopyableBuilder<ListenerTlsValidationContextTrust.Builder, ListenerTlsValidationContextTrust> {
    private static final SdkField<TlsValidationContextFileTrust> FILE_FIELD = SdkField
            .<TlsValidationContextFileTrust> builder(MarshallingType.SDK_POJO).memberName("file")
            .getter(getter(ListenerTlsValidationContextTrust::file)).setter(setter(Builder::file))
            .constructor(TlsValidationContextFileTrust::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()).build();

    private static final SdkField<TlsValidationContextSdsTrust> SDS_FIELD = SdkField
            .<TlsValidationContextSdsTrust> builder(MarshallingType.SDK_POJO).memberName("sds")
            .getter(getter(ListenerTlsValidationContextTrust::sds)).setter(setter(Builder::sds))
            .constructor(TlsValidationContextSdsTrust::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FIELD, SDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final TlsValidationContextFileTrust file;

    private final TlsValidationContextSdsTrust sds;

    private ListenerTlsValidationContextTrust(BuilderImpl builder) {
        this.file = builder.file;
        this.sds = builder.sds;
    }

    /**
     * <p>
     * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
     * </p>
     * 
     * @return An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
     */
    public final TlsValidationContextFileTrust file() {
        return file;
    }

    /**
     * <p>
     * A reference to an object that represents a listener's Transport Layer Security (TLS) Secret Discovery Service
     * validation context trust.
     * </p>
     * 
     * @return A reference to an object that represents a listener's Transport Layer Security (TLS) Secret Discovery
     *         Service validation context trust.
     */
    public final TlsValidationContextSdsTrust sds() {
        return sds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(file());
        hashCode = 31 * hashCode + Objects.hashCode(sds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListenerTlsValidationContextTrust)) {
            return false;
        }
        ListenerTlsValidationContextTrust other = (ListenerTlsValidationContextTrust) obj;
        return Objects.equals(file(), other.file()) && Objects.equals(sds(), other.sds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListenerTlsValidationContextTrust").add("File", file()).add("Sds", sds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "file":
            return Optional.ofNullable(clazz.cast(file()));
        case "sds":
            return Optional.ofNullable(clazz.cast(sds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListenerTlsValidationContextTrust, T> g) {
        return obj -> g.apply((ListenerTlsValidationContextTrust) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListenerTlsValidationContextTrust> {
        /**
         * <p>
         * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
         * </p>
         * 
         * @param file
         *        An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(TlsValidationContextFileTrust file);

        /**
         * <p>
         * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
         * </p>
         * This is a convenience that creates an instance of the {@link TlsValidationContextFileTrust.Builder} avoiding
         * the need to create one manually via {@link TlsValidationContextFileTrust#builder()}.
         *
         * When the {@link Consumer} completes, {@link TlsValidationContextFileTrust.Builder#build()} is called
         * immediately and its result is passed to {@link #file(TlsValidationContextFileTrust)}.
         * 
         * @param file
         *        a consumer that will call methods on {@link TlsValidationContextFileTrust.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #file(TlsValidationContextFileTrust)
         */
        default Builder file(Consumer<TlsValidationContextFileTrust.Builder> file) {
            return file(TlsValidationContextFileTrust.builder().applyMutation(file).build());
        }

        /**
         * <p>
         * A reference to an object that represents a listener's Transport Layer Security (TLS) Secret Discovery Service
         * validation context trust.
         * </p>
         * 
         * @param sds
         *        A reference to an object that represents a listener's Transport Layer Security (TLS) Secret Discovery
         *        Service validation context trust.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sds(TlsValidationContextSdsTrust sds);

        /**
         * <p>
         * A reference to an object that represents a listener's Transport Layer Security (TLS) Secret Discovery Service
         * validation context trust.
         * </p>
         * This is a convenience that creates an instance of the {@link TlsValidationContextSdsTrust.Builder} avoiding
         * the need to create one manually via {@link TlsValidationContextSdsTrust#builder()}.
         *
         * When the {@link Consumer} completes, {@link TlsValidationContextSdsTrust.Builder#build()} is called
         * immediately and its result is passed to {@link #sds(TlsValidationContextSdsTrust)}.
         * 
         * @param sds
         *        a consumer that will call methods on {@link TlsValidationContextSdsTrust.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sds(TlsValidationContextSdsTrust)
         */
        default Builder sds(Consumer<TlsValidationContextSdsTrust.Builder> sds) {
            return sds(TlsValidationContextSdsTrust.builder().applyMutation(sds).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TlsValidationContextFileTrust file;

        private TlsValidationContextSdsTrust sds;

        private BuilderImpl() {
        }

        private BuilderImpl(ListenerTlsValidationContextTrust model) {
            file(model.file);
            sds(model.sds);
        }

        public final TlsValidationContextFileTrust.Builder getFile() {
            return file != null ? file.toBuilder() : null;
        }

        @Override
        public final Builder file(TlsValidationContextFileTrust file) {
            this.file = file;
            return this;
        }

        public final void setFile(TlsValidationContextFileTrust.BuilderImpl file) {
            this.file = file != null ? file.build() : null;
        }

        public final TlsValidationContextSdsTrust.Builder getSds() {
            return sds != null ? sds.toBuilder() : null;
        }

        @Override
        public final Builder sds(TlsValidationContextSdsTrust sds) {
            this.sds = sds;
            return this;
        }

        public final void setSds(TlsValidationContextSdsTrust.BuilderImpl sds) {
            this.sds = sds != null ? sds.build() : null;
        }

        @Override
        public ListenerTlsValidationContextTrust build() {
            return new ListenerTlsValidationContextTrust(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
