/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the specification of a virtual node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualNodeSpec implements SdkPojo, Serializable, ToCopyableBuilder<VirtualNodeSpec.Builder, VirtualNodeSpec> {
    private static final SdkField<BackendDefaults> BACKEND_DEFAULTS_FIELD = SdkField
            .<BackendDefaults> builder(MarshallingType.SDK_POJO).memberName("backendDefaults")
            .getter(getter(VirtualNodeSpec::backendDefaults)).setter(setter(Builder::backendDefaults))
            .constructor(BackendDefaults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendDefaults").build()).build();

    private static final SdkField<List<Backend>> BACKENDS_FIELD = SdkField
            .<List<Backend>> builder(MarshallingType.LIST)
            .memberName("backends")
            .getter(getter(VirtualNodeSpec::backends))
            .setter(setter(Builder::backends))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backends").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Backend> builder(MarshallingType.SDK_POJO)
                                            .constructor(Backend::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Listener>> LISTENERS_FIELD = SdkField
            .<List<Listener>> builder(MarshallingType.LIST)
            .memberName("listeners")
            .getter(getter(VirtualNodeSpec::listeners))
            .setter(setter(Builder::listeners))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listeners").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Listener> builder(MarshallingType.SDK_POJO)
                                            .constructor(Listener::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Logging> LOGGING_FIELD = SdkField.<Logging> builder(MarshallingType.SDK_POJO)
            .memberName("logging").getter(getter(VirtualNodeSpec::logging)).setter(setter(Builder::logging))
            .constructor(Logging::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()).build();

    private static final SdkField<ServiceDiscovery> SERVICE_DISCOVERY_FIELD = SdkField
            .<ServiceDiscovery> builder(MarshallingType.SDK_POJO).memberName("serviceDiscovery")
            .getter(getter(VirtualNodeSpec::serviceDiscovery)).setter(setter(Builder::serviceDiscovery))
            .constructor(ServiceDiscovery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDiscovery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKEND_DEFAULTS_FIELD,
            BACKENDS_FIELD, LISTENERS_FIELD, LOGGING_FIELD, SERVICE_DISCOVERY_FIELD));

    private static final long serialVersionUID = 1L;

    private final BackendDefaults backendDefaults;

    private final List<Backend> backends;

    private final List<Listener> listeners;

    private final Logging logging;

    private final ServiceDiscovery serviceDiscovery;

    private VirtualNodeSpec(BuilderImpl builder) {
        this.backendDefaults = builder.backendDefaults;
        this.backends = builder.backends;
        this.listeners = builder.listeners;
        this.logging = builder.logging;
        this.serviceDiscovery = builder.serviceDiscovery;
    }

    /**
     * <p>
     * A reference to an object that represents the defaults for backends.
     * </p>
     * 
     * @return A reference to an object that represents the defaults for backends.
     */
    public final BackendDefaults backendDefaults() {
        return backendDefaults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Backends property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBackends() {
        return backends != null && !(backends instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The backends that the virtual node is expected to send outbound traffic to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackends} method.
     * </p>
     * 
     * @return The backends that the virtual node is expected to send outbound traffic to.
     */
    public final List<Backend> backends() {
        return backends;
    }

    /**
     * For responses, this returns true if the service returned a value for the Listeners property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasListeners() {
        return listeners != null && !(listeners instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The listener that the virtual node is expected to receive inbound traffic from. You can specify one listener.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListeners} method.
     * </p>
     * 
     * @return The listener that the virtual node is expected to receive inbound traffic from. You can specify one
     *         listener.
     */
    public final List<Listener> listeners() {
        return listeners;
    }

    /**
     * <p>
     * The inbound and outbound access logging information for the virtual node.
     * </p>
     * 
     * @return The inbound and outbound access logging information for the virtual node.
     */
    public final Logging logging() {
        return logging;
    }

    /**
     * <p>
     * The service discovery information for the virtual node. If your virtual node does not expect ingress traffic, you
     * can omit this parameter. If you specify a <code>listener</code>, then you must specify service discovery
     * information.
     * </p>
     * 
     * @return The service discovery information for the virtual node. If your virtual node does not expect ingress
     *         traffic, you can omit this parameter. If you specify a <code>listener</code>, then you must specify
     *         service discovery information.
     */
    public final ServiceDiscovery serviceDiscovery() {
        return serviceDiscovery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backendDefaults());
        hashCode = 31 * hashCode + Objects.hashCode(hasBackends() ? backends() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasListeners() ? listeners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logging());
        hashCode = 31 * hashCode + Objects.hashCode(serviceDiscovery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualNodeSpec)) {
            return false;
        }
        VirtualNodeSpec other = (VirtualNodeSpec) obj;
        return Objects.equals(backendDefaults(), other.backendDefaults()) && hasBackends() == other.hasBackends()
                && Objects.equals(backends(), other.backends()) && hasListeners() == other.hasListeners()
                && Objects.equals(listeners(), other.listeners()) && Objects.equals(logging(), other.logging())
                && Objects.equals(serviceDiscovery(), other.serviceDiscovery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualNodeSpec").add("BackendDefaults", backendDefaults())
                .add("Backends", hasBackends() ? backends() : null).add("Listeners", hasListeners() ? listeners() : null)
                .add("Logging", logging()).add("ServiceDiscovery", serviceDiscovery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "backendDefaults":
            return Optional.ofNullable(clazz.cast(backendDefaults()));
        case "backends":
            return Optional.ofNullable(clazz.cast(backends()));
        case "listeners":
            return Optional.ofNullable(clazz.cast(listeners()));
        case "logging":
            return Optional.ofNullable(clazz.cast(logging()));
        case "serviceDiscovery":
            return Optional.ofNullable(clazz.cast(serviceDiscovery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualNodeSpec, T> g) {
        return obj -> g.apply((VirtualNodeSpec) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualNodeSpec> {
        /**
         * <p>
         * A reference to an object that represents the defaults for backends.
         * </p>
         * 
         * @param backendDefaults
         *        A reference to an object that represents the defaults for backends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendDefaults(BackendDefaults backendDefaults);

        /**
         * <p>
         * A reference to an object that represents the defaults for backends.
         * </p>
         * This is a convenience that creates an instance of the {@link BackendDefaults.Builder} avoiding the need to
         * create one manually via {@link BackendDefaults#builder()}.
         *
         * When the {@link Consumer} completes, {@link BackendDefaults.Builder#build()} is called immediately and its
         * result is passed to {@link #backendDefaults(BackendDefaults)}.
         * 
         * @param backendDefaults
         *        a consumer that will call methods on {@link BackendDefaults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backendDefaults(BackendDefaults)
         */
        default Builder backendDefaults(Consumer<BackendDefaults.Builder> backendDefaults) {
            return backendDefaults(BackendDefaults.builder().applyMutation(backendDefaults).build());
        }

        /**
         * <p>
         * The backends that the virtual node is expected to send outbound traffic to.
         * </p>
         * 
         * @param backends
         *        The backends that the virtual node is expected to send outbound traffic to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backends(Collection<Backend> backends);

        /**
         * <p>
         * The backends that the virtual node is expected to send outbound traffic to.
         * </p>
         * 
         * @param backends
         *        The backends that the virtual node is expected to send outbound traffic to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backends(Backend... backends);

        /**
         * <p>
         * The backends that the virtual node is expected to send outbound traffic to.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Backend>.Builder} avoiding the need to
         * create one manually via {@link List<Backend>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Backend>.Builder#build()} is called immediately and its
         * result is passed to {@link #backends(List<Backend>)}.
         * 
         * @param backends
         *        a consumer that will call methods on {@link List<Backend>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backends(List<Backend>)
         */
        Builder backends(Consumer<Backend.Builder>... backends);

        /**
         * <p>
         * The listener that the virtual node is expected to receive inbound traffic from. You can specify one listener.
         * </p>
         * 
         * @param listeners
         *        The listener that the virtual node is expected to receive inbound traffic from. You can specify one
         *        listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listeners(Collection<Listener> listeners);

        /**
         * <p>
         * The listener that the virtual node is expected to receive inbound traffic from. You can specify one listener.
         * </p>
         * 
         * @param listeners
         *        The listener that the virtual node is expected to receive inbound traffic from. You can specify one
         *        listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listeners(Listener... listeners);

        /**
         * <p>
         * The listener that the virtual node is expected to receive inbound traffic from. You can specify one listener.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Listener>.Builder} avoiding the need to
         * create one manually via {@link List<Listener>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Listener>.Builder#build()} is called immediately and its
         * result is passed to {@link #listeners(List<Listener>)}.
         * 
         * @param listeners
         *        a consumer that will call methods on {@link List<Listener>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listeners(List<Listener>)
         */
        Builder listeners(Consumer<Listener.Builder>... listeners);

        /**
         * <p>
         * The inbound and outbound access logging information for the virtual node.
         * </p>
         * 
         * @param logging
         *        The inbound and outbound access logging information for the virtual node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logging(Logging logging);

        /**
         * <p>
         * The inbound and outbound access logging information for the virtual node.
         * </p>
         * This is a convenience that creates an instance of the {@link Logging.Builder} avoiding the need to create one
         * manually via {@link Logging#builder()}.
         *
         * When the {@link Consumer} completes, {@link Logging.Builder#build()} is called immediately and its result is
         * passed to {@link #logging(Logging)}.
         * 
         * @param logging
         *        a consumer that will call methods on {@link Logging.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logging(Logging)
         */
        default Builder logging(Consumer<Logging.Builder> logging) {
            return logging(Logging.builder().applyMutation(logging).build());
        }

        /**
         * <p>
         * The service discovery information for the virtual node. If your virtual node does not expect ingress traffic,
         * you can omit this parameter. If you specify a <code>listener</code>, then you must specify service discovery
         * information.
         * </p>
         * 
         * @param serviceDiscovery
         *        The service discovery information for the virtual node. If your virtual node does not expect ingress
         *        traffic, you can omit this parameter. If you specify a <code>listener</code>, then you must specify
         *        service discovery information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDiscovery(ServiceDiscovery serviceDiscovery);

        /**
         * <p>
         * The service discovery information for the virtual node. If your virtual node does not expect ingress traffic,
         * you can omit this parameter. If you specify a <code>listener</code>, then you must specify service discovery
         * information.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceDiscovery.Builder} avoiding the need to
         * create one manually via {@link ServiceDiscovery#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceDiscovery.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceDiscovery(ServiceDiscovery)}.
         * 
         * @param serviceDiscovery
         *        a consumer that will call methods on {@link ServiceDiscovery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceDiscovery(ServiceDiscovery)
         */
        default Builder serviceDiscovery(Consumer<ServiceDiscovery.Builder> serviceDiscovery) {
            return serviceDiscovery(ServiceDiscovery.builder().applyMutation(serviceDiscovery).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BackendDefaults backendDefaults;

        private List<Backend> backends = DefaultSdkAutoConstructList.getInstance();

        private List<Listener> listeners = DefaultSdkAutoConstructList.getInstance();

        private Logging logging;

        private ServiceDiscovery serviceDiscovery;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualNodeSpec model) {
            backendDefaults(model.backendDefaults);
            backends(model.backends);
            listeners(model.listeners);
            logging(model.logging);
            serviceDiscovery(model.serviceDiscovery);
        }

        public final BackendDefaults.Builder getBackendDefaults() {
            return backendDefaults != null ? backendDefaults.toBuilder() : null;
        }

        public final void setBackendDefaults(BackendDefaults.BuilderImpl backendDefaults) {
            this.backendDefaults = backendDefaults != null ? backendDefaults.build() : null;
        }

        @Override
        @Transient
        public final Builder backendDefaults(BackendDefaults backendDefaults) {
            this.backendDefaults = backendDefaults;
            return this;
        }

        public final List<Backend.Builder> getBackends() {
            List<Backend.Builder> result = BackendsCopier.copyToBuilder(this.backends);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackends(Collection<Backend.BuilderImpl> backends) {
            this.backends = BackendsCopier.copyFromBuilder(backends);
        }

        @Override
        @Transient
        public final Builder backends(Collection<Backend> backends) {
            this.backends = BackendsCopier.copy(backends);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder backends(Backend... backends) {
            backends(Arrays.asList(backends));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder backends(Consumer<Backend.Builder>... backends) {
            backends(Stream.of(backends).map(c -> Backend.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Listener.Builder> getListeners() {
            List<Listener.Builder> result = ListenersCopier.copyToBuilder(this.listeners);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListeners(Collection<Listener.BuilderImpl> listeners) {
            this.listeners = ListenersCopier.copyFromBuilder(listeners);
        }

        @Override
        @Transient
        public final Builder listeners(Collection<Listener> listeners) {
            this.listeners = ListenersCopier.copy(listeners);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder listeners(Listener... listeners) {
            listeners(Arrays.asList(listeners));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder listeners(Consumer<Listener.Builder>... listeners) {
            listeners(Stream.of(listeners).map(c -> Listener.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Logging.Builder getLogging() {
            return logging != null ? logging.toBuilder() : null;
        }

        public final void setLogging(Logging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        @Override
        @Transient
        public final Builder logging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public final ServiceDiscovery.Builder getServiceDiscovery() {
            return serviceDiscovery != null ? serviceDiscovery.toBuilder() : null;
        }

        public final void setServiceDiscovery(ServiceDiscovery.BuilderImpl serviceDiscovery) {
            this.serviceDiscovery = serviceDiscovery != null ? serviceDiscovery.build() : null;
        }

        @Override
        @Transient
        public final Builder serviceDiscovery(ServiceDiscovery serviceDiscovery) {
            this.serviceDiscovery = serviceDiscovery;
            return this;
        }

        @Override
        public VirtualNodeSpec build() {
            return new VirtualNodeSpec(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
