/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <zonbook></zonbook><xhtml></xhtml>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMeshRequest extends AppMeshRequest implements
        ToCopyableBuilder<DescribeMeshRequest.Builder, DescribeMeshRequest> {
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("meshName").getter(getter(DescribeMeshRequest::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()).build();

    private static final SdkField<String> MESH_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("meshOwner").getter(getter(DescribeMeshRequest::meshOwner)).setter(setter(Builder::meshOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("meshOwner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESH_NAME_FIELD,
            MESH_OWNER_FIELD));

    private final String meshName;

    private final String meshOwner;

    private DescribeMeshRequest(BuilderImpl builder) {
        super(builder);
        this.meshName = builder.meshName;
        this.meshOwner = builder.meshOwner;
    }

    /**
     * <p>
     * The name of the service mesh to describe.
     * </p>
     * 
     * @return The name of the service mesh to describe.
     */
    public final String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the
     * account that shared the mesh with your account. For more information about mesh sharing, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
     * </p>
     * 
     * @return The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of
     *         the account that shared the mesh with your account. For more information about mesh sharing, see <a
     *         href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
     */
    public final String meshOwner() {
        return meshOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(meshOwner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMeshRequest)) {
            return false;
        }
        DescribeMeshRequest other = (DescribeMeshRequest) obj;
        return Objects.equals(meshName(), other.meshName()) && Objects.equals(meshOwner(), other.meshOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMeshRequest").add("MeshName", meshName()).add("MeshOwner", meshOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "meshOwner":
            return Optional.ofNullable(clazz.cast(meshOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMeshRequest, T> g) {
        return obj -> g.apply((DescribeMeshRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeMeshRequest> {
        /**
         * <p>
         * The name of the service mesh to describe.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the
         * account that shared the mesh with your account. For more information about mesh sharing, see <a
         * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
         * </p>
         * 
         * @param meshOwner
         *        The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID
         *        of the account that shared the mesh with your account. For more information about mesh sharing, see <a
         *        href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared
         *        meshes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshOwner(String meshOwner);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppMeshRequest.BuilderImpl implements Builder {
        private String meshName;

        private String meshOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMeshRequest model) {
            super(model);
            meshName(model.meshName);
            meshOwner(model.meshOwner);
        }

        public final String getMeshName() {
            return meshName;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        @Override
        @Transient
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final String getMeshOwner() {
            return meshOwner;
        }

        public final void setMeshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
        }

        @Override
        @Transient
        public final Builder meshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeMeshRequest build() {
            return new DescribeMeshRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
