/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TlsValidationContextFileTrust implements SdkPojo, Serializable,
        ToCopyableBuilder<TlsValidationContextFileTrust.Builder, TlsValidationContextFileTrust> {
    private static final SdkField<String> CERTIFICATE_CHAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateChain").getter(getter(TlsValidationContextFileTrust::certificateChain))
            .setter(setter(Builder::certificateChain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateChain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_CHAIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certificateChain;

    private TlsValidationContextFileTrust(BuilderImpl builder) {
        this.certificateChain = builder.certificateChain;
    }

    /**
     * <p>
     * The certificate trust chain for a certificate stored on the file system of the virtual node that the proxy is
     * running on.
     * </p>
     * 
     * @return The certificate trust chain for a certificate stored on the file system of the virtual node that the
     *         proxy is running on.
     */
    public final String certificateChain() {
        return certificateChain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateChain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TlsValidationContextFileTrust)) {
            return false;
        }
        TlsValidationContextFileTrust other = (TlsValidationContextFileTrust) obj;
        return Objects.equals(certificateChain(), other.certificateChain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TlsValidationContextFileTrust").add("CertificateChain", certificateChain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateChain":
            return Optional.ofNullable(clazz.cast(certificateChain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TlsValidationContextFileTrust, T> g) {
        return obj -> g.apply((TlsValidationContextFileTrust) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TlsValidationContextFileTrust> {
        /**
         * <p>
         * The certificate trust chain for a certificate stored on the file system of the virtual node that the proxy is
         * running on.
         * </p>
         * 
         * @param certificateChain
         *        The certificate trust chain for a certificate stored on the file system of the virtual node that the
         *        proxy is running on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateChain(String certificateChain);
    }

    static final class BuilderImpl implements Builder {
        private String certificateChain;

        private BuilderImpl() {
        }

        private BuilderImpl(TlsValidationContextFileTrust model) {
            certificateChain(model.certificateChain);
        }

        public final String getCertificateChain() {
            return certificateChain;
        }

        public final void setCertificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
        }

        @Override
        @Transient
        public final Builder certificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        @Override
        public TlsValidationContextFileTrust build() {
            return new TlsValidationContextFileTrust(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
