/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the gateway route to rewrite.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpGatewayRouteRewrite implements SdkPojo, Serializable,
        ToCopyableBuilder<HttpGatewayRouteRewrite.Builder, HttpGatewayRouteRewrite> {
    private static final SdkField<GatewayRouteHostnameRewrite> HOSTNAME_FIELD = SdkField
            .<GatewayRouteHostnameRewrite> builder(MarshallingType.SDK_POJO).memberName("hostname")
            .getter(getter(HttpGatewayRouteRewrite::hostname)).setter(setter(Builder::hostname))
            .constructor(GatewayRouteHostnameRewrite::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()).build();

    private static final SdkField<HttpGatewayRoutePathRewrite> PATH_FIELD = SdkField
            .<HttpGatewayRoutePathRewrite> builder(MarshallingType.SDK_POJO).memberName("path")
            .getter(getter(HttpGatewayRouteRewrite::path)).setter(setter(Builder::path))
            .constructor(HttpGatewayRoutePathRewrite::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()).build();

    private static final SdkField<HttpGatewayRoutePrefixRewrite> PREFIX_FIELD = SdkField
            .<HttpGatewayRoutePrefixRewrite> builder(MarshallingType.SDK_POJO).memberName("prefix")
            .getter(getter(HttpGatewayRouteRewrite::prefix)).setter(setter(Builder::prefix))
            .constructor(HttpGatewayRoutePrefixRewrite::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTNAME_FIELD, PATH_FIELD,
            PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final GatewayRouteHostnameRewrite hostname;

    private final HttpGatewayRoutePathRewrite path;

    private final HttpGatewayRoutePrefixRewrite prefix;

    private HttpGatewayRouteRewrite(BuilderImpl builder) {
        this.hostname = builder.hostname;
        this.path = builder.path;
        this.prefix = builder.prefix;
    }

    /**
     * <p>
     * The host name to rewrite.
     * </p>
     * 
     * @return The host name to rewrite.
     */
    public final GatewayRouteHostnameRewrite hostname() {
        return hostname;
    }

    /**
     * <p>
     * The path to rewrite.
     * </p>
     * 
     * @return The path to rewrite.
     */
    public final HttpGatewayRoutePathRewrite path() {
        return path;
    }

    /**
     * <p>
     * The specified beginning characters to rewrite.
     * </p>
     * 
     * @return The specified beginning characters to rewrite.
     */
    public final HttpGatewayRoutePrefixRewrite prefix() {
        return prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpGatewayRouteRewrite)) {
            return false;
        }
        HttpGatewayRouteRewrite other = (HttpGatewayRouteRewrite) obj;
        return Objects.equals(hostname(), other.hostname()) && Objects.equals(path(), other.path())
                && Objects.equals(prefix(), other.prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpGatewayRouteRewrite").add("Hostname", hostname()).add("Path", path())
                .add("Prefix", prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        case "prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpGatewayRouteRewrite, T> g) {
        return obj -> g.apply((HttpGatewayRouteRewrite) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpGatewayRouteRewrite> {
        /**
         * <p>
         * The host name to rewrite.
         * </p>
         * 
         * @param hostname
         *        The host name to rewrite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(GatewayRouteHostnameRewrite hostname);

        /**
         * <p>
         * The host name to rewrite.
         * </p>
         * This is a convenience that creates an instance of the {@link GatewayRouteHostnameRewrite.Builder} avoiding
         * the need to create one manually via {@link GatewayRouteHostnameRewrite#builder()}.
         *
         * When the {@link Consumer} completes, {@link GatewayRouteHostnameRewrite.Builder#build()} is called
         * immediately and its result is passed to {@link #hostname(GatewayRouteHostnameRewrite)}.
         * 
         * @param hostname
         *        a consumer that will call methods on {@link GatewayRouteHostnameRewrite.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostname(GatewayRouteHostnameRewrite)
         */
        default Builder hostname(Consumer<GatewayRouteHostnameRewrite.Builder> hostname) {
            return hostname(GatewayRouteHostnameRewrite.builder().applyMutation(hostname).build());
        }

        /**
         * <p>
         * The path to rewrite.
         * </p>
         * 
         * @param path
         *        The path to rewrite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(HttpGatewayRoutePathRewrite path);

        /**
         * <p>
         * The path to rewrite.
         * </p>
         * This is a convenience that creates an instance of the {@link HttpGatewayRoutePathRewrite.Builder} avoiding
         * the need to create one manually via {@link HttpGatewayRoutePathRewrite#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpGatewayRoutePathRewrite.Builder#build()} is called
         * immediately and its result is passed to {@link #path(HttpGatewayRoutePathRewrite)}.
         * 
         * @param path
         *        a consumer that will call methods on {@link HttpGatewayRoutePathRewrite.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #path(HttpGatewayRoutePathRewrite)
         */
        default Builder path(Consumer<HttpGatewayRoutePathRewrite.Builder> path) {
            return path(HttpGatewayRoutePathRewrite.builder().applyMutation(path).build());
        }

        /**
         * <p>
         * The specified beginning characters to rewrite.
         * </p>
         * 
         * @param prefix
         *        The specified beginning characters to rewrite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(HttpGatewayRoutePrefixRewrite prefix);

        /**
         * <p>
         * The specified beginning characters to rewrite.
         * </p>
         * This is a convenience that creates an instance of the {@link HttpGatewayRoutePrefixRewrite.Builder} avoiding
         * the need to create one manually via {@link HttpGatewayRoutePrefixRewrite#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpGatewayRoutePrefixRewrite.Builder#build()} is called
         * immediately and its result is passed to {@link #prefix(HttpGatewayRoutePrefixRewrite)}.
         * 
         * @param prefix
         *        a consumer that will call methods on {@link HttpGatewayRoutePrefixRewrite.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prefix(HttpGatewayRoutePrefixRewrite)
         */
        default Builder prefix(Consumer<HttpGatewayRoutePrefixRewrite.Builder> prefix) {
            return prefix(HttpGatewayRoutePrefixRewrite.builder().applyMutation(prefix).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GatewayRouteHostnameRewrite hostname;

        private HttpGatewayRoutePathRewrite path;

        private HttpGatewayRoutePrefixRewrite prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpGatewayRouteRewrite model) {
            hostname(model.hostname);
            path(model.path);
            prefix(model.prefix);
        }

        public final GatewayRouteHostnameRewrite.Builder getHostname() {
            return hostname != null ? hostname.toBuilder() : null;
        }

        public final void setHostname(GatewayRouteHostnameRewrite.BuilderImpl hostname) {
            this.hostname = hostname != null ? hostname.build() : null;
        }

        @Override
        @Transient
        public final Builder hostname(GatewayRouteHostnameRewrite hostname) {
            this.hostname = hostname;
            return this;
        }

        public final HttpGatewayRoutePathRewrite.Builder getPath() {
            return path != null ? path.toBuilder() : null;
        }

        public final void setPath(HttpGatewayRoutePathRewrite.BuilderImpl path) {
            this.path = path != null ? path.build() : null;
        }

        @Override
        @Transient
        public final Builder path(HttpGatewayRoutePathRewrite path) {
            this.path = path;
            return this;
        }

        public final HttpGatewayRoutePrefixRewrite.Builder getPrefix() {
            return prefix != null ? prefix.toBuilder() : null;
        }

        public final void setPrefix(HttpGatewayRoutePrefixRewrite.BuilderImpl prefix) {
            this.prefix = prefix != null ? prefix.build() : null;
        }

        @Override
        @Transient
        public final Builder prefix(HttpGatewayRoutePrefixRewrite prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public HttpGatewayRouteRewrite build() {
            return new HttpGatewayRouteRewrite(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
