/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <zonbook></zonbook><xhtml></xhtml>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVirtualServicesResponse extends AppMeshResponse implements
        ToCopyableBuilder<ListVirtualServicesResponse.Builder, ListVirtualServicesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListVirtualServicesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<VirtualServiceRef>> VIRTUAL_SERVICES_FIELD = SdkField
            .<List<VirtualServiceRef>> builder(MarshallingType.LIST)
            .memberName("virtualServices")
            .getter(getter(ListVirtualServicesResponse::virtualServices))
            .setter(setter(Builder::virtualServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualServices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VirtualServiceRef> builder(MarshallingType.SDK_POJO)
                                            .constructor(VirtualServiceRef::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            VIRTUAL_SERVICES_FIELD));

    private final String nextToken;

    private final List<VirtualServiceRef> virtualServices;

    private ListVirtualServicesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.virtualServices = builder.virtualServices;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListVirtualServices</code> request. When the
     * results of a <code>ListVirtualServices</code> request exceed <code>limit</code>, you can use this value to
     * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListVirtualServices</code> request. When
     *         the results of a <code>ListVirtualServices</code> request exceed <code>limit</code>, you can use this
     *         value to retrieve the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the VirtualServices property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasVirtualServices() {
        return virtualServices != null && !(virtualServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of existing virtual services for the specified service mesh.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVirtualServices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of existing virtual services for the specified service mesh.
     */
    public final List<VirtualServiceRef> virtualServices() {
        return virtualServices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasVirtualServices() ? virtualServices() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualServicesResponse)) {
            return false;
        }
        ListVirtualServicesResponse other = (ListVirtualServicesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasVirtualServices() == other.hasVirtualServices()
                && Objects.equals(virtualServices(), other.virtualServices());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVirtualServicesResponse").add("NextToken", nextToken())
                .add("VirtualServices", hasVirtualServices() ? virtualServices() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "virtualServices":
            return Optional.ofNullable(clazz.cast(virtualServices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVirtualServicesResponse, T> g) {
        return obj -> g.apply((ListVirtualServicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListVirtualServicesResponse> {
        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListVirtualServices</code> request. When the
         * results of a <code>ListVirtualServices</code> request exceed <code>limit</code>, you can use this value to
         * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListVirtualServices</code> request. When
         *        the results of a <code>ListVirtualServices</code> request exceed <code>limit</code>, you can use this
         *        value to retrieve the next page of results. This value is <code>null</code> when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of existing virtual services for the specified service mesh.
         * </p>
         * 
         * @param virtualServices
         *        The list of existing virtual services for the specified service mesh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualServices(Collection<VirtualServiceRef> virtualServices);

        /**
         * <p>
         * The list of existing virtual services for the specified service mesh.
         * </p>
         * 
         * @param virtualServices
         *        The list of existing virtual services for the specified service mesh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualServices(VirtualServiceRef... virtualServices);

        /**
         * <p>
         * The list of existing virtual services for the specified service mesh.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VirtualServiceRef>.Builder} avoiding the
         * need to create one manually via {@link List<VirtualServiceRef>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VirtualServiceRef>.Builder#build()} is called immediately
         * and its result is passed to {@link #virtualServices(List<VirtualServiceRef>)}.
         * 
         * @param virtualServices
         *        a consumer that will call methods on {@link List<VirtualServiceRef>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualServices(List<VirtualServiceRef>)
         */
        Builder virtualServices(Consumer<VirtualServiceRef.Builder>... virtualServices);
    }

    static final class BuilderImpl extends AppMeshResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<VirtualServiceRef> virtualServices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualServicesResponse model) {
            super(model);
            nextToken(model.nextToken);
            virtualServices(model.virtualServices);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<VirtualServiceRef.Builder> getVirtualServices() {
            List<VirtualServiceRef.Builder> result = VirtualServiceListCopier.copyToBuilder(this.virtualServices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVirtualServices(Collection<VirtualServiceRef.BuilderImpl> virtualServices) {
            this.virtualServices = VirtualServiceListCopier.copyFromBuilder(virtualServices);
        }

        @Override
        @Transient
        public final Builder virtualServices(Collection<VirtualServiceRef> virtualServices) {
            this.virtualServices = VirtualServiceListCopier.copy(virtualServices);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder virtualServices(VirtualServiceRef... virtualServices) {
            virtualServices(Arrays.asList(virtualServices));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder virtualServices(Consumer<VirtualServiceRef.Builder>... virtualServices) {
            virtualServices(Stream.of(virtualServices).map(c -> VirtualServiceRef.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVirtualServicesResponse build() {
            return new ListVirtualServicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
