/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the methods by which a subject alternative name on a peer Transport Layer Security (TLS)
 * certificate can be matched.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubjectAlternativeNameMatchers implements SdkPojo, Serializable,
        ToCopyableBuilder<SubjectAlternativeNameMatchers.Builder, SubjectAlternativeNameMatchers> {
    private static final SdkField<List<String>> EXACT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("exact")
            .getter(getter(SubjectAlternativeNameMatchers::exact))
            .setter(setter(Builder::exact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exact").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXACT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> exact;

    private SubjectAlternativeNameMatchers(BuilderImpl builder) {
        this.exact = builder.exact;
    }

    /**
     * Returns true if the Exact property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasExact() {
        return exact != null && !(exact instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values sent must match the specified values exactly.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExact()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The values sent must match the specified values exactly.
     */
    public final List<String> exact() {
        return exact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasExact() ? exact() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubjectAlternativeNameMatchers)) {
            return false;
        }
        SubjectAlternativeNameMatchers other = (SubjectAlternativeNameMatchers) obj;
        return hasExact() == other.hasExact() && Objects.equals(exact(), other.exact());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubjectAlternativeNameMatchers").add("Exact", hasExact() ? exact() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exact":
            return Optional.ofNullable(clazz.cast(exact()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubjectAlternativeNameMatchers, T> g) {
        return obj -> g.apply((SubjectAlternativeNameMatchers) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubjectAlternativeNameMatchers> {
        /**
         * <p>
         * The values sent must match the specified values exactly.
         * </p>
         * 
         * @param exact
         *        The values sent must match the specified values exactly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exact(Collection<String> exact);

        /**
         * <p>
         * The values sent must match the specified values exactly.
         * </p>
         * 
         * @param exact
         *        The values sent must match the specified values exactly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exact(String... exact);
    }

    static final class BuilderImpl implements Builder {
        private List<String> exact = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubjectAlternativeNameMatchers model) {
            exact(model.exact);
        }

        public final Collection<String> getExact() {
            if (exact instanceof SdkAutoConstructList) {
                return null;
            }
            return exact;
        }

        public final void setExact(Collection<String> exact) {
            this.exact = SubjectAlternativeNameListCopier.copy(exact);
        }

        @Override
        @Transient
        public final Builder exact(Collection<String> exact) {
            this.exact = SubjectAlternativeNameListCopier.copy(exact);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder exact(String... exact) {
            exact(Arrays.asList(exact));
            return this;
        }

        @Override
        public SubjectAlternativeNameMatchers build() {
            return new SubjectAlternativeNameMatchers(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
