/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the client's certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientTlsCertificate implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientTlsCertificate.Builder, ClientTlsCertificate> {
    private static final SdkField<ListenerTlsFileCertificate> FILE_FIELD = SdkField
            .<ListenerTlsFileCertificate> builder(MarshallingType.SDK_POJO).memberName("file")
            .getter(getter(ClientTlsCertificate::file)).setter(setter(Builder::file))
            .constructor(ListenerTlsFileCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()).build();

    private static final SdkField<ListenerTlsSdsCertificate> SDS_FIELD = SdkField
            .<ListenerTlsSdsCertificate> builder(MarshallingType.SDK_POJO).memberName("sds")
            .getter(getter(ClientTlsCertificate::sds)).setter(setter(Builder::sds))
            .constructor(ListenerTlsSdsCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FIELD, SDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ListenerTlsFileCertificate file;

    private final ListenerTlsSdsCertificate sds;

    private final Type type;

    private ClientTlsCertificate(BuilderImpl builder) {
        this.file = builder.file;
        this.sds = builder.sds;
        this.type = builder.type;
    }

    /**
     * <p>
     * An object that represents a local file certificate. The certificate must meet specific requirements and you must
     * have proxy authorization enabled. For more information, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">Transport Layer Security (TLS)</a>.
     * </p>
     * 
     * @return An object that represents a local file certificate. The certificate must meet specific requirements and
     *         you must have proxy authorization enabled. For more information, see <a
     *         href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">Transport Layer Security (TLS)</a>.
     */
    public final ListenerTlsFileCertificate file() {
        return file;
    }

    /**
     * <p>
     * A reference to an object that represents a client's TLS Secret Discovery Service certificate.
     * </p>
     * 
     * @return A reference to an object that represents a client's TLS Secret Discovery Service certificate.
     */
    public final ListenerTlsSdsCertificate sds() {
        return sds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(file());
        hashCode = 31 * hashCode + Objects.hashCode(sds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientTlsCertificate)) {
            return false;
        }
        ClientTlsCertificate other = (ClientTlsCertificate) obj;
        return Objects.equals(file(), other.file()) && Objects.equals(sds(), other.sds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientTlsCertificate").add("File", file()).add("Sds", sds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "file":
            return Optional.ofNullable(clazz.cast(file()));
        case "sds":
            return Optional.ofNullable(clazz.cast(sds()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #file()} initialized to the given value.
     *
     * <p>
     * An object that represents a local file certificate. The certificate must meet specific requirements and you must
     * have proxy authorization enabled. For more information, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">Transport Layer Security (TLS)</a>.
     * </p>
     * 
     * @param file
     *        An object that represents a local file certificate. The certificate must meet specific requirements and
     *        you must have proxy authorization enabled. For more information, see <a
     *        href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">Transport Layer Security (TLS)</a>.
     */
    public static ClientTlsCertificate fromFile(ListenerTlsFileCertificate file) {
        return builder().file(file).build();
    }

    /**
     * Create an instance of this class with {@link #file()} initialized to the given value.
     *
     * <p>
     * An object that represents a local file certificate. The certificate must meet specific requirements and you must
     * have proxy authorization enabled. For more information, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">Transport Layer Security (TLS)</a>.
     * </p>
     * 
     * @param file
     *        An object that represents a local file certificate. The certificate must meet specific requirements and
     *        you must have proxy authorization enabled. For more information, see <a
     *        href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">Transport Layer Security (TLS)</a>.
     */
    public static ClientTlsCertificate fromFile(Consumer<ListenerTlsFileCertificate.Builder> file) {
        ListenerTlsFileCertificate.Builder builder = ListenerTlsFileCertificate.builder();
        file.accept(builder);
        return fromFile(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sds()} initialized to the given value.
     *
     * <p>
     * A reference to an object that represents a client's TLS Secret Discovery Service certificate.
     * </p>
     * 
     * @param sds
     *        A reference to an object that represents a client's TLS Secret Discovery Service certificate.
     */
    public static ClientTlsCertificate fromSds(ListenerTlsSdsCertificate sds) {
        return builder().sds(sds).build();
    }

    /**
     * Create an instance of this class with {@link #sds()} initialized to the given value.
     *
     * <p>
     * A reference to an object that represents a client's TLS Secret Discovery Service certificate.
     * </p>
     * 
     * @param sds
     *        A reference to an object that represents a client's TLS Secret Discovery Service certificate.
     */
    public static ClientTlsCertificate fromSds(Consumer<ListenerTlsSdsCertificate.Builder> sds) {
        ListenerTlsSdsCertificate.Builder builder = ListenerTlsSdsCertificate.builder();
        sds.accept(builder);
        return fromSds(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientTlsCertificate, T> g) {
        return obj -> g.apply((ClientTlsCertificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientTlsCertificate> {
        /**
         * <p>
         * An object that represents a local file certificate. The certificate must meet specific requirements and you
         * must have proxy authorization enabled. For more information, see <a
         * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">Transport Layer Security (TLS)</a>.
         * </p>
         * 
         * @param file
         *        An object that represents a local file certificate. The certificate must meet specific requirements
         *        and you must have proxy authorization enabled. For more information, see <a
         *        href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">Transport Layer Security
         *        (TLS)</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(ListenerTlsFileCertificate file);

        /**
         * <p>
         * An object that represents a local file certificate. The certificate must meet specific requirements and you
         * must have proxy authorization enabled. For more information, see <a
         * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">Transport Layer Security (TLS)</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListenerTlsFileCertificate.Builder}
         * avoiding the need to create one manually via {@link ListenerTlsFileCertificate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ListenerTlsFileCertificate.Builder#build()} is called immediately
         * and its result is passed to {@link #file(ListenerTlsFileCertificate)}.
         * 
         * @param file
         *        a consumer that will call methods on {@link ListenerTlsFileCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #file(ListenerTlsFileCertificate)
         */
        default Builder file(Consumer<ListenerTlsFileCertificate.Builder> file) {
            return file(ListenerTlsFileCertificate.builder().applyMutation(file).build());
        }

        /**
         * <p>
         * A reference to an object that represents a client's TLS Secret Discovery Service certificate.
         * </p>
         * 
         * @param sds
         *        A reference to an object that represents a client's TLS Secret Discovery Service certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sds(ListenerTlsSdsCertificate sds);

        /**
         * <p>
         * A reference to an object that represents a client's TLS Secret Discovery Service certificate.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListenerTlsSdsCertificate.Builder}
         * avoiding the need to create one manually via {@link ListenerTlsSdsCertificate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ListenerTlsSdsCertificate.Builder#build()} is called immediately
         * and its result is passed to {@link #sds(ListenerTlsSdsCertificate)}.
         * 
         * @param sds
         *        a consumer that will call methods on {@link ListenerTlsSdsCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sds(ListenerTlsSdsCertificate)
         */
        default Builder sds(Consumer<ListenerTlsSdsCertificate.Builder> sds) {
            return sds(ListenerTlsSdsCertificate.builder().applyMutation(sds).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ListenerTlsFileCertificate file;

        private ListenerTlsSdsCertificate sds;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ClientTlsCertificate model) {
            file(model.file);
            sds(model.sds);
        }

        public final ListenerTlsFileCertificate.Builder getFile() {
            return file != null ? file.toBuilder() : null;
        }

        public final void setFile(ListenerTlsFileCertificate.BuilderImpl file) {
            Object oldValue = this.file;
            this.file = file != null ? file.build() : null;
            handleUnionValueChange(Type.FILE, oldValue, this.file);
        }

        @Override
        @Transient
        public final Builder file(ListenerTlsFileCertificate file) {
            Object oldValue = this.file;
            this.file = file;
            handleUnionValueChange(Type.FILE, oldValue, this.file);
            return this;
        }

        public final ListenerTlsSdsCertificate.Builder getSds() {
            return sds != null ? sds.toBuilder() : null;
        }

        public final void setSds(ListenerTlsSdsCertificate.BuilderImpl sds) {
            Object oldValue = this.sds;
            this.sds = sds != null ? sds.build() : null;
            handleUnionValueChange(Type.SDS, oldValue, this.sds);
        }

        @Override
        @Transient
        public final Builder sds(ListenerTlsSdsCertificate sds) {
            Object oldValue = this.sds;
            this.sds = sds;
            handleUnionValueChange(Type.SDS, oldValue, this.sds);
            return this;
        }

        @Override
        public ClientTlsCertificate build() {
            return new ClientTlsCertificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ClientTlsCertificate#type()
     */
    public enum Type {
        FILE,

        SDS,

        UNKNOWN_TO_SDK_VERSION
    }
}
