/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <zonbook></zonbook><xhtml></xhtml>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRouteResponse extends AppMeshResponse implements
        ToCopyableBuilder<CreateRouteResponse.Builder, CreateRouteResponse> {
    private static final SdkField<RouteData> ROUTE_FIELD = SdkField
            .<RouteData> builder(MarshallingType.SDK_POJO)
            .memberName("route")
            .getter(getter(CreateRouteResponse::route))
            .setter(setter(Builder::route))
            .constructor(RouteData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("route").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_FIELD));

    private final RouteData route;

    private CreateRouteResponse(BuilderImpl builder) {
        super(builder);
        this.route = builder.route;
    }

    /**
     * <p>
     * The full description of your mesh following the create call.
     * </p>
     * 
     * @return The full description of your mesh following the create call.
     */
    public final RouteData route() {
        return route;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(route());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteResponse)) {
            return false;
        }
        CreateRouteResponse other = (CreateRouteResponse) obj;
        return Objects.equals(route(), other.route());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRouteResponse").add("Route", route()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "route":
            return Optional.ofNullable(clazz.cast(route()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRouteResponse, T> g) {
        return obj -> g.apply((CreateRouteResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRouteResponse> {
        /**
         * <p>
         * The full description of your mesh following the create call.
         * </p>
         * 
         * @param route
         *        The full description of your mesh following the create call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder route(RouteData route);

        /**
         * <p>
         * The full description of your mesh following the create call.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteData.Builder} avoiding the need to
         * create one manually via {@link RouteData#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteData.Builder#build()} is called immediately and its result
         * is passed to {@link #route(RouteData)}.
         * 
         * @param route
         *        a consumer that will call methods on {@link RouteData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #route(RouteData)
         */
        default Builder route(Consumer<RouteData.Builder> route) {
            return route(RouteData.builder().applyMutation(route).build());
        }
    }

    static final class BuilderImpl extends AppMeshResponse.BuilderImpl implements Builder {
        private RouteData route;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteResponse model) {
            super(model);
            route(model.route);
        }

        public final RouteData.Builder getRoute() {
            return route != null ? route.toBuilder() : null;
        }

        public final void setRoute(RouteData.BuilderImpl route) {
            this.route = route != null ? route.build() : null;
        }

        @Override
        @Transient
        public final Builder route(RouteData route) {
            this.route = route;
            return this;
        }

        @Override
        public CreateRouteResponse build() {
            return new CreateRouteResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
