/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the criteria for determining a request match.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrpcGatewayRouteMatch implements SdkPojo, Serializable,
        ToCopyableBuilder<GrpcGatewayRouteMatch.Builder, GrpcGatewayRouteMatch> {
    private static final SdkField<GatewayRouteHostnameMatch> HOSTNAME_FIELD = SdkField
            .<GatewayRouteHostnameMatch> builder(MarshallingType.SDK_POJO).memberName("hostname")
            .getter(getter(GrpcGatewayRouteMatch::hostname)).setter(setter(Builder::hostname))
            .constructor(GatewayRouteHostnameMatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()).build();

    private static final SdkField<List<GrpcGatewayRouteMetadata>> METADATA_FIELD = SdkField
            .<List<GrpcGatewayRouteMetadata>> builder(MarshallingType.LIST)
            .memberName("metadata")
            .getter(getter(GrpcGatewayRouteMatch::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GrpcGatewayRouteMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(GrpcGatewayRouteMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(GrpcGatewayRouteMatch::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTNAME_FIELD,
            METADATA_FIELD, SERVICE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final GatewayRouteHostnameMatch hostname;

    private final List<GrpcGatewayRouteMetadata> metadata;

    private final String serviceName;

    private GrpcGatewayRouteMatch(BuilderImpl builder) {
        this.hostname = builder.hostname;
        this.metadata = builder.metadata;
        this.serviceName = builder.serviceName;
    }

    /**
     * <p>
     * The gateway route host name to be matched on.
     * </p>
     * 
     * @return The gateway route host name to be matched on.
     */
    public final GatewayRouteHostnameMatch hostname() {
        return hostname;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metadata property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The gateway route metadata to be matched on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadata} method.
     * </p>
     * 
     * @return The gateway route metadata to be matched on.
     */
    public final List<GrpcGatewayRouteMetadata> metadata() {
        return metadata;
    }

    /**
     * <p>
     * The fully qualified domain name for the service to match from the request.
     * </p>
     * 
     * @return The fully qualified domain name for the service to match from the request.
     */
    public final String serviceName() {
        return serviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrpcGatewayRouteMatch)) {
            return false;
        }
        GrpcGatewayRouteMatch other = (GrpcGatewayRouteMatch) obj;
        return Objects.equals(hostname(), other.hostname()) && hasMetadata() == other.hasMetadata()
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(serviceName(), other.serviceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GrpcGatewayRouteMatch").add("Hostname", hostname())
                .add("Metadata", hasMetadata() ? metadata() : null).add("ServiceName", serviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrpcGatewayRouteMatch, T> g) {
        return obj -> g.apply((GrpcGatewayRouteMatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GrpcGatewayRouteMatch> {
        /**
         * <p>
         * The gateway route host name to be matched on.
         * </p>
         * 
         * @param hostname
         *        The gateway route host name to be matched on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(GatewayRouteHostnameMatch hostname);

        /**
         * <p>
         * The gateway route host name to be matched on.
         * </p>
         * This is a convenience method that creates an instance of the {@link GatewayRouteHostnameMatch.Builder}
         * avoiding the need to create one manually via {@link GatewayRouteHostnameMatch#builder()}.
         *
         * When the {@link Consumer} completes, {@link GatewayRouteHostnameMatch.Builder#build()} is called immediately
         * and its result is passed to {@link #hostname(GatewayRouteHostnameMatch)}.
         * 
         * @param hostname
         *        a consumer that will call methods on {@link GatewayRouteHostnameMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostname(GatewayRouteHostnameMatch)
         */
        default Builder hostname(Consumer<GatewayRouteHostnameMatch.Builder> hostname) {
            return hostname(GatewayRouteHostnameMatch.builder().applyMutation(hostname).build());
        }

        /**
         * <p>
         * The gateway route metadata to be matched on.
         * </p>
         * 
         * @param metadata
         *        The gateway route metadata to be matched on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Collection<GrpcGatewayRouteMetadata> metadata);

        /**
         * <p>
         * The gateway route metadata to be matched on.
         * </p>
         * 
         * @param metadata
         *        The gateway route metadata to be matched on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(GrpcGatewayRouteMetadata... metadata);

        /**
         * <p>
         * The gateway route metadata to be matched on.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<GrpcGatewayRouteMetadata>.Builder}
         * avoiding the need to create one manually via {@link List<GrpcGatewayRouteMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GrpcGatewayRouteMetadata>.Builder#build()} is called
         * immediately and its result is passed to {@link #metadata(List<GrpcGatewayRouteMetadata>)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link List<GrpcGatewayRouteMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(List<GrpcGatewayRouteMetadata>)
         */
        Builder metadata(Consumer<GrpcGatewayRouteMetadata.Builder>... metadata);

        /**
         * <p>
         * The fully qualified domain name for the service to match from the request.
         * </p>
         * 
         * @param serviceName
         *        The fully qualified domain name for the service to match from the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);
    }

    static final class BuilderImpl implements Builder {
        private GatewayRouteHostnameMatch hostname;

        private List<GrpcGatewayRouteMetadata> metadata = DefaultSdkAutoConstructList.getInstance();

        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(GrpcGatewayRouteMatch model) {
            hostname(model.hostname);
            metadata(model.metadata);
            serviceName(model.serviceName);
        }

        public final GatewayRouteHostnameMatch.Builder getHostname() {
            return hostname != null ? hostname.toBuilder() : null;
        }

        public final void setHostname(GatewayRouteHostnameMatch.BuilderImpl hostname) {
            this.hostname = hostname != null ? hostname.build() : null;
        }

        @Override
        @Transient
        public final Builder hostname(GatewayRouteHostnameMatch hostname) {
            this.hostname = hostname;
            return this;
        }

        public final List<GrpcGatewayRouteMetadata.Builder> getMetadata() {
            List<GrpcGatewayRouteMetadata.Builder> result = GrpcGatewayRouteMetadataListCopier.copyToBuilder(this.metadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetadata(Collection<GrpcGatewayRouteMetadata.BuilderImpl> metadata) {
            this.metadata = GrpcGatewayRouteMetadataListCopier.copyFromBuilder(metadata);
        }

        @Override
        @Transient
        public final Builder metadata(Collection<GrpcGatewayRouteMetadata> metadata) {
            this.metadata = GrpcGatewayRouteMetadataListCopier.copy(metadata);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metadata(GrpcGatewayRouteMetadata... metadata) {
            metadata(Arrays.asList(metadata));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metadata(Consumer<GrpcGatewayRouteMetadata.Builder>... metadata) {
            metadata(Stream.of(metadata).map(c -> GrpcGatewayRouteMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        @Transient
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public GrpcGatewayRouteMatch build() {
            return new GrpcGatewayRouteMatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
