/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the method header to be matched.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrpcMetadataMatchMethod implements SdkPojo, Serializable,
        ToCopyableBuilder<GrpcMetadataMatchMethod.Builder, GrpcMetadataMatchMethod> {
    private static final SdkField<String> EXACT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("exact")
            .getter(getter(GrpcMetadataMatchMethod::exact)).setter(setter(Builder::exact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exact").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("prefix")
            .getter(getter(GrpcMetadataMatchMethod::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()).build();

    private static final SdkField<MatchRange> RANGE_FIELD = SdkField.<MatchRange> builder(MarshallingType.SDK_POJO)
            .memberName("range").getter(getter(GrpcMetadataMatchMethod::range)).setter(setter(Builder::range))
            .constructor(MatchRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("range").build()).build();

    private static final SdkField<String> REGEX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("regex")
            .getter(getter(GrpcMetadataMatchMethod::regex)).setter(setter(Builder::regex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regex").build()).build();

    private static final SdkField<String> SUFFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("suffix")
            .getter(getter(GrpcMetadataMatchMethod::suffix)).setter(setter(Builder::suffix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suffix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXACT_FIELD, PREFIX_FIELD,
            RANGE_FIELD, REGEX_FIELD, SUFFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String exact;

    private final String prefix;

    private final MatchRange range;

    private final String regex;

    private final String suffix;

    private final Type type;

    private GrpcMetadataMatchMethod(BuilderImpl builder) {
        this.exact = builder.exact;
        this.prefix = builder.prefix;
        this.range = builder.range;
        this.regex = builder.regex;
        this.suffix = builder.suffix;
        this.type = builder.type;
    }

    /**
     * <p>
     * The exact method header to be matched on.
     * </p>
     * 
     * @return The exact method header to be matched on.
     */
    public final String exact() {
        return exact;
    }

    /**
     * <p>
     * The specified beginning characters of the method header to be matched on.
     * </p>
     * 
     * @return The specified beginning characters of the method header to be matched on.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * Returns the value of the Range property for this object.
     * 
     * @return The value of the Range property for this object.
     */
    public final MatchRange range() {
        return range;
    }

    /**
     * <p>
     * The regex used to match the method header.
     * </p>
     * 
     * @return The regex used to match the method header.
     */
    public final String regex() {
        return regex;
    }

    /**
     * <p>
     * The specified ending characters of the method header to match on.
     * </p>
     * 
     * @return The specified ending characters of the method header to match on.
     */
    public final String suffix() {
        return suffix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exact());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(range());
        hashCode = 31 * hashCode + Objects.hashCode(regex());
        hashCode = 31 * hashCode + Objects.hashCode(suffix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrpcMetadataMatchMethod)) {
            return false;
        }
        GrpcMetadataMatchMethod other = (GrpcMetadataMatchMethod) obj;
        return Objects.equals(exact(), other.exact()) && Objects.equals(prefix(), other.prefix())
                && Objects.equals(range(), other.range()) && Objects.equals(regex(), other.regex())
                && Objects.equals(suffix(), other.suffix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GrpcMetadataMatchMethod").add("Exact", exact()).add("Prefix", prefix()).add("Range", range())
                .add("Regex", regex()).add("Suffix", suffix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exact":
            return Optional.ofNullable(clazz.cast(exact()));
        case "prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "range":
            return Optional.ofNullable(clazz.cast(range()));
        case "regex":
            return Optional.ofNullable(clazz.cast(regex()));
        case "suffix":
            return Optional.ofNullable(clazz.cast(suffix()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #exact()} initialized to the given value.
     *
     * <p>
     * The exact method header to be matched on.
     * </p>
     * 
     * @param exact
     *        The exact method header to be matched on.
     */
    public static GrpcMetadataMatchMethod fromExact(String exact) {
        return builder().exact(exact).build();
    }

    /**
     * Create an instance of this class with {@link #prefix()} initialized to the given value.
     *
     * <p>
     * The specified beginning characters of the method header to be matched on.
     * </p>
     * 
     * @param prefix
     *        The specified beginning characters of the method header to be matched on.
     */
    public static GrpcMetadataMatchMethod fromPrefix(String prefix) {
        return builder().prefix(prefix).build();
    }

    /**
     * Create an instance of this class with {@link #range()} initialized to the given value.
     *
     * Sets the value of the Range property for this object.
     *
     * @param range
     *        The new value for the Range property for this object.
     */
    public static GrpcMetadataMatchMethod fromRange(MatchRange range) {
        return builder().range(range).build();
    }

    /**
     * Create an instance of this class with {@link #range()} initialized to the given value.
     *
     * Sets the value of the Range property for this object.
     *
     * @param range
     *        The new value for the Range property for this object.
     */
    public static GrpcMetadataMatchMethod fromRange(Consumer<MatchRange.Builder> range) {
        MatchRange.Builder builder = MatchRange.builder();
        range.accept(builder);
        return fromRange(builder.build());
    }

    /**
     * Create an instance of this class with {@link #regex()} initialized to the given value.
     *
     * <p>
     * The regex used to match the method header.
     * </p>
     * 
     * @param regex
     *        The regex used to match the method header.
     */
    public static GrpcMetadataMatchMethod fromRegex(String regex) {
        return builder().regex(regex).build();
    }

    /**
     * Create an instance of this class with {@link #suffix()} initialized to the given value.
     *
     * <p>
     * The specified ending characters of the method header to match on.
     * </p>
     * 
     * @param suffix
     *        The specified ending characters of the method header to match on.
     */
    public static GrpcMetadataMatchMethod fromSuffix(String suffix) {
        return builder().suffix(suffix).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrpcMetadataMatchMethod, T> g) {
        return obj -> g.apply((GrpcMetadataMatchMethod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GrpcMetadataMatchMethod> {
        /**
         * <p>
         * The exact method header to be matched on.
         * </p>
         * 
         * @param exact
         *        The exact method header to be matched on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exact(String exact);

        /**
         * <p>
         * The specified beginning characters of the method header to be matched on.
         * </p>
         * 
         * @param prefix
         *        The specified beginning characters of the method header to be matched on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * Sets the value of the Range property for this object.
         *
         * @param range
         *        The new value for the Range property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder range(MatchRange range);

        /**
         * Sets the value of the Range property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MatchRange.Builder} avoiding the need to
         * create one manually via {@link MatchRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link MatchRange.Builder#build()} is called immediately and its result
         * is passed to {@link #range(MatchRange)}.
         * 
         * @param range
         *        a consumer that will call methods on {@link MatchRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #range(MatchRange)
         */
        default Builder range(Consumer<MatchRange.Builder> range) {
            return range(MatchRange.builder().applyMutation(range).build());
        }

        /**
         * <p>
         * The regex used to match the method header.
         * </p>
         * 
         * @param regex
         *        The regex used to match the method header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regex(String regex);

        /**
         * <p>
         * The specified ending characters of the method header to match on.
         * </p>
         * 
         * @param suffix
         *        The specified ending characters of the method header to match on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suffix(String suffix);
    }

    static final class BuilderImpl implements Builder {
        private String exact;

        private String prefix;

        private MatchRange range;

        private String regex;

        private String suffix;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(GrpcMetadataMatchMethod model) {
            exact(model.exact);
            prefix(model.prefix);
            range(model.range);
            regex(model.regex);
            suffix(model.suffix);
        }

        public final String getExact() {
            return exact;
        }

        public final void setExact(String exact) {
            Object oldValue = this.exact;
            this.exact = exact;
            handleUnionValueChange(Type.EXACT, oldValue, this.exact);
        }

        @Override
        @Transient
        public final Builder exact(String exact) {
            Object oldValue = this.exact;
            this.exact = exact;
            handleUnionValueChange(Type.EXACT, oldValue, this.exact);
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            Object oldValue = this.prefix;
            this.prefix = prefix;
            handleUnionValueChange(Type.PREFIX, oldValue, this.prefix);
        }

        @Override
        @Transient
        public final Builder prefix(String prefix) {
            Object oldValue = this.prefix;
            this.prefix = prefix;
            handleUnionValueChange(Type.PREFIX, oldValue, this.prefix);
            return this;
        }

        public final MatchRange.Builder getRange() {
            return range != null ? range.toBuilder() : null;
        }

        public final void setRange(MatchRange.BuilderImpl range) {
            Object oldValue = this.range;
            this.range = range != null ? range.build() : null;
            handleUnionValueChange(Type.RANGE, oldValue, this.range);
        }

        @Override
        @Transient
        public final Builder range(MatchRange range) {
            Object oldValue = this.range;
            this.range = range;
            handleUnionValueChange(Type.RANGE, oldValue, this.range);
            return this;
        }

        public final String getRegex() {
            return regex;
        }

        public final void setRegex(String regex) {
            Object oldValue = this.regex;
            this.regex = regex;
            handleUnionValueChange(Type.REGEX, oldValue, this.regex);
        }

        @Override
        @Transient
        public final Builder regex(String regex) {
            Object oldValue = this.regex;
            this.regex = regex;
            handleUnionValueChange(Type.REGEX, oldValue, this.regex);
            return this;
        }

        public final String getSuffix() {
            return suffix;
        }

        public final void setSuffix(String suffix) {
            Object oldValue = this.suffix;
            this.suffix = suffix;
            handleUnionValueChange(Type.SUFFIX, oldValue, this.suffix);
        }

        @Override
        @Transient
        public final Builder suffix(String suffix) {
            Object oldValue = this.suffix;
            this.suffix = suffix;
            handleUnionValueChange(Type.SUFFIX, oldValue, this.suffix);
            return this;
        }

        @Override
        public GrpcMetadataMatchMethod build() {
            return new GrpcMetadataMatchMethod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see GrpcMetadataMatchMethod#type()
     */
    public enum Type {
        EXACT,

        PREFIX,

        RANGE,

        REGEX,

        SUFFIX,

        UNKNOWN_TO_SDK_VERSION
    }
}
