/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a retry policy. Specify at least one value for at least one of the types of
 * <code>RetryEvents</code>, a value for <code>maxRetries</code>, and a value for <code>perRetryTimeout</code>. Both
 * <code>server-error</code> and <code>gateway-error</code> under <code>httpRetryEvents</code> include the Envoy
 * <code>reset</code> policy. For more information on the <code>reset</code> policy, see the <a
 * href="https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_filters/router_filter#x-envoy-retry-on"
 * >Envoy documentation</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrpcRetryPolicy implements SdkPojo, Serializable, ToCopyableBuilder<GrpcRetryPolicy.Builder, GrpcRetryPolicy> {
    private static final SdkField<List<String>> GRPC_RETRY_EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("grpcRetryEvents")
            .getter(getter(GrpcRetryPolicy::grpcRetryEventsAsStrings))
            .setter(setter(Builder::grpcRetryEventsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grpcRetryEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> HTTP_RETRY_EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("httpRetryEvents")
            .getter(getter(GrpcRetryPolicy::httpRetryEvents))
            .setter(setter(Builder::httpRetryEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpRetryEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> MAX_RETRIES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("maxRetries").getter(getter(GrpcRetryPolicy::maxRetries)).setter(setter(Builder::maxRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRetries").build()).build();

    private static final SdkField<Duration> PER_RETRY_TIMEOUT_FIELD = SdkField.<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("perRetryTimeout").getter(getter(GrpcRetryPolicy::perRetryTimeout))
            .setter(setter(Builder::perRetryTimeout)).constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("perRetryTimeout").build()).build();

    private static final SdkField<List<String>> TCP_RETRY_EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("tcpRetryEvents")
            .getter(getter(GrpcRetryPolicy::tcpRetryEventsAsStrings))
            .setter(setter(Builder::tcpRetryEventsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tcpRetryEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRPC_RETRY_EVENTS_FIELD,
            HTTP_RETRY_EVENTS_FIELD, MAX_RETRIES_FIELD, PER_RETRY_TIMEOUT_FIELD, TCP_RETRY_EVENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> grpcRetryEvents;

    private final List<String> httpRetryEvents;

    private final Long maxRetries;

    private final Duration perRetryTimeout;

    private final List<String> tcpRetryEvents;

    private GrpcRetryPolicy(BuilderImpl builder) {
        this.grpcRetryEvents = builder.grpcRetryEvents;
        this.httpRetryEvents = builder.httpRetryEvents;
        this.maxRetries = builder.maxRetries;
        this.perRetryTimeout = builder.perRetryTimeout;
        this.tcpRetryEvents = builder.tcpRetryEvents;
    }

    /**
     * <p>
     * Specify at least one of the valid values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGrpcRetryEvents} method.
     * </p>
     * 
     * @return Specify at least one of the valid values.
     */
    public final List<GrpcRetryPolicyEvent> grpcRetryEvents() {
        return GrpcRetryPolicyEventsCopier.copyStringToEnum(grpcRetryEvents);
    }

    /**
     * For responses, this returns true if the service returned a value for the GrpcRetryEvents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGrpcRetryEvents() {
        return grpcRetryEvents != null && !(grpcRetryEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify at least one of the valid values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGrpcRetryEvents} method.
     * </p>
     * 
     * @return Specify at least one of the valid values.
     */
    public final List<String> grpcRetryEventsAsStrings() {
        return grpcRetryEvents;
    }

    /**
     * For responses, this returns true if the service returned a value for the HttpRetryEvents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHttpRetryEvents() {
        return httpRetryEvents != null && !(httpRetryEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify at least one of the following values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>server-error</b> – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>gateway-error</b> – HTTP status codes 502, 503, and 504
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>client-error</b> – HTTP status code 409
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>stream-error</b> – Retry on refused stream
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHttpRetryEvents} method.
     * </p>
     * 
     * @return Specify at least one of the following values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>server-error</b> – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>gateway-error</b> – HTTP status codes 502, 503, and 504
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>client-error</b> – HTTP status code 409
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>stream-error</b> – Retry on refused stream
     *         </p>
     *         </li>
     */
    public final List<String> httpRetryEvents() {
        return httpRetryEvents;
    }

    /**
     * <p>
     * The maximum number of retry attempts.
     * </p>
     * 
     * @return The maximum number of retry attempts.
     */
    public final Long maxRetries() {
        return maxRetries;
    }

    /**
     * <p>
     * The timeout for each retry attempt.
     * </p>
     * 
     * @return The timeout for each retry attempt.
     */
    public final Duration perRetryTimeout() {
        return perRetryTimeout;
    }

    /**
     * <p>
     * Specify a valid value. The event occurs before any processing of a request has started and is encountered when
     * the upstream is temporarily or permanently unavailable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTcpRetryEvents} method.
     * </p>
     * 
     * @return Specify a valid value. The event occurs before any processing of a request has started and is encountered
     *         when the upstream is temporarily or permanently unavailable.
     */
    public final List<TcpRetryPolicyEvent> tcpRetryEvents() {
        return TcpRetryPolicyEventsCopier.copyStringToEnum(tcpRetryEvents);
    }

    /**
     * For responses, this returns true if the service returned a value for the TcpRetryEvents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTcpRetryEvents() {
        return tcpRetryEvents != null && !(tcpRetryEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify a valid value. The event occurs before any processing of a request has started and is encountered when
     * the upstream is temporarily or permanently unavailable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTcpRetryEvents} method.
     * </p>
     * 
     * @return Specify a valid value. The event occurs before any processing of a request has started and is encountered
     *         when the upstream is temporarily or permanently unavailable.
     */
    public final List<String> tcpRetryEventsAsStrings() {
        return tcpRetryEvents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGrpcRetryEvents() ? grpcRetryEventsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasHttpRetryEvents() ? httpRetryEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(perRetryTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(hasTcpRetryEvents() ? tcpRetryEventsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrpcRetryPolicy)) {
            return false;
        }
        GrpcRetryPolicy other = (GrpcRetryPolicy) obj;
        return hasGrpcRetryEvents() == other.hasGrpcRetryEvents()
                && Objects.equals(grpcRetryEventsAsStrings(), other.grpcRetryEventsAsStrings())
                && hasHttpRetryEvents() == other.hasHttpRetryEvents()
                && Objects.equals(httpRetryEvents(), other.httpRetryEvents()) && Objects.equals(maxRetries(), other.maxRetries())
                && Objects.equals(perRetryTimeout(), other.perRetryTimeout()) && hasTcpRetryEvents() == other.hasTcpRetryEvents()
                && Objects.equals(tcpRetryEventsAsStrings(), other.tcpRetryEventsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GrpcRetryPolicy")
                .add("GrpcRetryEvents", hasGrpcRetryEvents() ? grpcRetryEventsAsStrings() : null)
                .add("HttpRetryEvents", hasHttpRetryEvents() ? httpRetryEvents() : null).add("MaxRetries", maxRetries())
                .add("PerRetryTimeout", perRetryTimeout())
                .add("TcpRetryEvents", hasTcpRetryEvents() ? tcpRetryEventsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "grpcRetryEvents":
            return Optional.ofNullable(clazz.cast(grpcRetryEventsAsStrings()));
        case "httpRetryEvents":
            return Optional.ofNullable(clazz.cast(httpRetryEvents()));
        case "maxRetries":
            return Optional.ofNullable(clazz.cast(maxRetries()));
        case "perRetryTimeout":
            return Optional.ofNullable(clazz.cast(perRetryTimeout()));
        case "tcpRetryEvents":
            return Optional.ofNullable(clazz.cast(tcpRetryEventsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrpcRetryPolicy, T> g) {
        return obj -> g.apply((GrpcRetryPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GrpcRetryPolicy> {
        /**
         * <p>
         * Specify at least one of the valid values.
         * </p>
         * 
         * @param grpcRetryEvents
         *        Specify at least one of the valid values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grpcRetryEventsWithStrings(Collection<String> grpcRetryEvents);

        /**
         * <p>
         * Specify at least one of the valid values.
         * </p>
         * 
         * @param grpcRetryEvents
         *        Specify at least one of the valid values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grpcRetryEventsWithStrings(String... grpcRetryEvents);

        /**
         * <p>
         * Specify at least one of the valid values.
         * </p>
         * 
         * @param grpcRetryEvents
         *        Specify at least one of the valid values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grpcRetryEvents(Collection<GrpcRetryPolicyEvent> grpcRetryEvents);

        /**
         * <p>
         * Specify at least one of the valid values.
         * </p>
         * 
         * @param grpcRetryEvents
         *        Specify at least one of the valid values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grpcRetryEvents(GrpcRetryPolicyEvent... grpcRetryEvents);

        /**
         * <p>
         * Specify at least one of the following values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>server-error</b> – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>gateway-error</b> – HTTP status codes 502, 503, and 504
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>client-error</b> – HTTP status code 409
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>stream-error</b> – Retry on refused stream
         * </p>
         * </li>
         * </ul>
         * 
         * @param httpRetryEvents
         *        Specify at least one of the following values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>server-error</b> – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>gateway-error</b> – HTTP status codes 502, 503, and 504
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>client-error</b> – HTTP status code 409
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>stream-error</b> – Retry on refused stream
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpRetryEvents(Collection<String> httpRetryEvents);

        /**
         * <p>
         * Specify at least one of the following values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>server-error</b> – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>gateway-error</b> – HTTP status codes 502, 503, and 504
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>client-error</b> – HTTP status code 409
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>stream-error</b> – Retry on refused stream
         * </p>
         * </li>
         * </ul>
         * 
         * @param httpRetryEvents
         *        Specify at least one of the following values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>server-error</b> – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>gateway-error</b> – HTTP status codes 502, 503, and 504
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>client-error</b> – HTTP status code 409
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>stream-error</b> – Retry on refused stream
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpRetryEvents(String... httpRetryEvents);

        /**
         * <p>
         * The maximum number of retry attempts.
         * </p>
         * 
         * @param maxRetries
         *        The maximum number of retry attempts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRetries(Long maxRetries);

        /**
         * <p>
         * The timeout for each retry attempt.
         * </p>
         * 
         * @param perRetryTimeout
         *        The timeout for each retry attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder perRetryTimeout(Duration perRetryTimeout);

        /**
         * <p>
         * The timeout for each retry attempt.
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #perRetryTimeout(Duration)}.
         * 
         * @param perRetryTimeout
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #perRetryTimeout(Duration)
         */
        default Builder perRetryTimeout(Consumer<Duration.Builder> perRetryTimeout) {
            return perRetryTimeout(Duration.builder().applyMutation(perRetryTimeout).build());
        }

        /**
         * <p>
         * Specify a valid value. The event occurs before any processing of a request has started and is encountered
         * when the upstream is temporarily or permanently unavailable.
         * </p>
         * 
         * @param tcpRetryEvents
         *        Specify a valid value. The event occurs before any processing of a request has started and is
         *        encountered when the upstream is temporarily or permanently unavailable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tcpRetryEventsWithStrings(Collection<String> tcpRetryEvents);

        /**
         * <p>
         * Specify a valid value. The event occurs before any processing of a request has started and is encountered
         * when the upstream is temporarily or permanently unavailable.
         * </p>
         * 
         * @param tcpRetryEvents
         *        Specify a valid value. The event occurs before any processing of a request has started and is
         *        encountered when the upstream is temporarily or permanently unavailable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tcpRetryEventsWithStrings(String... tcpRetryEvents);

        /**
         * <p>
         * Specify a valid value. The event occurs before any processing of a request has started and is encountered
         * when the upstream is temporarily or permanently unavailable.
         * </p>
         * 
         * @param tcpRetryEvents
         *        Specify a valid value. The event occurs before any processing of a request has started and is
         *        encountered when the upstream is temporarily or permanently unavailable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tcpRetryEvents(Collection<TcpRetryPolicyEvent> tcpRetryEvents);

        /**
         * <p>
         * Specify a valid value. The event occurs before any processing of a request has started and is encountered
         * when the upstream is temporarily or permanently unavailable.
         * </p>
         * 
         * @param tcpRetryEvents
         *        Specify a valid value. The event occurs before any processing of a request has started and is
         *        encountered when the upstream is temporarily or permanently unavailable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tcpRetryEvents(TcpRetryPolicyEvent... tcpRetryEvents);
    }

    static final class BuilderImpl implements Builder {
        private List<String> grpcRetryEvents = DefaultSdkAutoConstructList.getInstance();

        private List<String> httpRetryEvents = DefaultSdkAutoConstructList.getInstance();

        private Long maxRetries;

        private Duration perRetryTimeout;

        private List<String> tcpRetryEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GrpcRetryPolicy model) {
            grpcRetryEventsWithStrings(model.grpcRetryEvents);
            httpRetryEvents(model.httpRetryEvents);
            maxRetries(model.maxRetries);
            perRetryTimeout(model.perRetryTimeout);
            tcpRetryEventsWithStrings(model.tcpRetryEvents);
        }

        public final Collection<String> getGrpcRetryEvents() {
            if (grpcRetryEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return grpcRetryEvents;
        }

        public final void setGrpcRetryEvents(Collection<String> grpcRetryEvents) {
            this.grpcRetryEvents = GrpcRetryPolicyEventsCopier.copy(grpcRetryEvents);
        }

        @Override
        @Transient
        public final Builder grpcRetryEventsWithStrings(Collection<String> grpcRetryEvents) {
            this.grpcRetryEvents = GrpcRetryPolicyEventsCopier.copy(grpcRetryEvents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder grpcRetryEventsWithStrings(String... grpcRetryEvents) {
            grpcRetryEventsWithStrings(Arrays.asList(grpcRetryEvents));
            return this;
        }

        @Override
        @Transient
        public final Builder grpcRetryEvents(Collection<GrpcRetryPolicyEvent> grpcRetryEvents) {
            this.grpcRetryEvents = GrpcRetryPolicyEventsCopier.copyEnumToString(grpcRetryEvents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder grpcRetryEvents(GrpcRetryPolicyEvent... grpcRetryEvents) {
            grpcRetryEvents(Arrays.asList(grpcRetryEvents));
            return this;
        }

        public final Collection<String> getHttpRetryEvents() {
            if (httpRetryEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return httpRetryEvents;
        }

        public final void setHttpRetryEvents(Collection<String> httpRetryEvents) {
            this.httpRetryEvents = HttpRetryPolicyEventsCopier.copy(httpRetryEvents);
        }

        @Override
        @Transient
        public final Builder httpRetryEvents(Collection<String> httpRetryEvents) {
            this.httpRetryEvents = HttpRetryPolicyEventsCopier.copy(httpRetryEvents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder httpRetryEvents(String... httpRetryEvents) {
            httpRetryEvents(Arrays.asList(httpRetryEvents));
            return this;
        }

        public final Long getMaxRetries() {
            return maxRetries;
        }

        public final void setMaxRetries(Long maxRetries) {
            this.maxRetries = maxRetries;
        }

        @Override
        @Transient
        public final Builder maxRetries(Long maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final Duration.Builder getPerRetryTimeout() {
            return perRetryTimeout != null ? perRetryTimeout.toBuilder() : null;
        }

        public final void setPerRetryTimeout(Duration.BuilderImpl perRetryTimeout) {
            this.perRetryTimeout = perRetryTimeout != null ? perRetryTimeout.build() : null;
        }

        @Override
        @Transient
        public final Builder perRetryTimeout(Duration perRetryTimeout) {
            this.perRetryTimeout = perRetryTimeout;
            return this;
        }

        public final Collection<String> getTcpRetryEvents() {
            if (tcpRetryEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return tcpRetryEvents;
        }

        public final void setTcpRetryEvents(Collection<String> tcpRetryEvents) {
            this.tcpRetryEvents = TcpRetryPolicyEventsCopier.copy(tcpRetryEvents);
        }

        @Override
        @Transient
        public final Builder tcpRetryEventsWithStrings(Collection<String> tcpRetryEvents) {
            this.tcpRetryEvents = TcpRetryPolicyEventsCopier.copy(tcpRetryEvents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tcpRetryEventsWithStrings(String... tcpRetryEvents) {
            tcpRetryEventsWithStrings(Arrays.asList(tcpRetryEvents));
            return this;
        }

        @Override
        @Transient
        public final Builder tcpRetryEvents(Collection<TcpRetryPolicyEvent> tcpRetryEvents) {
            this.tcpRetryEvents = TcpRetryPolicyEventsCopier.copyEnumToString(tcpRetryEvents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tcpRetryEvents(TcpRetryPolicyEvent... tcpRetryEvents) {
            tcpRetryEvents(Arrays.asList(tcpRetryEvents));
            return this;
        }

        @Override
        public GrpcRetryPolicy build() {
            return new GrpcRetryPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
