/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the criteria for determining a request match.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpGatewayRouteMatch implements SdkPojo, Serializable,
        ToCopyableBuilder<HttpGatewayRouteMatch.Builder, HttpGatewayRouteMatch> {
    private static final SdkField<List<HttpGatewayRouteHeader>> HEADERS_FIELD = SdkField
            .<List<HttpGatewayRouteHeader>> builder(MarshallingType.LIST)
            .memberName("headers")
            .getter(getter(HttpGatewayRouteMatch::headers))
            .setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HttpGatewayRouteHeader> builder(MarshallingType.SDK_POJO)
                                            .constructor(HttpGatewayRouteHeader::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<GatewayRouteHostnameMatch> HOSTNAME_FIELD = SdkField
            .<GatewayRouteHostnameMatch> builder(MarshallingType.SDK_POJO).memberName("hostname")
            .getter(getter(HttpGatewayRouteMatch::hostname)).setter(setter(Builder::hostname))
            .constructor(GatewayRouteHostnameMatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()).build();

    private static final SdkField<String> METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("method")
            .getter(getter(HttpGatewayRouteMatch::methodAsString)).setter(setter(Builder::method))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("method").build()).build();

    private static final SdkField<HttpPathMatch> PATH_FIELD = SdkField.<HttpPathMatch> builder(MarshallingType.SDK_POJO)
            .memberName("path").getter(getter(HttpGatewayRouteMatch::path)).setter(setter(Builder::path))
            .constructor(HttpPathMatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("prefix")
            .getter(getter(HttpGatewayRouteMatch::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()).build();

    private static final SdkField<List<HttpQueryParameter>> QUERY_PARAMETERS_FIELD = SdkField
            .<List<HttpQueryParameter>> builder(MarshallingType.LIST)
            .memberName("queryParameters")
            .getter(getter(HttpGatewayRouteMatch::queryParameters))
            .setter(setter(Builder::queryParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HttpQueryParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(HttpQueryParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADERS_FIELD, HOSTNAME_FIELD,
            METHOD_FIELD, PATH_FIELD, PREFIX_FIELD, QUERY_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<HttpGatewayRouteHeader> headers;

    private final GatewayRouteHostnameMatch hostname;

    private final String method;

    private final HttpPathMatch path;

    private final String prefix;

    private final List<HttpQueryParameter> queryParameters;

    private HttpGatewayRouteMatch(BuilderImpl builder) {
        this.headers = builder.headers;
        this.hostname = builder.hostname;
        this.method = builder.method;
        this.path = builder.path;
        this.prefix = builder.prefix;
        this.queryParameters = builder.queryParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Headers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHeaders() {
        return headers != null && !(headers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The client request headers to match on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaders} method.
     * </p>
     * 
     * @return The client request headers to match on.
     */
    public final List<HttpGatewayRouteHeader> headers() {
        return headers;
    }

    /**
     * <p>
     * The host name to match on.
     * </p>
     * 
     * @return The host name to match on.
     */
    public final GatewayRouteHostnameMatch hostname() {
        return hostname;
    }

    /**
     * <p>
     * The method to match on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #method} will
     * return {@link HttpMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #methodAsString}.
     * </p>
     * 
     * @return The method to match on.
     * @see HttpMethod
     */
    public final HttpMethod method() {
        return HttpMethod.fromValue(method);
    }

    /**
     * <p>
     * The method to match on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #method} will
     * return {@link HttpMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #methodAsString}.
     * </p>
     * 
     * @return The method to match on.
     * @see HttpMethod
     */
    public final String methodAsString() {
        return method;
    }

    /**
     * <p>
     * The path to match on.
     * </p>
     * 
     * @return The path to match on.
     */
    public final HttpPathMatch path() {
        return path;
    }

    /**
     * <p>
     * Specifies the path to match requests with. This parameter must always start with <code>/</code>, which by itself
     * matches all requests to the virtual service name. You can also match for path-based routing of requests. For
     * example, if your virtual service name is <code>my-service.local</code> and you want the route to match requests
     * to <code>my-service.local/metrics</code>, your prefix should be <code>/metrics</code>.
     * </p>
     * 
     * @return Specifies the path to match requests with. This parameter must always start with <code>/</code>, which by
     *         itself matches all requests to the virtual service name. You can also match for path-based routing of
     *         requests. For example, if your virtual service name is <code>my-service.local</code> and you want the
     *         route to match requests to <code>my-service.local/metrics</code>, your prefix should be
     *         <code>/metrics</code>.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQueryParameters() {
        return queryParameters != null && !(queryParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The query parameter to match on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryParameters} method.
     * </p>
     * 
     * @return The query parameter to match on.
     */
    public final List<HttpQueryParameter> queryParameters() {
        return queryParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaders() ? headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(methodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryParameters() ? queryParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpGatewayRouteMatch)) {
            return false;
        }
        HttpGatewayRouteMatch other = (HttpGatewayRouteMatch) obj;
        return hasHeaders() == other.hasHeaders() && Objects.equals(headers(), other.headers())
                && Objects.equals(hostname(), other.hostname()) && Objects.equals(methodAsString(), other.methodAsString())
                && Objects.equals(path(), other.path()) && Objects.equals(prefix(), other.prefix())
                && hasQueryParameters() == other.hasQueryParameters()
                && Objects.equals(queryParameters(), other.queryParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpGatewayRouteMatch").add("Headers", hasHeaders() ? headers() : null)
                .add("Hostname", hostname()).add("Method", methodAsString()).add("Path", path()).add("Prefix", prefix())
                .add("QueryParameters", hasQueryParameters() ? queryParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "headers":
            return Optional.ofNullable(clazz.cast(headers()));
        case "hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "method":
            return Optional.ofNullable(clazz.cast(methodAsString()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        case "prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "queryParameters":
            return Optional.ofNullable(clazz.cast(queryParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpGatewayRouteMatch, T> g) {
        return obj -> g.apply((HttpGatewayRouteMatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpGatewayRouteMatch> {
        /**
         * <p>
         * The client request headers to match on.
         * </p>
         * 
         * @param headers
         *        The client request headers to match on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Collection<HttpGatewayRouteHeader> headers);

        /**
         * <p>
         * The client request headers to match on.
         * </p>
         * 
         * @param headers
         *        The client request headers to match on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(HttpGatewayRouteHeader... headers);

        /**
         * <p>
         * The client request headers to match on.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<HttpGatewayRouteHeader>.Builder}
         * avoiding the need to create one manually via {@link List<HttpGatewayRouteHeader>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HttpGatewayRouteHeader>.Builder#build()} is called
         * immediately and its result is passed to {@link #headers(List<HttpGatewayRouteHeader>)}.
         * 
         * @param headers
         *        a consumer that will call methods on {@link List<HttpGatewayRouteHeader>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headers(List<HttpGatewayRouteHeader>)
         */
        Builder headers(Consumer<HttpGatewayRouteHeader.Builder>... headers);

        /**
         * <p>
         * The host name to match on.
         * </p>
         * 
         * @param hostname
         *        The host name to match on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(GatewayRouteHostnameMatch hostname);

        /**
         * <p>
         * The host name to match on.
         * </p>
         * This is a convenience method that creates an instance of the {@link GatewayRouteHostnameMatch.Builder}
         * avoiding the need to create one manually via {@link GatewayRouteHostnameMatch#builder()}.
         *
         * When the {@link Consumer} completes, {@link GatewayRouteHostnameMatch.Builder#build()} is called immediately
         * and its result is passed to {@link #hostname(GatewayRouteHostnameMatch)}.
         * 
         * @param hostname
         *        a consumer that will call methods on {@link GatewayRouteHostnameMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostname(GatewayRouteHostnameMatch)
         */
        default Builder hostname(Consumer<GatewayRouteHostnameMatch.Builder> hostname) {
            return hostname(GatewayRouteHostnameMatch.builder().applyMutation(hostname).build());
        }

        /**
         * <p>
         * The method to match on.
         * </p>
         * 
         * @param method
         *        The method to match on.
         * @see HttpMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpMethod
         */
        Builder method(String method);

        /**
         * <p>
         * The method to match on.
         * </p>
         * 
         * @param method
         *        The method to match on.
         * @see HttpMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpMethod
         */
        Builder method(HttpMethod method);

        /**
         * <p>
         * The path to match on.
         * </p>
         * 
         * @param path
         *        The path to match on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(HttpPathMatch path);

        /**
         * <p>
         * The path to match on.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpPathMatch.Builder} avoiding the need
         * to create one manually via {@link HttpPathMatch#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpPathMatch.Builder#build()} is called immediately and its
         * result is passed to {@link #path(HttpPathMatch)}.
         * 
         * @param path
         *        a consumer that will call methods on {@link HttpPathMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #path(HttpPathMatch)
         */
        default Builder path(Consumer<HttpPathMatch.Builder> path) {
            return path(HttpPathMatch.builder().applyMutation(path).build());
        }

        /**
         * <p>
         * Specifies the path to match requests with. This parameter must always start with <code>/</code>, which by
         * itself matches all requests to the virtual service name. You can also match for path-based routing of
         * requests. For example, if your virtual service name is <code>my-service.local</code> and you want the route
         * to match requests to <code>my-service.local/metrics</code>, your prefix should be <code>/metrics</code>.
         * </p>
         * 
         * @param prefix
         *        Specifies the path to match requests with. This parameter must always start with <code>/</code>, which
         *        by itself matches all requests to the virtual service name. You can also match for path-based routing
         *        of requests. For example, if your virtual service name is <code>my-service.local</code> and you want
         *        the route to match requests to <code>my-service.local/metrics</code>, your prefix should be
         *        <code>/metrics</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The query parameter to match on.
         * </p>
         * 
         * @param queryParameters
         *        The query parameter to match on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParameters(Collection<HttpQueryParameter> queryParameters);

        /**
         * <p>
         * The query parameter to match on.
         * </p>
         * 
         * @param queryParameters
         *        The query parameter to match on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParameters(HttpQueryParameter... queryParameters);

        /**
         * <p>
         * The query parameter to match on.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<HttpQueryParameter>.Builder}
         * avoiding the need to create one manually via {@link List<HttpQueryParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HttpQueryParameter>.Builder#build()} is called immediately
         * and its result is passed to {@link #queryParameters(List<HttpQueryParameter>)}.
         * 
         * @param queryParameters
         *        a consumer that will call methods on {@link List<HttpQueryParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryParameters(List<HttpQueryParameter>)
         */
        Builder queryParameters(Consumer<HttpQueryParameter.Builder>... queryParameters);
    }

    static final class BuilderImpl implements Builder {
        private List<HttpGatewayRouteHeader> headers = DefaultSdkAutoConstructList.getInstance();

        private GatewayRouteHostnameMatch hostname;

        private String method;

        private HttpPathMatch path;

        private String prefix;

        private List<HttpQueryParameter> queryParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HttpGatewayRouteMatch model) {
            headers(model.headers);
            hostname(model.hostname);
            method(model.method);
            path(model.path);
            prefix(model.prefix);
            queryParameters(model.queryParameters);
        }

        public final List<HttpGatewayRouteHeader.Builder> getHeaders() {
            List<HttpGatewayRouteHeader.Builder> result = HttpGatewayRouteHeadersCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<HttpGatewayRouteHeader.BuilderImpl> headers) {
            this.headers = HttpGatewayRouteHeadersCopier.copyFromBuilder(headers);
        }

        @Override
        @Transient
        public final Builder headers(Collection<HttpGatewayRouteHeader> headers) {
            this.headers = HttpGatewayRouteHeadersCopier.copy(headers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder headers(HttpGatewayRouteHeader... headers) {
            headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder headers(Consumer<HttpGatewayRouteHeader.Builder>... headers) {
            headers(Stream.of(headers).map(c -> HttpGatewayRouteHeader.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final GatewayRouteHostnameMatch.Builder getHostname() {
            return hostname != null ? hostname.toBuilder() : null;
        }

        public final void setHostname(GatewayRouteHostnameMatch.BuilderImpl hostname) {
            this.hostname = hostname != null ? hostname.build() : null;
        }

        @Override
        @Transient
        public final Builder hostname(GatewayRouteHostnameMatch hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getMethod() {
            return method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        @Transient
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        @Override
        @Transient
        public final Builder method(HttpMethod method) {
            this.method(method == null ? null : method.toString());
            return this;
        }

        public final HttpPathMatch.Builder getPath() {
            return path != null ? path.toBuilder() : null;
        }

        public final void setPath(HttpPathMatch.BuilderImpl path) {
            this.path = path != null ? path.build() : null;
        }

        @Override
        @Transient
        public final Builder path(HttpPathMatch path) {
            this.path = path;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        @Transient
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final List<HttpQueryParameter.Builder> getQueryParameters() {
            List<HttpQueryParameter.Builder> result = HttpQueryParametersCopier.copyToBuilder(this.queryParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryParameters(Collection<HttpQueryParameter.BuilderImpl> queryParameters) {
            this.queryParameters = HttpQueryParametersCopier.copyFromBuilder(queryParameters);
        }

        @Override
        @Transient
        public final Builder queryParameters(Collection<HttpQueryParameter> queryParameters) {
            this.queryParameters = HttpQueryParametersCopier.copy(queryParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder queryParameters(HttpQueryParameter... queryParameters) {
            queryParameters(Arrays.asList(queryParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder queryParameters(Consumer<HttpQueryParameter.Builder>... queryParameters) {
            queryParameters(Stream.of(queryParameters).map(c -> HttpQueryParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public HttpGatewayRouteMatch build() {
            return new HttpGatewayRouteMatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
