/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the outlier detection for a virtual node's listener.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutlierDetection implements SdkPojo, Serializable,
        ToCopyableBuilder<OutlierDetection.Builder, OutlierDetection> {
    private static final SdkField<Duration> BASE_EJECTION_DURATION_FIELD = SdkField.<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("baseEjectionDuration").getter(getter(OutlierDetection::baseEjectionDuration))
            .setter(setter(Builder::baseEjectionDuration)).constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseEjectionDuration").build())
            .build();

    private static final SdkField<Duration> INTERVAL_FIELD = SdkField.<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("interval").getter(getter(OutlierDetection::interval)).setter(setter(Builder::interval))
            .constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interval").build()).build();

    private static final SdkField<Integer> MAX_EJECTION_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxEjectionPercent").getter(getter(OutlierDetection::maxEjectionPercent))
            .setter(setter(Builder::maxEjectionPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxEjectionPercent").build())
            .build();

    private static final SdkField<Long> MAX_SERVER_ERRORS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("maxServerErrors").getter(getter(OutlierDetection::maxServerErrors))
            .setter(setter(Builder::maxServerErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxServerErrors").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_EJECTION_DURATION_FIELD,
            INTERVAL_FIELD, MAX_EJECTION_PERCENT_FIELD, MAX_SERVER_ERRORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Duration baseEjectionDuration;

    private final Duration interval;

    private final Integer maxEjectionPercent;

    private final Long maxServerErrors;

    private OutlierDetection(BuilderImpl builder) {
        this.baseEjectionDuration = builder.baseEjectionDuration;
        this.interval = builder.interval;
        this.maxEjectionPercent = builder.maxEjectionPercent;
        this.maxServerErrors = builder.maxServerErrors;
    }

    /**
     * <p>
     * The base amount of time for which a host is ejected.
     * </p>
     * 
     * @return The base amount of time for which a host is ejected.
     */
    public final Duration baseEjectionDuration() {
        return baseEjectionDuration;
    }

    /**
     * <p>
     * The time interval between ejection sweep analysis.
     * </p>
     * 
     * @return The time interval between ejection sweep analysis.
     */
    public final Duration interval() {
        return interval;
    }

    /**
     * <p>
     * Maximum percentage of hosts in load balancing pool for upstream service that can be ejected. Will eject at least
     * one host regardless of the value.
     * </p>
     * 
     * @return Maximum percentage of hosts in load balancing pool for upstream service that can be ejected. Will eject
     *         at least one host regardless of the value.
     */
    public final Integer maxEjectionPercent() {
        return maxEjectionPercent;
    }

    /**
     * <p>
     * Number of consecutive <code>5xx</code> errors required for ejection.
     * </p>
     * 
     * @return Number of consecutive <code>5xx</code> errors required for ejection.
     */
    public final Long maxServerErrors() {
        return maxServerErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseEjectionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        hashCode = 31 * hashCode + Objects.hashCode(maxEjectionPercent());
        hashCode = 31 * hashCode + Objects.hashCode(maxServerErrors());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutlierDetection)) {
            return false;
        }
        OutlierDetection other = (OutlierDetection) obj;
        return Objects.equals(baseEjectionDuration(), other.baseEjectionDuration())
                && Objects.equals(interval(), other.interval())
                && Objects.equals(maxEjectionPercent(), other.maxEjectionPercent())
                && Objects.equals(maxServerErrors(), other.maxServerErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutlierDetection").add("BaseEjectionDuration", baseEjectionDuration())
                .add("Interval", interval()).add("MaxEjectionPercent", maxEjectionPercent())
                .add("MaxServerErrors", maxServerErrors()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "baseEjectionDuration":
            return Optional.ofNullable(clazz.cast(baseEjectionDuration()));
        case "interval":
            return Optional.ofNullable(clazz.cast(interval()));
        case "maxEjectionPercent":
            return Optional.ofNullable(clazz.cast(maxEjectionPercent()));
        case "maxServerErrors":
            return Optional.ofNullable(clazz.cast(maxServerErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutlierDetection, T> g) {
        return obj -> g.apply((OutlierDetection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutlierDetection> {
        /**
         * <p>
         * The base amount of time for which a host is ejected.
         * </p>
         * 
         * @param baseEjectionDuration
         *        The base amount of time for which a host is ejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseEjectionDuration(Duration baseEjectionDuration);

        /**
         * <p>
         * The base amount of time for which a host is ejected.
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #baseEjectionDuration(Duration)}.
         * 
         * @param baseEjectionDuration
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baseEjectionDuration(Duration)
         */
        default Builder baseEjectionDuration(Consumer<Duration.Builder> baseEjectionDuration) {
            return baseEjectionDuration(Duration.builder().applyMutation(baseEjectionDuration).build());
        }

        /**
         * <p>
         * The time interval between ejection sweep analysis.
         * </p>
         * 
         * @param interval
         *        The time interval between ejection sweep analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(Duration interval);

        /**
         * <p>
         * The time interval between ejection sweep analysis.
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #interval(Duration)}.
         * 
         * @param interval
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interval(Duration)
         */
        default Builder interval(Consumer<Duration.Builder> interval) {
            return interval(Duration.builder().applyMutation(interval).build());
        }

        /**
         * <p>
         * Maximum percentage of hosts in load balancing pool for upstream service that can be ejected. Will eject at
         * least one host regardless of the value.
         * </p>
         * 
         * @param maxEjectionPercent
         *        Maximum percentage of hosts in load balancing pool for upstream service that can be ejected. Will
         *        eject at least one host regardless of the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxEjectionPercent(Integer maxEjectionPercent);

        /**
         * <p>
         * Number of consecutive <code>5xx</code> errors required for ejection.
         * </p>
         * 
         * @param maxServerErrors
         *        Number of consecutive <code>5xx</code> errors required for ejection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxServerErrors(Long maxServerErrors);
    }

    static final class BuilderImpl implements Builder {
        private Duration baseEjectionDuration;

        private Duration interval;

        private Integer maxEjectionPercent;

        private Long maxServerErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(OutlierDetection model) {
            baseEjectionDuration(model.baseEjectionDuration);
            interval(model.interval);
            maxEjectionPercent(model.maxEjectionPercent);
            maxServerErrors(model.maxServerErrors);
        }

        public final Duration.Builder getBaseEjectionDuration() {
            return baseEjectionDuration != null ? baseEjectionDuration.toBuilder() : null;
        }

        public final void setBaseEjectionDuration(Duration.BuilderImpl baseEjectionDuration) {
            this.baseEjectionDuration = baseEjectionDuration != null ? baseEjectionDuration.build() : null;
        }

        @Override
        @Transient
        public final Builder baseEjectionDuration(Duration baseEjectionDuration) {
            this.baseEjectionDuration = baseEjectionDuration;
            return this;
        }

        public final Duration.Builder getInterval() {
            return interval != null ? interval.toBuilder() : null;
        }

        public final void setInterval(Duration.BuilderImpl interval) {
            this.interval = interval != null ? interval.build() : null;
        }

        @Override
        @Transient
        public final Builder interval(Duration interval) {
            this.interval = interval;
            return this;
        }

        public final Integer getMaxEjectionPercent() {
            return maxEjectionPercent;
        }

        public final void setMaxEjectionPercent(Integer maxEjectionPercent) {
            this.maxEjectionPercent = maxEjectionPercent;
        }

        @Override
        @Transient
        public final Builder maxEjectionPercent(Integer maxEjectionPercent) {
            this.maxEjectionPercent = maxEjectionPercent;
            return this;
        }

        public final Long getMaxServerErrors() {
            return maxServerErrors;
        }

        public final void setMaxServerErrors(Long maxServerErrors) {
            this.maxServerErrors = maxServerErrors;
        }

        @Override
        @Transient
        public final Builder maxServerErrors(Long maxServerErrors) {
            this.maxServerErrors = maxServerErrors;
            return this;
        }

        @Override
        public OutlierDetection build() {
            return new OutlierDetection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
