/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a route specification. Specify one route type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteSpec implements SdkPojo, Serializable, ToCopyableBuilder<RouteSpec.Builder, RouteSpec> {
    private static final SdkField<GrpcRoute> GRPC_ROUTE_FIELD = SdkField.<GrpcRoute> builder(MarshallingType.SDK_POJO)
            .memberName("grpcRoute").getter(getter(RouteSpec::grpcRoute)).setter(setter(Builder::grpcRoute))
            .constructor(GrpcRoute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grpcRoute").build()).build();

    private static final SdkField<HttpRoute> HTTP2_ROUTE_FIELD = SdkField.<HttpRoute> builder(MarshallingType.SDK_POJO)
            .memberName("http2Route").getter(getter(RouteSpec::http2Route)).setter(setter(Builder::http2Route))
            .constructor(HttpRoute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("http2Route").build()).build();

    private static final SdkField<HttpRoute> HTTP_ROUTE_FIELD = SdkField.<HttpRoute> builder(MarshallingType.SDK_POJO)
            .memberName("httpRoute").getter(getter(RouteSpec::httpRoute)).setter(setter(Builder::httpRoute))
            .constructor(HttpRoute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpRoute").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(RouteSpec::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<TcpRoute> TCP_ROUTE_FIELD = SdkField.<TcpRoute> builder(MarshallingType.SDK_POJO)
            .memberName("tcpRoute").getter(getter(RouteSpec::tcpRoute)).setter(setter(Builder::tcpRoute))
            .constructor(TcpRoute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tcpRoute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRPC_ROUTE_FIELD,
            HTTP2_ROUTE_FIELD, HTTP_ROUTE_FIELD, PRIORITY_FIELD, TCP_ROUTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final GrpcRoute grpcRoute;

    private final HttpRoute http2Route;

    private final HttpRoute httpRoute;

    private final Integer priority;

    private final TcpRoute tcpRoute;

    private RouteSpec(BuilderImpl builder) {
        this.grpcRoute = builder.grpcRoute;
        this.http2Route = builder.http2Route;
        this.httpRoute = builder.httpRoute;
        this.priority = builder.priority;
        this.tcpRoute = builder.tcpRoute;
    }

    /**
     * <p>
     * An object that represents the specification of a gRPC route.
     * </p>
     * 
     * @return An object that represents the specification of a gRPC route.
     */
    public final GrpcRoute grpcRoute() {
        return grpcRoute;
    }

    /**
     * <p>
     * An object that represents the specification of an HTTP/2 route.
     * </p>
     * 
     * @return An object that represents the specification of an HTTP/2 route.
     */
    public final HttpRoute http2Route() {
        return http2Route;
    }

    /**
     * <p>
     * An object that represents the specification of an HTTP route.
     * </p>
     * 
     * @return An object that represents the specification of an HTTP route.
     */
    public final HttpRoute httpRoute() {
        return httpRoute;
    }

    /**
     * <p>
     * The priority for the route. Routes are matched based on the specified value, where 0 is the highest priority.
     * </p>
     * 
     * @return The priority for the route. Routes are matched based on the specified value, where 0 is the highest
     *         priority.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * An object that represents the specification of a TCP route.
     * </p>
     * 
     * @return An object that represents the specification of a TCP route.
     */
    public final TcpRoute tcpRoute() {
        return tcpRoute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(grpcRoute());
        hashCode = 31 * hashCode + Objects.hashCode(http2Route());
        hashCode = 31 * hashCode + Objects.hashCode(httpRoute());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(tcpRoute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteSpec)) {
            return false;
        }
        RouteSpec other = (RouteSpec) obj;
        return Objects.equals(grpcRoute(), other.grpcRoute()) && Objects.equals(http2Route(), other.http2Route())
                && Objects.equals(httpRoute(), other.httpRoute()) && Objects.equals(priority(), other.priority())
                && Objects.equals(tcpRoute(), other.tcpRoute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteSpec").add("GrpcRoute", grpcRoute()).add("Http2Route", http2Route())
                .add("HttpRoute", httpRoute()).add("Priority", priority()).add("TcpRoute", tcpRoute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "grpcRoute":
            return Optional.ofNullable(clazz.cast(grpcRoute()));
        case "http2Route":
            return Optional.ofNullable(clazz.cast(http2Route()));
        case "httpRoute":
            return Optional.ofNullable(clazz.cast(httpRoute()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "tcpRoute":
            return Optional.ofNullable(clazz.cast(tcpRoute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouteSpec, T> g) {
        return obj -> g.apply((RouteSpec) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteSpec> {
        /**
         * <p>
         * An object that represents the specification of a gRPC route.
         * </p>
         * 
         * @param grpcRoute
         *        An object that represents the specification of a gRPC route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grpcRoute(GrpcRoute grpcRoute);

        /**
         * <p>
         * An object that represents the specification of a gRPC route.
         * </p>
         * This is a convenience method that creates an instance of the {@link GrpcRoute.Builder} avoiding the need to
         * create one manually via {@link GrpcRoute#builder()}.
         *
         * When the {@link Consumer} completes, {@link GrpcRoute.Builder#build()} is called immediately and its result
         * is passed to {@link #grpcRoute(GrpcRoute)}.
         * 
         * @param grpcRoute
         *        a consumer that will call methods on {@link GrpcRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grpcRoute(GrpcRoute)
         */
        default Builder grpcRoute(Consumer<GrpcRoute.Builder> grpcRoute) {
            return grpcRoute(GrpcRoute.builder().applyMutation(grpcRoute).build());
        }

        /**
         * <p>
         * An object that represents the specification of an HTTP/2 route.
         * </p>
         * 
         * @param http2Route
         *        An object that represents the specification of an HTTP/2 route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder http2Route(HttpRoute http2Route);

        /**
         * <p>
         * An object that represents the specification of an HTTP/2 route.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpRoute.Builder} avoiding the need to
         * create one manually via {@link HttpRoute#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpRoute.Builder#build()} is called immediately and its result
         * is passed to {@link #http2Route(HttpRoute)}.
         * 
         * @param http2Route
         *        a consumer that will call methods on {@link HttpRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #http2Route(HttpRoute)
         */
        default Builder http2Route(Consumer<HttpRoute.Builder> http2Route) {
            return http2Route(HttpRoute.builder().applyMutation(http2Route).build());
        }

        /**
         * <p>
         * An object that represents the specification of an HTTP route.
         * </p>
         * 
         * @param httpRoute
         *        An object that represents the specification of an HTTP route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpRoute(HttpRoute httpRoute);

        /**
         * <p>
         * An object that represents the specification of an HTTP route.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpRoute.Builder} avoiding the need to
         * create one manually via {@link HttpRoute#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpRoute.Builder#build()} is called immediately and its result
         * is passed to {@link #httpRoute(HttpRoute)}.
         * 
         * @param httpRoute
         *        a consumer that will call methods on {@link HttpRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpRoute(HttpRoute)
         */
        default Builder httpRoute(Consumer<HttpRoute.Builder> httpRoute) {
            return httpRoute(HttpRoute.builder().applyMutation(httpRoute).build());
        }

        /**
         * <p>
         * The priority for the route. Routes are matched based on the specified value, where 0 is the highest priority.
         * </p>
         * 
         * @param priority
         *        The priority for the route. Routes are matched based on the specified value, where 0 is the highest
         *        priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * An object that represents the specification of a TCP route.
         * </p>
         * 
         * @param tcpRoute
         *        An object that represents the specification of a TCP route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tcpRoute(TcpRoute tcpRoute);

        /**
         * <p>
         * An object that represents the specification of a TCP route.
         * </p>
         * This is a convenience method that creates an instance of the {@link TcpRoute.Builder} avoiding the need to
         * create one manually via {@link TcpRoute#builder()}.
         *
         * When the {@link Consumer} completes, {@link TcpRoute.Builder#build()} is called immediately and its result is
         * passed to {@link #tcpRoute(TcpRoute)}.
         * 
         * @param tcpRoute
         *        a consumer that will call methods on {@link TcpRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tcpRoute(TcpRoute)
         */
        default Builder tcpRoute(Consumer<TcpRoute.Builder> tcpRoute) {
            return tcpRoute(TcpRoute.builder().applyMutation(tcpRoute).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GrpcRoute grpcRoute;

        private HttpRoute http2Route;

        private HttpRoute httpRoute;

        private Integer priority;

        private TcpRoute tcpRoute;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteSpec model) {
            grpcRoute(model.grpcRoute);
            http2Route(model.http2Route);
            httpRoute(model.httpRoute);
            priority(model.priority);
            tcpRoute(model.tcpRoute);
        }

        public final GrpcRoute.Builder getGrpcRoute() {
            return grpcRoute != null ? grpcRoute.toBuilder() : null;
        }

        public final void setGrpcRoute(GrpcRoute.BuilderImpl grpcRoute) {
            this.grpcRoute = grpcRoute != null ? grpcRoute.build() : null;
        }

        @Override
        @Transient
        public final Builder grpcRoute(GrpcRoute grpcRoute) {
            this.grpcRoute = grpcRoute;
            return this;
        }

        public final HttpRoute.Builder getHttp2Route() {
            return http2Route != null ? http2Route.toBuilder() : null;
        }

        public final void setHttp2Route(HttpRoute.BuilderImpl http2Route) {
            this.http2Route = http2Route != null ? http2Route.build() : null;
        }

        @Override
        @Transient
        public final Builder http2Route(HttpRoute http2Route) {
            this.http2Route = http2Route;
            return this;
        }

        public final HttpRoute.Builder getHttpRoute() {
            return httpRoute != null ? httpRoute.toBuilder() : null;
        }

        public final void setHttpRoute(HttpRoute.BuilderImpl httpRoute) {
            this.httpRoute = httpRoute != null ? httpRoute.build() : null;
        }

        @Override
        @Transient
        public final Builder httpRoute(HttpRoute httpRoute) {
            this.httpRoute = httpRoute;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        @Transient
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final TcpRoute.Builder getTcpRoute() {
            return tcpRoute != null ? tcpRoute.toBuilder() : null;
        }

        public final void setTcpRoute(TcpRoute.BuilderImpl tcpRoute) {
            this.tcpRoute = tcpRoute != null ? tcpRoute.build() : null;
        }

        @Override
        @Transient
        public final Builder tcpRoute(TcpRoute tcpRoute) {
            this.tcpRoute = tcpRoute;
            return this;
        }

        @Override
        public RouteSpec build() {
            return new RouteSpec(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
