/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a Transport Layer Security (TLS) validation context trust.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TlsValidationContextTrust implements SdkPojo, Serializable,
        ToCopyableBuilder<TlsValidationContextTrust.Builder, TlsValidationContextTrust> {
    private static final SdkField<TlsValidationContextAcmTrust> ACM_FIELD = SdkField
            .<TlsValidationContextAcmTrust> builder(MarshallingType.SDK_POJO).memberName("acm")
            .getter(getter(TlsValidationContextTrust::acm)).setter(setter(Builder::acm))
            .constructor(TlsValidationContextAcmTrust::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acm").build()).build();

    private static final SdkField<TlsValidationContextFileTrust> FILE_FIELD = SdkField
            .<TlsValidationContextFileTrust> builder(MarshallingType.SDK_POJO).memberName("file")
            .getter(getter(TlsValidationContextTrust::file)).setter(setter(Builder::file))
            .constructor(TlsValidationContextFileTrust::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()).build();

    private static final SdkField<TlsValidationContextSdsTrust> SDS_FIELD = SdkField
            .<TlsValidationContextSdsTrust> builder(MarshallingType.SDK_POJO).memberName("sds")
            .getter(getter(TlsValidationContextTrust::sds)).setter(setter(Builder::sds))
            .constructor(TlsValidationContextSdsTrust::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACM_FIELD, FILE_FIELD,
            SDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final TlsValidationContextAcmTrust acm;

    private final TlsValidationContextFileTrust file;

    private final TlsValidationContextSdsTrust sds;

    private final Type type;

    private TlsValidationContextTrust(BuilderImpl builder) {
        this.acm = builder.acm;
        this.file = builder.file;
        this.sds = builder.sds;
        this.type = builder.type;
    }

    /**
     * <p>
     * A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an
     * Certificate Manager certificate.
     * </p>
     * 
     * @return A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an
     *         Certificate Manager certificate.
     */
    public final TlsValidationContextAcmTrust acm() {
        return acm;
    }

    /**
     * <p>
     * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
     * </p>
     * 
     * @return An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
     */
    public final TlsValidationContextFileTrust file() {
        return file;
    }

    /**
     * <p>
     * A reference to an object that represents a Transport Layer Security (TLS) Secret Discovery Service validation
     * context trust.
     * </p>
     * 
     * @return A reference to an object that represents a Transport Layer Security (TLS) Secret Discovery Service
     *         validation context trust.
     */
    public final TlsValidationContextSdsTrust sds() {
        return sds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acm());
        hashCode = 31 * hashCode + Objects.hashCode(file());
        hashCode = 31 * hashCode + Objects.hashCode(sds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TlsValidationContextTrust)) {
            return false;
        }
        TlsValidationContextTrust other = (TlsValidationContextTrust) obj;
        return Objects.equals(acm(), other.acm()) && Objects.equals(file(), other.file()) && Objects.equals(sds(), other.sds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TlsValidationContextTrust").add("Acm", acm()).add("File", file()).add("Sds", sds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acm":
            return Optional.ofNullable(clazz.cast(acm()));
        case "file":
            return Optional.ofNullable(clazz.cast(file()));
        case "sds":
            return Optional.ofNullable(clazz.cast(sds()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #acm()} initialized to the given value.
     *
     * <p>
     * A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an
     * Certificate Manager certificate.
     * </p>
     * 
     * @param acm
     *        A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an
     *        Certificate Manager certificate.
     */
    public static TlsValidationContextTrust fromAcm(TlsValidationContextAcmTrust acm) {
        return builder().acm(acm).build();
    }

    /**
     * Create an instance of this class with {@link #acm()} initialized to the given value.
     *
     * <p>
     * A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an
     * Certificate Manager certificate.
     * </p>
     * 
     * @param acm
     *        A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an
     *        Certificate Manager certificate.
     */
    public static TlsValidationContextTrust fromAcm(Consumer<TlsValidationContextAcmTrust.Builder> acm) {
        TlsValidationContextAcmTrust.Builder builder = TlsValidationContextAcmTrust.builder();
        acm.accept(builder);
        return fromAcm(builder.build());
    }

    /**
     * Create an instance of this class with {@link #file()} initialized to the given value.
     *
     * <p>
     * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
     * </p>
     * 
     * @param file
     *        An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
     */
    public static TlsValidationContextTrust fromFile(TlsValidationContextFileTrust file) {
        return builder().file(file).build();
    }

    /**
     * Create an instance of this class with {@link #file()} initialized to the given value.
     *
     * <p>
     * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
     * </p>
     * 
     * @param file
     *        An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
     */
    public static TlsValidationContextTrust fromFile(Consumer<TlsValidationContextFileTrust.Builder> file) {
        TlsValidationContextFileTrust.Builder builder = TlsValidationContextFileTrust.builder();
        file.accept(builder);
        return fromFile(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sds()} initialized to the given value.
     *
     * <p>
     * A reference to an object that represents a Transport Layer Security (TLS) Secret Discovery Service validation
     * context trust.
     * </p>
     * 
     * @param sds
     *        A reference to an object that represents a Transport Layer Security (TLS) Secret Discovery Service
     *        validation context trust.
     */
    public static TlsValidationContextTrust fromSds(TlsValidationContextSdsTrust sds) {
        return builder().sds(sds).build();
    }

    /**
     * Create an instance of this class with {@link #sds()} initialized to the given value.
     *
     * <p>
     * A reference to an object that represents a Transport Layer Security (TLS) Secret Discovery Service validation
     * context trust.
     * </p>
     * 
     * @param sds
     *        A reference to an object that represents a Transport Layer Security (TLS) Secret Discovery Service
     *        validation context trust.
     */
    public static TlsValidationContextTrust fromSds(Consumer<TlsValidationContextSdsTrust.Builder> sds) {
        TlsValidationContextSdsTrust.Builder builder = TlsValidationContextSdsTrust.builder();
        sds.accept(builder);
        return fromSds(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TlsValidationContextTrust, T> g) {
        return obj -> g.apply((TlsValidationContextTrust) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TlsValidationContextTrust> {
        /**
         * <p>
         * A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an
         * Certificate Manager certificate.
         * </p>
         * 
         * @param acm
         *        A reference to an object that represents a Transport Layer Security (TLS) validation context trust for
         *        an Certificate Manager certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acm(TlsValidationContextAcmTrust acm);

        /**
         * <p>
         * A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an
         * Certificate Manager certificate.
         * </p>
         * This is a convenience method that creates an instance of the {@link TlsValidationContextAcmTrust.Builder}
         * avoiding the need to create one manually via {@link TlsValidationContextAcmTrust#builder()}.
         *
         * When the {@link Consumer} completes, {@link TlsValidationContextAcmTrust.Builder#build()} is called
         * immediately and its result is passed to {@link #acm(TlsValidationContextAcmTrust)}.
         * 
         * @param acm
         *        a consumer that will call methods on {@link TlsValidationContextAcmTrust.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acm(TlsValidationContextAcmTrust)
         */
        default Builder acm(Consumer<TlsValidationContextAcmTrust.Builder> acm) {
            return acm(TlsValidationContextAcmTrust.builder().applyMutation(acm).build());
        }

        /**
         * <p>
         * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
         * </p>
         * 
         * @param file
         *        An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(TlsValidationContextFileTrust file);

        /**
         * <p>
         * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
         * </p>
         * This is a convenience method that creates an instance of the {@link TlsValidationContextFileTrust.Builder}
         * avoiding the need to create one manually via {@link TlsValidationContextFileTrust#builder()}.
         *
         * When the {@link Consumer} completes, {@link TlsValidationContextFileTrust.Builder#build()} is called
         * immediately and its result is passed to {@link #file(TlsValidationContextFileTrust)}.
         * 
         * @param file
         *        a consumer that will call methods on {@link TlsValidationContextFileTrust.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #file(TlsValidationContextFileTrust)
         */
        default Builder file(Consumer<TlsValidationContextFileTrust.Builder> file) {
            return file(TlsValidationContextFileTrust.builder().applyMutation(file).build());
        }

        /**
         * <p>
         * A reference to an object that represents a Transport Layer Security (TLS) Secret Discovery Service validation
         * context trust.
         * </p>
         * 
         * @param sds
         *        A reference to an object that represents a Transport Layer Security (TLS) Secret Discovery Service
         *        validation context trust.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sds(TlsValidationContextSdsTrust sds);

        /**
         * <p>
         * A reference to an object that represents a Transport Layer Security (TLS) Secret Discovery Service validation
         * context trust.
         * </p>
         * This is a convenience method that creates an instance of the {@link TlsValidationContextSdsTrust.Builder}
         * avoiding the need to create one manually via {@link TlsValidationContextSdsTrust#builder()}.
         *
         * When the {@link Consumer} completes, {@link TlsValidationContextSdsTrust.Builder#build()} is called
         * immediately and its result is passed to {@link #sds(TlsValidationContextSdsTrust)}.
         * 
         * @param sds
         *        a consumer that will call methods on {@link TlsValidationContextSdsTrust.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sds(TlsValidationContextSdsTrust)
         */
        default Builder sds(Consumer<TlsValidationContextSdsTrust.Builder> sds) {
            return sds(TlsValidationContextSdsTrust.builder().applyMutation(sds).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TlsValidationContextAcmTrust acm;

        private TlsValidationContextFileTrust file;

        private TlsValidationContextSdsTrust sds;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TlsValidationContextTrust model) {
            acm(model.acm);
            file(model.file);
            sds(model.sds);
        }

        public final TlsValidationContextAcmTrust.Builder getAcm() {
            return acm != null ? acm.toBuilder() : null;
        }

        public final void setAcm(TlsValidationContextAcmTrust.BuilderImpl acm) {
            Object oldValue = this.acm;
            this.acm = acm != null ? acm.build() : null;
            handleUnionValueChange(Type.ACM, oldValue, this.acm);
        }

        @Override
        @Transient
        public final Builder acm(TlsValidationContextAcmTrust acm) {
            Object oldValue = this.acm;
            this.acm = acm;
            handleUnionValueChange(Type.ACM, oldValue, this.acm);
            return this;
        }

        public final TlsValidationContextFileTrust.Builder getFile() {
            return file != null ? file.toBuilder() : null;
        }

        public final void setFile(TlsValidationContextFileTrust.BuilderImpl file) {
            Object oldValue = this.file;
            this.file = file != null ? file.build() : null;
            handleUnionValueChange(Type.FILE, oldValue, this.file);
        }

        @Override
        @Transient
        public final Builder file(TlsValidationContextFileTrust file) {
            Object oldValue = this.file;
            this.file = file;
            handleUnionValueChange(Type.FILE, oldValue, this.file);
            return this;
        }

        public final TlsValidationContextSdsTrust.Builder getSds() {
            return sds != null ? sds.toBuilder() : null;
        }

        public final void setSds(TlsValidationContextSdsTrust.BuilderImpl sds) {
            Object oldValue = this.sds;
            this.sds = sds != null ? sds.build() : null;
            handleUnionValueChange(Type.SDS, oldValue, this.sds);
        }

        @Override
        @Transient
        public final Builder sds(TlsValidationContextSdsTrust sds) {
            Object oldValue = this.sds;
            this.sds = sds;
            handleUnionValueChange(Type.SDS, oldValue, this.sds);
            return this;
        }

        @Override
        public TlsValidationContextTrust build() {
            return new TlsValidationContextTrust(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see TlsValidationContextTrust#type()
     */
    public enum Type {
        ACM,

        FILE,

        SDS,

        UNKNOWN_TO_SDK_VERSION
    }
}
