/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a virtual gateway returned by a describe operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayData implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayData.Builder, VirtualGatewayData> {
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("meshName").getter(getter(VirtualGatewayData::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()).build();

    private static final SdkField<ResourceMetadata> METADATA_FIELD = SdkField
            .<ResourceMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(VirtualGatewayData::metadata)).setter(setter(Builder::metadata))
            .constructor(ResourceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<VirtualGatewaySpec> SPEC_FIELD = SdkField
            .<VirtualGatewaySpec> builder(MarshallingType.SDK_POJO).memberName("spec").getter(getter(VirtualGatewayData::spec))
            .setter(setter(Builder::spec)).constructor(VirtualGatewaySpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<VirtualGatewayStatus> STATUS_FIELD = SdkField
            .<VirtualGatewayStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(VirtualGatewayData::status)).setter(setter(Builder::status))
            .constructor(VirtualGatewayStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> VIRTUAL_GATEWAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualGatewayName").getter(getter(VirtualGatewayData::virtualGatewayName))
            .setter(setter(Builder::virtualGatewayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESH_NAME_FIELD,
            METADATA_FIELD, SPEC_FIELD, STATUS_FIELD, VIRTUAL_GATEWAY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String meshName;

    private final ResourceMetadata metadata;

    private final VirtualGatewaySpec spec;

    private final VirtualGatewayStatus status;

    private final String virtualGatewayName;

    private VirtualGatewayData(BuilderImpl builder) {
        this.meshName = builder.meshName;
        this.metadata = builder.metadata;
        this.spec = builder.spec;
        this.status = builder.status;
        this.virtualGatewayName = builder.virtualGatewayName;
    }

    /**
     * <p>
     * The name of the service mesh that the virtual gateway resides in.
     * </p>
     * 
     * @return The name of the service mesh that the virtual gateway resides in.
     */
    public final String meshName() {
        return meshName;
    }

    /**
     * Returns the value of the Metadata property for this object.
     * 
     * @return The value of the Metadata property for this object.
     */
    public final ResourceMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * The specifications of the virtual gateway.
     * </p>
     * 
     * @return The specifications of the virtual gateway.
     */
    public final VirtualGatewaySpec spec() {
        return spec;
    }

    /**
     * <p>
     * The current status of the virtual gateway.
     * </p>
     * 
     * @return The current status of the virtual gateway.
     */
    public final VirtualGatewayStatus status() {
        return status;
    }

    /**
     * <p>
     * The name of the virtual gateway.
     * </p>
     * 
     * @return The name of the virtual gateway.
     */
    public final String virtualGatewayName() {
        return virtualGatewayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(virtualGatewayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayData)) {
            return false;
        }
        VirtualGatewayData other = (VirtualGatewayData) obj;
        return Objects.equals(meshName(), other.meshName()) && Objects.equals(metadata(), other.metadata())
                && Objects.equals(spec(), other.spec()) && Objects.equals(status(), other.status())
                && Objects.equals(virtualGatewayName(), other.virtualGatewayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualGatewayData").add("MeshName", meshName()).add("Metadata", metadata()).add("Spec", spec())
                .add("Status", status()).add("VirtualGatewayName", virtualGatewayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "virtualGatewayName":
            return Optional.ofNullable(clazz.cast(virtualGatewayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayData, T> g) {
        return obj -> g.apply((VirtualGatewayData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayData> {
        /**
         * <p>
         * The name of the service mesh that the virtual gateway resides in.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh that the virtual gateway resides in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * @param metadata
         *        The new value for the Metadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(ResourceMetadata metadata);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceMetadata.Builder} avoiding the
         * need to create one manually via {@link ResourceMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #metadata(ResourceMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link ResourceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(ResourceMetadata)
         */
        default Builder metadata(Consumer<ResourceMetadata.Builder> metadata) {
            return metadata(ResourceMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * The specifications of the virtual gateway.
         * </p>
         * 
         * @param spec
         *        The specifications of the virtual gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(VirtualGatewaySpec spec);

        /**
         * <p>
         * The specifications of the virtual gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link VirtualGatewaySpec.Builder} avoiding the
         * need to create one manually via {@link VirtualGatewaySpec#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewaySpec.Builder#build()} is called immediately and its
         * result is passed to {@link #spec(VirtualGatewaySpec)}.
         * 
         * @param spec
         *        a consumer that will call methods on {@link VirtualGatewaySpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spec(VirtualGatewaySpec)
         */
        default Builder spec(Consumer<VirtualGatewaySpec.Builder> spec) {
            return spec(VirtualGatewaySpec.builder().applyMutation(spec).build());
        }

        /**
         * <p>
         * The current status of the virtual gateway.
         * </p>
         * 
         * @param status
         *        The current status of the virtual gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(VirtualGatewayStatus status);

        /**
         * <p>
         * The current status of the virtual gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link VirtualGatewayStatus.Builder} avoiding
         * the need to create one manually via {@link VirtualGatewayStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(VirtualGatewayStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link VirtualGatewayStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(VirtualGatewayStatus)
         */
        default Builder status(Consumer<VirtualGatewayStatus.Builder> status) {
            return status(VirtualGatewayStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The name of the virtual gateway.
         * </p>
         * 
         * @param virtualGatewayName
         *        The name of the virtual gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGatewayName(String virtualGatewayName);
    }

    static final class BuilderImpl implements Builder {
        private String meshName;

        private ResourceMetadata metadata;

        private VirtualGatewaySpec spec;

        private VirtualGatewayStatus status;

        private String virtualGatewayName;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayData model) {
            meshName(model.meshName);
            metadata(model.metadata);
            spec(model.spec);
            status(model.status);
            virtualGatewayName(model.virtualGatewayName);
        }

        public final String getMeshName() {
            return meshName;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        @Override
        @Transient
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final ResourceMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(ResourceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        @Transient
        public final Builder metadata(ResourceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final VirtualGatewaySpec.Builder getSpec() {
            return spec != null ? spec.toBuilder() : null;
        }

        public final void setSpec(VirtualGatewaySpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        @Override
        @Transient
        public final Builder spec(VirtualGatewaySpec spec) {
            this.spec = spec;
            return this;
        }

        public final VirtualGatewayStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(VirtualGatewayStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(VirtualGatewayStatus status) {
            this.status = status;
            return this;
        }

        public final String getVirtualGatewayName() {
            return virtualGatewayName;
        }

        public final void setVirtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
        }

        @Override
        @Transient
        public final Builder virtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
            return this;
        }

        @Override
        public VirtualGatewayData build() {
            return new VirtualGatewayData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
