/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a listener for a virtual gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayListener implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayListener.Builder, VirtualGatewayListener> {
    private static final SdkField<VirtualGatewayConnectionPool> CONNECTION_POOL_FIELD = SdkField
            .<VirtualGatewayConnectionPool> builder(MarshallingType.SDK_POJO).memberName("connectionPool")
            .getter(getter(VirtualGatewayListener::connectionPool)).setter(setter(Builder::connectionPool))
            .constructor(VirtualGatewayConnectionPool::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionPool").build()).build();

    private static final SdkField<VirtualGatewayHealthCheckPolicy> HEALTH_CHECK_FIELD = SdkField
            .<VirtualGatewayHealthCheckPolicy> builder(MarshallingType.SDK_POJO).memberName("healthCheck")
            .getter(getter(VirtualGatewayListener::healthCheck)).setter(setter(Builder::healthCheck))
            .constructor(VirtualGatewayHealthCheckPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheck").build()).build();

    private static final SdkField<VirtualGatewayPortMapping> PORT_MAPPING_FIELD = SdkField
            .<VirtualGatewayPortMapping> builder(MarshallingType.SDK_POJO).memberName("portMapping")
            .getter(getter(VirtualGatewayListener::portMapping)).setter(setter(Builder::portMapping))
            .constructor(VirtualGatewayPortMapping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portMapping").build()).build();

    private static final SdkField<VirtualGatewayListenerTls> TLS_FIELD = SdkField
            .<VirtualGatewayListenerTls> builder(MarshallingType.SDK_POJO).memberName("tls")
            .getter(getter(VirtualGatewayListener::tls)).setter(setter(Builder::tls))
            .constructor(VirtualGatewayListenerTls::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tls").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_POOL_FIELD,
            HEALTH_CHECK_FIELD, PORT_MAPPING_FIELD, TLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final VirtualGatewayConnectionPool connectionPool;

    private final VirtualGatewayHealthCheckPolicy healthCheck;

    private final VirtualGatewayPortMapping portMapping;

    private final VirtualGatewayListenerTls tls;

    private VirtualGatewayListener(BuilderImpl builder) {
        this.connectionPool = builder.connectionPool;
        this.healthCheck = builder.healthCheck;
        this.portMapping = builder.portMapping;
        this.tls = builder.tls;
    }

    /**
     * <p>
     * The connection pool information for the virtual gateway listener.
     * </p>
     * 
     * @return The connection pool information for the virtual gateway listener.
     */
    public final VirtualGatewayConnectionPool connectionPool() {
        return connectionPool;
    }

    /**
     * <p>
     * The health check information for the listener.
     * </p>
     * 
     * @return The health check information for the listener.
     */
    public final VirtualGatewayHealthCheckPolicy healthCheck() {
        return healthCheck;
    }

    /**
     * <p>
     * The port mapping information for the listener.
     * </p>
     * 
     * @return The port mapping information for the listener.
     */
    public final VirtualGatewayPortMapping portMapping() {
        return portMapping;
    }

    /**
     * <p>
     * A reference to an object that represents the Transport Layer Security (TLS) properties for the listener.
     * </p>
     * 
     * @return A reference to an object that represents the Transport Layer Security (TLS) properties for the listener.
     */
    public final VirtualGatewayListenerTls tls() {
        return tls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionPool());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(portMapping());
        hashCode = 31 * hashCode + Objects.hashCode(tls());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayListener)) {
            return false;
        }
        VirtualGatewayListener other = (VirtualGatewayListener) obj;
        return Objects.equals(connectionPool(), other.connectionPool()) && Objects.equals(healthCheck(), other.healthCheck())
                && Objects.equals(portMapping(), other.portMapping()) && Objects.equals(tls(), other.tls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualGatewayListener").add("ConnectionPool", connectionPool())
                .add("HealthCheck", healthCheck()).add("PortMapping", portMapping()).add("Tls", tls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectionPool":
            return Optional.ofNullable(clazz.cast(connectionPool()));
        case "healthCheck":
            return Optional.ofNullable(clazz.cast(healthCheck()));
        case "portMapping":
            return Optional.ofNullable(clazz.cast(portMapping()));
        case "tls":
            return Optional.ofNullable(clazz.cast(tls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayListener, T> g) {
        return obj -> g.apply((VirtualGatewayListener) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayListener> {
        /**
         * <p>
         * The connection pool information for the virtual gateway listener.
         * </p>
         * 
         * @param connectionPool
         *        The connection pool information for the virtual gateway listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionPool(VirtualGatewayConnectionPool connectionPool);

        /**
         * <p>
         * The connection pool information for the virtual gateway listener.
         * </p>
         * This is a convenience method that creates an instance of the {@link VirtualGatewayConnectionPool.Builder}
         * avoiding the need to create one manually via {@link VirtualGatewayConnectionPool#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayConnectionPool.Builder#build()} is called
         * immediately and its result is passed to {@link #connectionPool(VirtualGatewayConnectionPool)}.
         * 
         * @param connectionPool
         *        a consumer that will call methods on {@link VirtualGatewayConnectionPool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionPool(VirtualGatewayConnectionPool)
         */
        default Builder connectionPool(Consumer<VirtualGatewayConnectionPool.Builder> connectionPool) {
            return connectionPool(VirtualGatewayConnectionPool.builder().applyMutation(connectionPool).build());
        }

        /**
         * <p>
         * The health check information for the listener.
         * </p>
         * 
         * @param healthCheck
         *        The health check information for the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheck(VirtualGatewayHealthCheckPolicy healthCheck);

        /**
         * <p>
         * The health check information for the listener.
         * </p>
         * This is a convenience method that creates an instance of the {@link VirtualGatewayHealthCheckPolicy.Builder}
         * avoiding the need to create one manually via {@link VirtualGatewayHealthCheckPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayHealthCheckPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #healthCheck(VirtualGatewayHealthCheckPolicy)}.
         * 
         * @param healthCheck
         *        a consumer that will call methods on {@link VirtualGatewayHealthCheckPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheck(VirtualGatewayHealthCheckPolicy)
         */
        default Builder healthCheck(Consumer<VirtualGatewayHealthCheckPolicy.Builder> healthCheck) {
            return healthCheck(VirtualGatewayHealthCheckPolicy.builder().applyMutation(healthCheck).build());
        }

        /**
         * <p>
         * The port mapping information for the listener.
         * </p>
         * 
         * @param portMapping
         *        The port mapping information for the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portMapping(VirtualGatewayPortMapping portMapping);

        /**
         * <p>
         * The port mapping information for the listener.
         * </p>
         * This is a convenience method that creates an instance of the {@link VirtualGatewayPortMapping.Builder}
         * avoiding the need to create one manually via {@link VirtualGatewayPortMapping#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayPortMapping.Builder#build()} is called immediately
         * and its result is passed to {@link #portMapping(VirtualGatewayPortMapping)}.
         * 
         * @param portMapping
         *        a consumer that will call methods on {@link VirtualGatewayPortMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portMapping(VirtualGatewayPortMapping)
         */
        default Builder portMapping(Consumer<VirtualGatewayPortMapping.Builder> portMapping) {
            return portMapping(VirtualGatewayPortMapping.builder().applyMutation(portMapping).build());
        }

        /**
         * <p>
         * A reference to an object that represents the Transport Layer Security (TLS) properties for the listener.
         * </p>
         * 
         * @param tls
         *        A reference to an object that represents the Transport Layer Security (TLS) properties for the
         *        listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tls(VirtualGatewayListenerTls tls);

        /**
         * <p>
         * A reference to an object that represents the Transport Layer Security (TLS) properties for the listener.
         * </p>
         * This is a convenience method that creates an instance of the {@link VirtualGatewayListenerTls.Builder}
         * avoiding the need to create one manually via {@link VirtualGatewayListenerTls#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayListenerTls.Builder#build()} is called immediately
         * and its result is passed to {@link #tls(VirtualGatewayListenerTls)}.
         * 
         * @param tls
         *        a consumer that will call methods on {@link VirtualGatewayListenerTls.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tls(VirtualGatewayListenerTls)
         */
        default Builder tls(Consumer<VirtualGatewayListenerTls.Builder> tls) {
            return tls(VirtualGatewayListenerTls.builder().applyMutation(tls).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VirtualGatewayConnectionPool connectionPool;

        private VirtualGatewayHealthCheckPolicy healthCheck;

        private VirtualGatewayPortMapping portMapping;

        private VirtualGatewayListenerTls tls;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayListener model) {
            connectionPool(model.connectionPool);
            healthCheck(model.healthCheck);
            portMapping(model.portMapping);
            tls(model.tls);
        }

        public final VirtualGatewayConnectionPool.Builder getConnectionPool() {
            return connectionPool != null ? connectionPool.toBuilder() : null;
        }

        public final void setConnectionPool(VirtualGatewayConnectionPool.BuilderImpl connectionPool) {
            this.connectionPool = connectionPool != null ? connectionPool.build() : null;
        }

        @Override
        @Transient
        public final Builder connectionPool(VirtualGatewayConnectionPool connectionPool) {
            this.connectionPool = connectionPool;
            return this;
        }

        public final VirtualGatewayHealthCheckPolicy.Builder getHealthCheck() {
            return healthCheck != null ? healthCheck.toBuilder() : null;
        }

        public final void setHealthCheck(VirtualGatewayHealthCheckPolicy.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        @Override
        @Transient
        public final Builder healthCheck(VirtualGatewayHealthCheckPolicy healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final VirtualGatewayPortMapping.Builder getPortMapping() {
            return portMapping != null ? portMapping.toBuilder() : null;
        }

        public final void setPortMapping(VirtualGatewayPortMapping.BuilderImpl portMapping) {
            this.portMapping = portMapping != null ? portMapping.build() : null;
        }

        @Override
        @Transient
        public final Builder portMapping(VirtualGatewayPortMapping portMapping) {
            this.portMapping = portMapping;
            return this;
        }

        public final VirtualGatewayListenerTls.Builder getTls() {
            return tls != null ? tls.toBuilder() : null;
        }

        public final void setTls(VirtualGatewayListenerTls.BuilderImpl tls) {
            this.tls = tls != null ? tls.build() : null;
        }

        @Override
        @Transient
        public final Builder tls(VirtualGatewayListenerTls tls) {
            this.tls = tls;
            return this;
        }

        @Override
        public VirtualGatewayListener build() {
            return new VirtualGatewayListener(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
