/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the type of virtual node connection pool.
 * </p>
 * <p>
 * Only one protocol is used at a time and should be the same protocol as the one chosen under port mapping.
 * </p>
 * <p>
 * If not present the default value for <code>maxPendingRequests</code> is <code>2147483647</code>.
 * </p>
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualNodeConnectionPool implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualNodeConnectionPool.Builder, VirtualNodeConnectionPool> {
    private static final SdkField<VirtualNodeGrpcConnectionPool> GRPC_FIELD = SdkField
            .<VirtualNodeGrpcConnectionPool> builder(MarshallingType.SDK_POJO).memberName("grpc")
            .getter(getter(VirtualNodeConnectionPool::grpc)).setter(setter(Builder::grpc))
            .constructor(VirtualNodeGrpcConnectionPool::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grpc").build()).build();

    private static final SdkField<VirtualNodeHttpConnectionPool> HTTP_FIELD = SdkField
            .<VirtualNodeHttpConnectionPool> builder(MarshallingType.SDK_POJO).memberName("http")
            .getter(getter(VirtualNodeConnectionPool::http)).setter(setter(Builder::http))
            .constructor(VirtualNodeHttpConnectionPool::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("http").build()).build();

    private static final SdkField<VirtualNodeHttp2ConnectionPool> HTTP2_FIELD = SdkField
            .<VirtualNodeHttp2ConnectionPool> builder(MarshallingType.SDK_POJO).memberName("http2")
            .getter(getter(VirtualNodeConnectionPool::http2)).setter(setter(Builder::http2))
            .constructor(VirtualNodeHttp2ConnectionPool::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("http2").build()).build();

    private static final SdkField<VirtualNodeTcpConnectionPool> TCP_FIELD = SdkField
            .<VirtualNodeTcpConnectionPool> builder(MarshallingType.SDK_POJO).memberName("tcp")
            .getter(getter(VirtualNodeConnectionPool::tcp)).setter(setter(Builder::tcp))
            .constructor(VirtualNodeTcpConnectionPool::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tcp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRPC_FIELD, HTTP_FIELD,
            HTTP2_FIELD, TCP_FIELD));

    private static final long serialVersionUID = 1L;

    private final VirtualNodeGrpcConnectionPool grpc;

    private final VirtualNodeHttpConnectionPool http;

    private final VirtualNodeHttp2ConnectionPool http2;

    private final VirtualNodeTcpConnectionPool tcp;

    private final Type type;

    private VirtualNodeConnectionPool(BuilderImpl builder) {
        this.grpc = builder.grpc;
        this.http = builder.http;
        this.http2 = builder.http2;
        this.tcp = builder.tcp;
        this.type = builder.type;
    }

    /**
     * <p>
     * An object that represents a type of connection pool.
     * </p>
     * 
     * @return An object that represents a type of connection pool.
     */
    public final VirtualNodeGrpcConnectionPool grpc() {
        return grpc;
    }

    /**
     * <p>
     * An object that represents a type of connection pool.
     * </p>
     * 
     * @return An object that represents a type of connection pool.
     */
    public final VirtualNodeHttpConnectionPool http() {
        return http;
    }

    /**
     * <p>
     * An object that represents a type of connection pool.
     * </p>
     * 
     * @return An object that represents a type of connection pool.
     */
    public final VirtualNodeHttp2ConnectionPool http2() {
        return http2;
    }

    /**
     * <p>
     * An object that represents a type of connection pool.
     * </p>
     * 
     * @return An object that represents a type of connection pool.
     */
    public final VirtualNodeTcpConnectionPool tcp() {
        return tcp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(grpc());
        hashCode = 31 * hashCode + Objects.hashCode(http());
        hashCode = 31 * hashCode + Objects.hashCode(http2());
        hashCode = 31 * hashCode + Objects.hashCode(tcp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualNodeConnectionPool)) {
            return false;
        }
        VirtualNodeConnectionPool other = (VirtualNodeConnectionPool) obj;
        return Objects.equals(grpc(), other.grpc()) && Objects.equals(http(), other.http())
                && Objects.equals(http2(), other.http2()) && Objects.equals(tcp(), other.tcp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualNodeConnectionPool").add("Grpc", grpc()).add("Http", http()).add("Http2", http2())
                .add("Tcp", tcp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "grpc":
            return Optional.ofNullable(clazz.cast(grpc()));
        case "http":
            return Optional.ofNullable(clazz.cast(http()));
        case "http2":
            return Optional.ofNullable(clazz.cast(http2()));
        case "tcp":
            return Optional.ofNullable(clazz.cast(tcp()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #grpc()} initialized to the given value.
     *
     * <p>
     * An object that represents a type of connection pool.
     * </p>
     * 
     * @param grpc
     *        An object that represents a type of connection pool.
     */
    public static VirtualNodeConnectionPool fromGrpc(VirtualNodeGrpcConnectionPool grpc) {
        return builder().grpc(grpc).build();
    }

    /**
     * Create an instance of this class with {@link #grpc()} initialized to the given value.
     *
     * <p>
     * An object that represents a type of connection pool.
     * </p>
     * 
     * @param grpc
     *        An object that represents a type of connection pool.
     */
    public static VirtualNodeConnectionPool fromGrpc(Consumer<VirtualNodeGrpcConnectionPool.Builder> grpc) {
        VirtualNodeGrpcConnectionPool.Builder builder = VirtualNodeGrpcConnectionPool.builder();
        grpc.accept(builder);
        return fromGrpc(builder.build());
    }

    /**
     * Create an instance of this class with {@link #http()} initialized to the given value.
     *
     * <p>
     * An object that represents a type of connection pool.
     * </p>
     * 
     * @param http
     *        An object that represents a type of connection pool.
     */
    public static VirtualNodeConnectionPool fromHttp(VirtualNodeHttpConnectionPool http) {
        return builder().http(http).build();
    }

    /**
     * Create an instance of this class with {@link #http()} initialized to the given value.
     *
     * <p>
     * An object that represents a type of connection pool.
     * </p>
     * 
     * @param http
     *        An object that represents a type of connection pool.
     */
    public static VirtualNodeConnectionPool fromHttp(Consumer<VirtualNodeHttpConnectionPool.Builder> http) {
        VirtualNodeHttpConnectionPool.Builder builder = VirtualNodeHttpConnectionPool.builder();
        http.accept(builder);
        return fromHttp(builder.build());
    }

    /**
     * Create an instance of this class with {@link #http2()} initialized to the given value.
     *
     * <p>
     * An object that represents a type of connection pool.
     * </p>
     * 
     * @param http2
     *        An object that represents a type of connection pool.
     */
    public static VirtualNodeConnectionPool fromHttp2(VirtualNodeHttp2ConnectionPool http2) {
        return builder().http2(http2).build();
    }

    /**
     * Create an instance of this class with {@link #http2()} initialized to the given value.
     *
     * <p>
     * An object that represents a type of connection pool.
     * </p>
     * 
     * @param http2
     *        An object that represents a type of connection pool.
     */
    public static VirtualNodeConnectionPool fromHttp2(Consumer<VirtualNodeHttp2ConnectionPool.Builder> http2) {
        VirtualNodeHttp2ConnectionPool.Builder builder = VirtualNodeHttp2ConnectionPool.builder();
        http2.accept(builder);
        return fromHttp2(builder.build());
    }

    /**
     * Create an instance of this class with {@link #tcp()} initialized to the given value.
     *
     * <p>
     * An object that represents a type of connection pool.
     * </p>
     * 
     * @param tcp
     *        An object that represents a type of connection pool.
     */
    public static VirtualNodeConnectionPool fromTcp(VirtualNodeTcpConnectionPool tcp) {
        return builder().tcp(tcp).build();
    }

    /**
     * Create an instance of this class with {@link #tcp()} initialized to the given value.
     *
     * <p>
     * An object that represents a type of connection pool.
     * </p>
     * 
     * @param tcp
     *        An object that represents a type of connection pool.
     */
    public static VirtualNodeConnectionPool fromTcp(Consumer<VirtualNodeTcpConnectionPool.Builder> tcp) {
        VirtualNodeTcpConnectionPool.Builder builder = VirtualNodeTcpConnectionPool.builder();
        tcp.accept(builder);
        return fromTcp(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualNodeConnectionPool, T> g) {
        return obj -> g.apply((VirtualNodeConnectionPool) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualNodeConnectionPool> {
        /**
         * <p>
         * An object that represents a type of connection pool.
         * </p>
         * 
         * @param grpc
         *        An object that represents a type of connection pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grpc(VirtualNodeGrpcConnectionPool grpc);

        /**
         * <p>
         * An object that represents a type of connection pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link VirtualNodeGrpcConnectionPool.Builder}
         * avoiding the need to create one manually via {@link VirtualNodeGrpcConnectionPool#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualNodeGrpcConnectionPool.Builder#build()} is called
         * immediately and its result is passed to {@link #grpc(VirtualNodeGrpcConnectionPool)}.
         * 
         * @param grpc
         *        a consumer that will call methods on {@link VirtualNodeGrpcConnectionPool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grpc(VirtualNodeGrpcConnectionPool)
         */
        default Builder grpc(Consumer<VirtualNodeGrpcConnectionPool.Builder> grpc) {
            return grpc(VirtualNodeGrpcConnectionPool.builder().applyMutation(grpc).build());
        }

        /**
         * <p>
         * An object that represents a type of connection pool.
         * </p>
         * 
         * @param http
         *        An object that represents a type of connection pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder http(VirtualNodeHttpConnectionPool http);

        /**
         * <p>
         * An object that represents a type of connection pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link VirtualNodeHttpConnectionPool.Builder}
         * avoiding the need to create one manually via {@link VirtualNodeHttpConnectionPool#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualNodeHttpConnectionPool.Builder#build()} is called
         * immediately and its result is passed to {@link #http(VirtualNodeHttpConnectionPool)}.
         * 
         * @param http
         *        a consumer that will call methods on {@link VirtualNodeHttpConnectionPool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #http(VirtualNodeHttpConnectionPool)
         */
        default Builder http(Consumer<VirtualNodeHttpConnectionPool.Builder> http) {
            return http(VirtualNodeHttpConnectionPool.builder().applyMutation(http).build());
        }

        /**
         * <p>
         * An object that represents a type of connection pool.
         * </p>
         * 
         * @param http2
         *        An object that represents a type of connection pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder http2(VirtualNodeHttp2ConnectionPool http2);

        /**
         * <p>
         * An object that represents a type of connection pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link VirtualNodeHttp2ConnectionPool.Builder}
         * avoiding the need to create one manually via {@link VirtualNodeHttp2ConnectionPool#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualNodeHttp2ConnectionPool.Builder#build()} is called
         * immediately and its result is passed to {@link #http2(VirtualNodeHttp2ConnectionPool)}.
         * 
         * @param http2
         *        a consumer that will call methods on {@link VirtualNodeHttp2ConnectionPool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #http2(VirtualNodeHttp2ConnectionPool)
         */
        default Builder http2(Consumer<VirtualNodeHttp2ConnectionPool.Builder> http2) {
            return http2(VirtualNodeHttp2ConnectionPool.builder().applyMutation(http2).build());
        }

        /**
         * <p>
         * An object that represents a type of connection pool.
         * </p>
         * 
         * @param tcp
         *        An object that represents a type of connection pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tcp(VirtualNodeTcpConnectionPool tcp);

        /**
         * <p>
         * An object that represents a type of connection pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link VirtualNodeTcpConnectionPool.Builder}
         * avoiding the need to create one manually via {@link VirtualNodeTcpConnectionPool#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualNodeTcpConnectionPool.Builder#build()} is called
         * immediately and its result is passed to {@link #tcp(VirtualNodeTcpConnectionPool)}.
         * 
         * @param tcp
         *        a consumer that will call methods on {@link VirtualNodeTcpConnectionPool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tcp(VirtualNodeTcpConnectionPool)
         */
        default Builder tcp(Consumer<VirtualNodeTcpConnectionPool.Builder> tcp) {
            return tcp(VirtualNodeTcpConnectionPool.builder().applyMutation(tcp).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VirtualNodeGrpcConnectionPool grpc;

        private VirtualNodeHttpConnectionPool http;

        private VirtualNodeHttp2ConnectionPool http2;

        private VirtualNodeTcpConnectionPool tcp;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualNodeConnectionPool model) {
            grpc(model.grpc);
            http(model.http);
            http2(model.http2);
            tcp(model.tcp);
        }

        public final VirtualNodeGrpcConnectionPool.Builder getGrpc() {
            return grpc != null ? grpc.toBuilder() : null;
        }

        public final void setGrpc(VirtualNodeGrpcConnectionPool.BuilderImpl grpc) {
            Object oldValue = this.grpc;
            this.grpc = grpc != null ? grpc.build() : null;
            handleUnionValueChange(Type.GRPC, oldValue, this.grpc);
        }

        @Override
        @Transient
        public final Builder grpc(VirtualNodeGrpcConnectionPool grpc) {
            Object oldValue = this.grpc;
            this.grpc = grpc;
            handleUnionValueChange(Type.GRPC, oldValue, this.grpc);
            return this;
        }

        public final VirtualNodeHttpConnectionPool.Builder getHttp() {
            return http != null ? http.toBuilder() : null;
        }

        public final void setHttp(VirtualNodeHttpConnectionPool.BuilderImpl http) {
            Object oldValue = this.http;
            this.http = http != null ? http.build() : null;
            handleUnionValueChange(Type.HTTP, oldValue, this.http);
        }

        @Override
        @Transient
        public final Builder http(VirtualNodeHttpConnectionPool http) {
            Object oldValue = this.http;
            this.http = http;
            handleUnionValueChange(Type.HTTP, oldValue, this.http);
            return this;
        }

        public final VirtualNodeHttp2ConnectionPool.Builder getHttp2() {
            return http2 != null ? http2.toBuilder() : null;
        }

        public final void setHttp2(VirtualNodeHttp2ConnectionPool.BuilderImpl http2) {
            Object oldValue = this.http2;
            this.http2 = http2 != null ? http2.build() : null;
            handleUnionValueChange(Type.HTTP2, oldValue, this.http2);
        }

        @Override
        @Transient
        public final Builder http2(VirtualNodeHttp2ConnectionPool http2) {
            Object oldValue = this.http2;
            this.http2 = http2;
            handleUnionValueChange(Type.HTTP2, oldValue, this.http2);
            return this;
        }

        public final VirtualNodeTcpConnectionPool.Builder getTcp() {
            return tcp != null ? tcp.toBuilder() : null;
        }

        public final void setTcp(VirtualNodeTcpConnectionPool.BuilderImpl tcp) {
            Object oldValue = this.tcp;
            this.tcp = tcp != null ? tcp.build() : null;
            handleUnionValueChange(Type.TCP, oldValue, this.tcp);
        }

        @Override
        @Transient
        public final Builder tcp(VirtualNodeTcpConnectionPool tcp) {
            Object oldValue = this.tcp;
            this.tcp = tcp;
            handleUnionValueChange(Type.TCP, oldValue, this.tcp);
            return this;
        }

        @Override
        public VirtualNodeConnectionPool build() {
            return new VirtualNodeConnectionPool(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see VirtualNodeConnectionPool#type()
     */
    public enum Type {
        GRPC,

        HTTP,

        HTTP2,

        TCP,

        UNKNOWN_TO_SDK_VERSION
    }
}
