/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a listener's Transport Layer Security (TLS) certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayListenerTlsCertificate implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayListenerTlsCertificate.Builder, VirtualGatewayListenerTlsCertificate> {
    private static final SdkField<VirtualGatewayListenerTlsAcmCertificate> ACM_FIELD = SdkField
            .<VirtualGatewayListenerTlsAcmCertificate> builder(MarshallingType.SDK_POJO).memberName("acm")
            .getter(getter(VirtualGatewayListenerTlsCertificate::acm)).setter(setter(Builder::acm))
            .constructor(VirtualGatewayListenerTlsAcmCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acm").build()).build();

    private static final SdkField<VirtualGatewayListenerTlsFileCertificate> FILE_FIELD = SdkField
            .<VirtualGatewayListenerTlsFileCertificate> builder(MarshallingType.SDK_POJO).memberName("file")
            .getter(getter(VirtualGatewayListenerTlsCertificate::file)).setter(setter(Builder::file))
            .constructor(VirtualGatewayListenerTlsFileCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()).build();

    private static final SdkField<VirtualGatewayListenerTlsSdsCertificate> SDS_FIELD = SdkField
            .<VirtualGatewayListenerTlsSdsCertificate> builder(MarshallingType.SDK_POJO).memberName("sds")
            .getter(getter(VirtualGatewayListenerTlsCertificate::sds)).setter(setter(Builder::sds))
            .constructor(VirtualGatewayListenerTlsSdsCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACM_FIELD, FILE_FIELD,
            SDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final VirtualGatewayListenerTlsAcmCertificate acm;

    private final VirtualGatewayListenerTlsFileCertificate file;

    private final VirtualGatewayListenerTlsSdsCertificate sds;

    private final Type type;

    private VirtualGatewayListenerTlsCertificate(BuilderImpl builder) {
        this.acm = builder.acm;
        this.file = builder.file;
        this.sds = builder.sds;
        this.type = builder.type;
    }

    /**
     * <p>
     * A reference to an object that represents an Certificate Manager certificate.
     * </p>
     * 
     * @return A reference to an object that represents an Certificate Manager certificate.
     */
    public final VirtualGatewayListenerTlsAcmCertificate acm() {
        return acm;
    }

    /**
     * <p>
     * A reference to an object that represents a local file certificate.
     * </p>
     * 
     * @return A reference to an object that represents a local file certificate.
     */
    public final VirtualGatewayListenerTlsFileCertificate file() {
        return file;
    }

    /**
     * <p>
     * A reference to an object that represents a virtual gateway's listener's Secret Discovery Service certificate.
     * </p>
     * 
     * @return A reference to an object that represents a virtual gateway's listener's Secret Discovery Service
     *         certificate.
     */
    public final VirtualGatewayListenerTlsSdsCertificate sds() {
        return sds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acm());
        hashCode = 31 * hashCode + Objects.hashCode(file());
        hashCode = 31 * hashCode + Objects.hashCode(sds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayListenerTlsCertificate)) {
            return false;
        }
        VirtualGatewayListenerTlsCertificate other = (VirtualGatewayListenerTlsCertificate) obj;
        return Objects.equals(acm(), other.acm()) && Objects.equals(file(), other.file()) && Objects.equals(sds(), other.sds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualGatewayListenerTlsCertificate").add("Acm", acm()).add("File", file()).add("Sds", sds())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acm":
            return Optional.ofNullable(clazz.cast(acm()));
        case "file":
            return Optional.ofNullable(clazz.cast(file()));
        case "sds":
            return Optional.ofNullable(clazz.cast(sds()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #acm()} initialized to the given value.
     *
     * <p>
     * A reference to an object that represents an Certificate Manager certificate.
     * </p>
     * 
     * @param acm
     *        A reference to an object that represents an Certificate Manager certificate.
     */
    public static VirtualGatewayListenerTlsCertificate fromAcm(VirtualGatewayListenerTlsAcmCertificate acm) {
        return builder().acm(acm).build();
    }

    /**
     * Create an instance of this class with {@link #acm()} initialized to the given value.
     *
     * <p>
     * A reference to an object that represents an Certificate Manager certificate.
     * </p>
     * 
     * @param acm
     *        A reference to an object that represents an Certificate Manager certificate.
     */
    public static VirtualGatewayListenerTlsCertificate fromAcm(Consumer<VirtualGatewayListenerTlsAcmCertificate.Builder> acm) {
        VirtualGatewayListenerTlsAcmCertificate.Builder builder = VirtualGatewayListenerTlsAcmCertificate.builder();
        acm.accept(builder);
        return fromAcm(builder.build());
    }

    /**
     * Create an instance of this class with {@link #file()} initialized to the given value.
     *
     * <p>
     * A reference to an object that represents a local file certificate.
     * </p>
     * 
     * @param file
     *        A reference to an object that represents a local file certificate.
     */
    public static VirtualGatewayListenerTlsCertificate fromFile(VirtualGatewayListenerTlsFileCertificate file) {
        return builder().file(file).build();
    }

    /**
     * Create an instance of this class with {@link #file()} initialized to the given value.
     *
     * <p>
     * A reference to an object that represents a local file certificate.
     * </p>
     * 
     * @param file
     *        A reference to an object that represents a local file certificate.
     */
    public static VirtualGatewayListenerTlsCertificate fromFile(Consumer<VirtualGatewayListenerTlsFileCertificate.Builder> file) {
        VirtualGatewayListenerTlsFileCertificate.Builder builder = VirtualGatewayListenerTlsFileCertificate.builder();
        file.accept(builder);
        return fromFile(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sds()} initialized to the given value.
     *
     * <p>
     * A reference to an object that represents a virtual gateway's listener's Secret Discovery Service certificate.
     * </p>
     * 
     * @param sds
     *        A reference to an object that represents a virtual gateway's listener's Secret Discovery Service
     *        certificate.
     */
    public static VirtualGatewayListenerTlsCertificate fromSds(VirtualGatewayListenerTlsSdsCertificate sds) {
        return builder().sds(sds).build();
    }

    /**
     * Create an instance of this class with {@link #sds()} initialized to the given value.
     *
     * <p>
     * A reference to an object that represents a virtual gateway's listener's Secret Discovery Service certificate.
     * </p>
     * 
     * @param sds
     *        A reference to an object that represents a virtual gateway's listener's Secret Discovery Service
     *        certificate.
     */
    public static VirtualGatewayListenerTlsCertificate fromSds(Consumer<VirtualGatewayListenerTlsSdsCertificate.Builder> sds) {
        VirtualGatewayListenerTlsSdsCertificate.Builder builder = VirtualGatewayListenerTlsSdsCertificate.builder();
        sds.accept(builder);
        return fromSds(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayListenerTlsCertificate, T> g) {
        return obj -> g.apply((VirtualGatewayListenerTlsCertificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayListenerTlsCertificate> {
        /**
         * <p>
         * A reference to an object that represents an Certificate Manager certificate.
         * </p>
         * 
         * @param acm
         *        A reference to an object that represents an Certificate Manager certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acm(VirtualGatewayListenerTlsAcmCertificate acm);

        /**
         * <p>
         * A reference to an object that represents an Certificate Manager certificate.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VirtualGatewayListenerTlsAcmCertificate.Builder} avoiding the need to create one manually via
         * {@link VirtualGatewayListenerTlsAcmCertificate#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayListenerTlsAcmCertificate.Builder#build()} is
         * called immediately and its result is passed to {@link #acm(VirtualGatewayListenerTlsAcmCertificate)}.
         * 
         * @param acm
         *        a consumer that will call methods on {@link VirtualGatewayListenerTlsAcmCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acm(VirtualGatewayListenerTlsAcmCertificate)
         */
        default Builder acm(Consumer<VirtualGatewayListenerTlsAcmCertificate.Builder> acm) {
            return acm(VirtualGatewayListenerTlsAcmCertificate.builder().applyMutation(acm).build());
        }

        /**
         * <p>
         * A reference to an object that represents a local file certificate.
         * </p>
         * 
         * @param file
         *        A reference to an object that represents a local file certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(VirtualGatewayListenerTlsFileCertificate file);

        /**
         * <p>
         * A reference to an object that represents a local file certificate.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VirtualGatewayListenerTlsFileCertificate.Builder} avoiding the need to create one manually via
         * {@link VirtualGatewayListenerTlsFileCertificate#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayListenerTlsFileCertificate.Builder#build()} is
         * called immediately and its result is passed to {@link #file(VirtualGatewayListenerTlsFileCertificate)}.
         * 
         * @param file
         *        a consumer that will call methods on {@link VirtualGatewayListenerTlsFileCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #file(VirtualGatewayListenerTlsFileCertificate)
         */
        default Builder file(Consumer<VirtualGatewayListenerTlsFileCertificate.Builder> file) {
            return file(VirtualGatewayListenerTlsFileCertificate.builder().applyMutation(file).build());
        }

        /**
         * <p>
         * A reference to an object that represents a virtual gateway's listener's Secret Discovery Service certificate.
         * </p>
         * 
         * @param sds
         *        A reference to an object that represents a virtual gateway's listener's Secret Discovery Service
         *        certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sds(VirtualGatewayListenerTlsSdsCertificate sds);

        /**
         * <p>
         * A reference to an object that represents a virtual gateway's listener's Secret Discovery Service certificate.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VirtualGatewayListenerTlsSdsCertificate.Builder} avoiding the need to create one manually via
         * {@link VirtualGatewayListenerTlsSdsCertificate#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayListenerTlsSdsCertificate.Builder#build()} is
         * called immediately and its result is passed to {@link #sds(VirtualGatewayListenerTlsSdsCertificate)}.
         * 
         * @param sds
         *        a consumer that will call methods on {@link VirtualGatewayListenerTlsSdsCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sds(VirtualGatewayListenerTlsSdsCertificate)
         */
        default Builder sds(Consumer<VirtualGatewayListenerTlsSdsCertificate.Builder> sds) {
            return sds(VirtualGatewayListenerTlsSdsCertificate.builder().applyMutation(sds).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VirtualGatewayListenerTlsAcmCertificate acm;

        private VirtualGatewayListenerTlsFileCertificate file;

        private VirtualGatewayListenerTlsSdsCertificate sds;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayListenerTlsCertificate model) {
            acm(model.acm);
            file(model.file);
            sds(model.sds);
        }

        public final VirtualGatewayListenerTlsAcmCertificate.Builder getAcm() {
            return acm != null ? acm.toBuilder() : null;
        }

        public final void setAcm(VirtualGatewayListenerTlsAcmCertificate.BuilderImpl acm) {
            Object oldValue = this.acm;
            this.acm = acm != null ? acm.build() : null;
            handleUnionValueChange(Type.ACM, oldValue, this.acm);
        }

        @Override
        public final Builder acm(VirtualGatewayListenerTlsAcmCertificate acm) {
            Object oldValue = this.acm;
            this.acm = acm;
            handleUnionValueChange(Type.ACM, oldValue, this.acm);
            return this;
        }

        public final VirtualGatewayListenerTlsFileCertificate.Builder getFile() {
            return file != null ? file.toBuilder() : null;
        }

        public final void setFile(VirtualGatewayListenerTlsFileCertificate.BuilderImpl file) {
            Object oldValue = this.file;
            this.file = file != null ? file.build() : null;
            handleUnionValueChange(Type.FILE, oldValue, this.file);
        }

        @Override
        public final Builder file(VirtualGatewayListenerTlsFileCertificate file) {
            Object oldValue = this.file;
            this.file = file;
            handleUnionValueChange(Type.FILE, oldValue, this.file);
            return this;
        }

        public final VirtualGatewayListenerTlsSdsCertificate.Builder getSds() {
            return sds != null ? sds.toBuilder() : null;
        }

        public final void setSds(VirtualGatewayListenerTlsSdsCertificate.BuilderImpl sds) {
            Object oldValue = this.sds;
            this.sds = sds != null ? sds.build() : null;
            handleUnionValueChange(Type.SDS, oldValue, this.sds);
        }

        @Override
        public final Builder sds(VirtualGatewayListenerTlsSdsCertificate sds) {
            Object oldValue = this.sds;
            this.sds = sds;
            handleUnionValueChange(Type.SDS, oldValue, this.sds);
            return this;
        }

        @Override
        public VirtualGatewayListenerTlsCertificate build() {
            return new VirtualGatewayListenerTlsCertificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see VirtualGatewayListenerTlsCertificate#type()
     */
    public enum Type {
        ACM,

        FILE,

        SDS,

        UNKNOWN_TO_SDK_VERSION
    }
}
