/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents an HTTP or HTTP/2 route type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpRoute implements SdkPojo, Serializable, ToCopyableBuilder<HttpRoute.Builder, HttpRoute> {
    private static final SdkField<HttpRouteAction> ACTION_FIELD = SdkField.<HttpRouteAction> builder(MarshallingType.SDK_POJO)
            .memberName("action").getter(getter(HttpRoute::action)).setter(setter(Builder::action))
            .constructor(HttpRouteAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<HttpRouteMatch> MATCH_FIELD = SdkField.<HttpRouteMatch> builder(MarshallingType.SDK_POJO)
            .memberName("match").getter(getter(HttpRoute::match)).setter(setter(Builder::match))
            .constructor(HttpRouteMatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()).build();

    private static final SdkField<HttpRetryPolicy> RETRY_POLICY_FIELD = SdkField
            .<HttpRetryPolicy> builder(MarshallingType.SDK_POJO).memberName("retryPolicy").getter(getter(HttpRoute::retryPolicy))
            .setter(setter(Builder::retryPolicy)).constructor(HttpRetryPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryPolicy").build()).build();

    private static final SdkField<HttpTimeout> TIMEOUT_FIELD = SdkField.<HttpTimeout> builder(MarshallingType.SDK_POJO)
            .memberName("timeout").getter(getter(HttpRoute::timeout)).setter(setter(Builder::timeout))
            .constructor(HttpTimeout::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, MATCH_FIELD,
            RETRY_POLICY_FIELD, TIMEOUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final HttpRouteAction action;

    private final HttpRouteMatch match;

    private final HttpRetryPolicy retryPolicy;

    private final HttpTimeout timeout;

    private HttpRoute(BuilderImpl builder) {
        this.action = builder.action;
        this.match = builder.match;
        this.retryPolicy = builder.retryPolicy;
        this.timeout = builder.timeout;
    }

    /**
     * <p>
     * An object that represents the action to take if a match is determined.
     * </p>
     * 
     * @return An object that represents the action to take if a match is determined.
     */
    public final HttpRouteAction action() {
        return action;
    }

    /**
     * <p>
     * An object that represents the criteria for determining a request match.
     * </p>
     * 
     * @return An object that represents the criteria for determining a request match.
     */
    public final HttpRouteMatch match() {
        return match;
    }

    /**
     * <p>
     * An object that represents a retry policy.
     * </p>
     * 
     * @return An object that represents a retry policy.
     */
    public final HttpRetryPolicy retryPolicy() {
        return retryPolicy;
    }

    /**
     * <p>
     * An object that represents types of timeouts.
     * </p>
     * 
     * @return An object that represents types of timeouts.
     */
    public final HttpTimeout timeout() {
        return timeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(match());
        hashCode = 31 * hashCode + Objects.hashCode(retryPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpRoute)) {
            return false;
        }
        HttpRoute other = (HttpRoute) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(match(), other.match())
                && Objects.equals(retryPolicy(), other.retryPolicy()) && Objects.equals(timeout(), other.timeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpRoute").add("Action", action()).add("Match", match()).add("RetryPolicy", retryPolicy())
                .add("Timeout", timeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "match":
            return Optional.ofNullable(clazz.cast(match()));
        case "retryPolicy":
            return Optional.ofNullable(clazz.cast(retryPolicy()));
        case "timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpRoute, T> g) {
        return obj -> g.apply((HttpRoute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpRoute> {
        /**
         * <p>
         * An object that represents the action to take if a match is determined.
         * </p>
         * 
         * @param action
         *        An object that represents the action to take if a match is determined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(HttpRouteAction action);

        /**
         * <p>
         * An object that represents the action to take if a match is determined.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpRouteAction.Builder} avoiding the
         * need to create one manually via {@link HttpRouteAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpRouteAction.Builder#build()} is called immediately and its
         * result is passed to {@link #action(HttpRouteAction)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link HttpRouteAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(HttpRouteAction)
         */
        default Builder action(Consumer<HttpRouteAction.Builder> action) {
            return action(HttpRouteAction.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * An object that represents the criteria for determining a request match.
         * </p>
         * 
         * @param match
         *        An object that represents the criteria for determining a request match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder match(HttpRouteMatch match);

        /**
         * <p>
         * An object that represents the criteria for determining a request match.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpRouteMatch.Builder} avoiding the need
         * to create one manually via {@link HttpRouteMatch#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpRouteMatch.Builder#build()} is called immediately and its
         * result is passed to {@link #match(HttpRouteMatch)}.
         * 
         * @param match
         *        a consumer that will call methods on {@link HttpRouteMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #match(HttpRouteMatch)
         */
        default Builder match(Consumer<HttpRouteMatch.Builder> match) {
            return match(HttpRouteMatch.builder().applyMutation(match).build());
        }

        /**
         * <p>
         * An object that represents a retry policy.
         * </p>
         * 
         * @param retryPolicy
         *        An object that represents a retry policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryPolicy(HttpRetryPolicy retryPolicy);

        /**
         * <p>
         * An object that represents a retry policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpRetryPolicy.Builder} avoiding the
         * need to create one manually via {@link HttpRetryPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpRetryPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #retryPolicy(HttpRetryPolicy)}.
         * 
         * @param retryPolicy
         *        a consumer that will call methods on {@link HttpRetryPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryPolicy(HttpRetryPolicy)
         */
        default Builder retryPolicy(Consumer<HttpRetryPolicy.Builder> retryPolicy) {
            return retryPolicy(HttpRetryPolicy.builder().applyMutation(retryPolicy).build());
        }

        /**
         * <p>
         * An object that represents types of timeouts.
         * </p>
         * 
         * @param timeout
         *        An object that represents types of timeouts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(HttpTimeout timeout);

        /**
         * <p>
         * An object that represents types of timeouts.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpTimeout.Builder} avoiding the need to
         * create one manually via {@link HttpTimeout#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpTimeout.Builder#build()} is called immediately and its result
         * is passed to {@link #timeout(HttpTimeout)}.
         * 
         * @param timeout
         *        a consumer that will call methods on {@link HttpTimeout.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeout(HttpTimeout)
         */
        default Builder timeout(Consumer<HttpTimeout.Builder> timeout) {
            return timeout(HttpTimeout.builder().applyMutation(timeout).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HttpRouteAction action;

        private HttpRouteMatch match;

        private HttpRetryPolicy retryPolicy;

        private HttpTimeout timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpRoute model) {
            action(model.action);
            match(model.match);
            retryPolicy(model.retryPolicy);
            timeout(model.timeout);
        }

        public final HttpRouteAction.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(HttpRouteAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(HttpRouteAction action) {
            this.action = action;
            return this;
        }

        public final HttpRouteMatch.Builder getMatch() {
            return match != null ? match.toBuilder() : null;
        }

        public final void setMatch(HttpRouteMatch.BuilderImpl match) {
            this.match = match != null ? match.build() : null;
        }

        @Override
        public final Builder match(HttpRouteMatch match) {
            this.match = match;
            return this;
        }

        public final HttpRetryPolicy.Builder getRetryPolicy() {
            return retryPolicy != null ? retryPolicy.toBuilder() : null;
        }

        public final void setRetryPolicy(HttpRetryPolicy.BuilderImpl retryPolicy) {
            this.retryPolicy = retryPolicy != null ? retryPolicy.build() : null;
        }

        @Override
        public final Builder retryPolicy(HttpRetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public final HttpTimeout.Builder getTimeout() {
            return timeout != null ? timeout.toBuilder() : null;
        }

        public final void setTimeout(HttpTimeout.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        @Override
        public final Builder timeout(HttpTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        @Override
        public HttpRoute build() {
            return new HttpRoute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
