/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a port mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayPortMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayPortMapping.Builder, VirtualGatewayPortMapping> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(VirtualGatewayPortMapping::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(VirtualGatewayPortMapping::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD, PROTOCOL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer port;

    private final String protocol;

    private VirtualGatewayPortMapping(BuilderImpl builder) {
        this.port = builder.port;
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * The port used for the port mapping. Specify one protocol.
     * </p>
     * 
     * @return The port used for the port mapping. Specify one protocol.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The protocol used for the port mapping.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link VirtualGatewayPortProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol used for the port mapping.
     * @see VirtualGatewayPortProtocol
     */
    public final VirtualGatewayPortProtocol protocol() {
        return VirtualGatewayPortProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol used for the port mapping.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link VirtualGatewayPortProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol used for the port mapping.
     * @see VirtualGatewayPortProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayPortMapping)) {
            return false;
        }
        VirtualGatewayPortMapping other = (VirtualGatewayPortMapping) obj;
        return Objects.equals(port(), other.port()) && Objects.equals(protocolAsString(), other.protocolAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualGatewayPortMapping").add("Port", port()).add("Protocol", protocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayPortMapping, T> g) {
        return obj -> g.apply((VirtualGatewayPortMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayPortMapping> {
        /**
         * <p>
         * The port used for the port mapping. Specify one protocol.
         * </p>
         * 
         * @param port
         *        The port used for the port mapping. Specify one protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The protocol used for the port mapping.
         * </p>
         * 
         * @param protocol
         *        The protocol used for the port mapping.
         * @see VirtualGatewayPortProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualGatewayPortProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol used for the port mapping.
         * </p>
         * 
         * @param protocol
         *        The protocol used for the port mapping.
         * @see VirtualGatewayPortProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualGatewayPortProtocol
         */
        Builder protocol(VirtualGatewayPortProtocol protocol);
    }

    static final class BuilderImpl implements Builder {
        private Integer port;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayPortMapping model) {
            port(model.port);
            protocol(model.protocol);
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        @Transient
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        @Transient
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        @Transient
        public final Builder protocol(VirtualGatewayPortProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        @Override
        public VirtualGatewayPortMapping build() {
            return new VirtualGatewayPortMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
