/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the specification of a service mesh.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MeshSpec implements SdkPojo, Serializable, ToCopyableBuilder<MeshSpec.Builder, MeshSpec> {
    private static final SdkField<EgressFilter> EGRESS_FILTER_FIELD = SdkField.<EgressFilter> builder(MarshallingType.SDK_POJO)
            .memberName("egressFilter").getter(getter(MeshSpec::egressFilter)).setter(setter(Builder::egressFilter))
            .constructor(EgressFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressFilter").build()).build();

    private static final SdkField<MeshServiceDiscovery> SERVICE_DISCOVERY_FIELD = SdkField
            .<MeshServiceDiscovery> builder(MarshallingType.SDK_POJO).memberName("serviceDiscovery")
            .getter(getter(MeshSpec::serviceDiscovery)).setter(setter(Builder::serviceDiscovery))
            .constructor(MeshServiceDiscovery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDiscovery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EGRESS_FILTER_FIELD,
            SERVICE_DISCOVERY_FIELD));

    private static final long serialVersionUID = 1L;

    private final EgressFilter egressFilter;

    private final MeshServiceDiscovery serviceDiscovery;

    private MeshSpec(BuilderImpl builder) {
        this.egressFilter = builder.egressFilter;
        this.serviceDiscovery = builder.serviceDiscovery;
    }

    /**
     * <p>
     * The egress filter rules for the service mesh.
     * </p>
     * 
     * @return The egress filter rules for the service mesh.
     */
    public final EgressFilter egressFilter() {
        return egressFilter;
    }

    /**
     * Returns the value of the ServiceDiscovery property for this object.
     * 
     * @return The value of the ServiceDiscovery property for this object.
     */
    public final MeshServiceDiscovery serviceDiscovery() {
        return serviceDiscovery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(egressFilter());
        hashCode = 31 * hashCode + Objects.hashCode(serviceDiscovery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeshSpec)) {
            return false;
        }
        MeshSpec other = (MeshSpec) obj;
        return Objects.equals(egressFilter(), other.egressFilter())
                && Objects.equals(serviceDiscovery(), other.serviceDiscovery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MeshSpec").add("EgressFilter", egressFilter()).add("ServiceDiscovery", serviceDiscovery())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "egressFilter":
            return Optional.ofNullable(clazz.cast(egressFilter()));
        case "serviceDiscovery":
            return Optional.ofNullable(clazz.cast(serviceDiscovery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MeshSpec, T> g) {
        return obj -> g.apply((MeshSpec) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MeshSpec> {
        /**
         * <p>
         * The egress filter rules for the service mesh.
         * </p>
         * 
         * @param egressFilter
         *        The egress filter rules for the service mesh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressFilter(EgressFilter egressFilter);

        /**
         * <p>
         * The egress filter rules for the service mesh.
         * </p>
         * This is a convenience method that creates an instance of the {@link EgressFilter.Builder} avoiding the need
         * to create one manually via {@link EgressFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link EgressFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #egressFilter(EgressFilter)}.
         * 
         * @param egressFilter
         *        a consumer that will call methods on {@link EgressFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressFilter(EgressFilter)
         */
        default Builder egressFilter(Consumer<EgressFilter.Builder> egressFilter) {
            return egressFilter(EgressFilter.builder().applyMutation(egressFilter).build());
        }

        /**
         * Sets the value of the ServiceDiscovery property for this object.
         *
         * @param serviceDiscovery
         *        The new value for the ServiceDiscovery property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDiscovery(MeshServiceDiscovery serviceDiscovery);

        /**
         * Sets the value of the ServiceDiscovery property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MeshServiceDiscovery.Builder} avoiding
         * the need to create one manually via {@link MeshServiceDiscovery#builder()}.
         *
         * When the {@link Consumer} completes, {@link MeshServiceDiscovery.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceDiscovery(MeshServiceDiscovery)}.
         * 
         * @param serviceDiscovery
         *        a consumer that will call methods on {@link MeshServiceDiscovery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceDiscovery(MeshServiceDiscovery)
         */
        default Builder serviceDiscovery(Consumer<MeshServiceDiscovery.Builder> serviceDiscovery) {
            return serviceDiscovery(MeshServiceDiscovery.builder().applyMutation(serviceDiscovery).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EgressFilter egressFilter;

        private MeshServiceDiscovery serviceDiscovery;

        private BuilderImpl() {
        }

        private BuilderImpl(MeshSpec model) {
            egressFilter(model.egressFilter);
            serviceDiscovery(model.serviceDiscovery);
        }

        public final EgressFilter.Builder getEgressFilter() {
            return egressFilter != null ? egressFilter.toBuilder() : null;
        }

        public final void setEgressFilter(EgressFilter.BuilderImpl egressFilter) {
            this.egressFilter = egressFilter != null ? egressFilter.build() : null;
        }

        @Override
        public final Builder egressFilter(EgressFilter egressFilter) {
            this.egressFilter = egressFilter;
            return this;
        }

        public final MeshServiceDiscovery.Builder getServiceDiscovery() {
            return serviceDiscovery != null ? serviceDiscovery.toBuilder() : null;
        }

        public final void setServiceDiscovery(MeshServiceDiscovery.BuilderImpl serviceDiscovery) {
            this.serviceDiscovery = serviceDiscovery != null ? serviceDiscovery.build() : null;
        }

        @Override
        public final Builder serviceDiscovery(MeshServiceDiscovery serviceDiscovery) {
            this.serviceDiscovery = serviceDiscovery;
            return this;
        }

        @Override
        public MeshSpec build() {
            return new MeshSpec(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
