/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a client policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientPolicy implements SdkPojo, Serializable, ToCopyableBuilder<ClientPolicy.Builder, ClientPolicy> {
    private static final SdkField<ClientPolicyTls> TLS_FIELD = SdkField.<ClientPolicyTls> builder(MarshallingType.SDK_POJO)
            .memberName("tls").getter(getter(ClientPolicy::tls)).setter(setter(Builder::tls))
            .constructor(ClientPolicyTls::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tls").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ClientPolicyTls tls;

    private ClientPolicy(BuilderImpl builder) {
        this.tls = builder.tls;
    }

    /**
     * <p>
     * A reference to an object that represents a Transport Layer Security (TLS) client policy.
     * </p>
     * 
     * @return A reference to an object that represents a Transport Layer Security (TLS) client policy.
     */
    public final ClientPolicyTls tls() {
        return tls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tls());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientPolicy)) {
            return false;
        }
        ClientPolicy other = (ClientPolicy) obj;
        return Objects.equals(tls(), other.tls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientPolicy").add("Tls", tls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tls":
            return Optional.ofNullable(clazz.cast(tls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientPolicy, T> g) {
        return obj -> g.apply((ClientPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientPolicy> {
        /**
         * <p>
         * A reference to an object that represents a Transport Layer Security (TLS) client policy.
         * </p>
         * 
         * @param tls
         *        A reference to an object that represents a Transport Layer Security (TLS) client policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tls(ClientPolicyTls tls);

        /**
         * <p>
         * A reference to an object that represents a Transport Layer Security (TLS) client policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientPolicyTls.Builder} avoiding the
         * need to create one manually via {@link ClientPolicyTls#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClientPolicyTls.Builder#build()} is called immediately and its
         * result is passed to {@link #tls(ClientPolicyTls)}.
         * 
         * @param tls
         *        a consumer that will call methods on {@link ClientPolicyTls.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tls(ClientPolicyTls)
         */
        default Builder tls(Consumer<ClientPolicyTls.Builder> tls) {
            return tls(ClientPolicyTls.builder().applyMutation(tls).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ClientPolicyTls tls;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientPolicy model) {
            tls(model.tls);
        }

        public final ClientPolicyTls.Builder getTls() {
            return tls != null ? tls.toBuilder() : null;
        }

        public final void setTls(ClientPolicyTls.BuilderImpl tls) {
            this.tls = tls != null ? tls.build() : null;
        }

        @Override
        public final Builder tls(ClientPolicyTls tls) {
            this.tls = tls;
            return this;
        }

        @Override
        public ClientPolicy build() {
            return new ClientPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
