/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVirtualGatewayResponse extends AppMeshResponse implements
        ToCopyableBuilder<UpdateVirtualGatewayResponse.Builder, UpdateVirtualGatewayResponse> {
    private static final SdkField<VirtualGatewayData> VIRTUAL_GATEWAY_FIELD = SdkField
            .<VirtualGatewayData> builder(MarshallingType.SDK_POJO)
            .memberName("virtualGateway")
            .getter(getter(UpdateVirtualGatewayResponse::virtualGateway))
            .setter(setter(Builder::virtualGateway))
            .constructor(VirtualGatewayData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGateway").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_GATEWAY_FIELD));

    private final VirtualGatewayData virtualGateway;

    private UpdateVirtualGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.virtualGateway = builder.virtualGateway;
    }

    /**
     * <p>
     * A full description of the virtual gateway that was updated.
     * </p>
     * 
     * @return A full description of the virtual gateway that was updated.
     */
    public final VirtualGatewayData virtualGateway() {
        return virtualGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(virtualGateway());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVirtualGatewayResponse)) {
            return false;
        }
        UpdateVirtualGatewayResponse other = (UpdateVirtualGatewayResponse) obj;
        return Objects.equals(virtualGateway(), other.virtualGateway());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVirtualGatewayResponse").add("VirtualGateway", virtualGateway()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualGateway":
            return Optional.ofNullable(clazz.cast(virtualGateway()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVirtualGatewayResponse, T> g) {
        return obj -> g.apply((UpdateVirtualGatewayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateVirtualGatewayResponse> {
        /**
         * <p>
         * A full description of the virtual gateway that was updated.
         * </p>
         * 
         * @param virtualGateway
         *        A full description of the virtual gateway that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGateway(VirtualGatewayData virtualGateway);

        /**
         * <p>
         * A full description of the virtual gateway that was updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link VirtualGatewayData.Builder} avoiding the
         * need to create one manually via {@link VirtualGatewayData#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayData.Builder#build()} is called immediately and its
         * result is passed to {@link #virtualGateway(VirtualGatewayData)}.
         * 
         * @param virtualGateway
         *        a consumer that will call methods on {@link VirtualGatewayData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualGateway(VirtualGatewayData)
         */
        default Builder virtualGateway(Consumer<VirtualGatewayData.Builder> virtualGateway) {
            return virtualGateway(VirtualGatewayData.builder().applyMutation(virtualGateway).build());
        }
    }

    static final class BuilderImpl extends AppMeshResponse.BuilderImpl implements Builder {
        private VirtualGatewayData virtualGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVirtualGatewayResponse model) {
            super(model);
            virtualGateway(model.virtualGateway);
        }

        public final VirtualGatewayData.Builder getVirtualGateway() {
            return virtualGateway != null ? virtualGateway.toBuilder() : null;
        }

        public final void setVirtualGateway(VirtualGatewayData.BuilderImpl virtualGateway) {
            this.virtualGateway = virtualGateway != null ? virtualGateway.build() : null;
        }

        @Override
        public final Builder virtualGateway(VirtualGatewayData virtualGateway) {
            this.virtualGateway = virtualGateway;
            return this;
        }

        @Override
        public UpdateVirtualGatewayResponse build() {
            return new UpdateVirtualGatewayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
