/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <zonbook></zonbook><xhtml></xhtml>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVirtualRoutersResponse extends AppMeshResponse implements
        ToCopyableBuilder<ListVirtualRoutersResponse.Builder, ListVirtualRoutersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListVirtualRoutersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<VirtualRouterRef>> VIRTUAL_ROUTERS_FIELD = SdkField
            .<List<VirtualRouterRef>> builder(MarshallingType.LIST)
            .memberName("virtualRouters")
            .getter(getter(ListVirtualRoutersResponse::virtualRouters))
            .setter(setter(Builder::virtualRouters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualRouters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VirtualRouterRef> builder(MarshallingType.SDK_POJO)
                                            .constructor(VirtualRouterRef::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            VIRTUAL_ROUTERS_FIELD));

    private final String nextToken;

    private final List<VirtualRouterRef> virtualRouters;

    private ListVirtualRoutersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.virtualRouters = builder.virtualRouters;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListVirtualRouters</code> request. When the results
     * of a <code>ListVirtualRouters</code> request exceed <code>limit</code>, you can use this value to retrieve the
     * next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListVirtualRouters</code> request. When the
     *         results of a <code>ListVirtualRouters</code> request exceed <code>limit</code>, you can use this value to
     *         retrieve the next page of results. This value is <code>null</code> when there are no more results to
     *         return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VirtualRouters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVirtualRouters() {
        return virtualRouters != null && !(virtualRouters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of existing virtual routers for the specified service mesh.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVirtualRouters} method.
     * </p>
     * 
     * @return The list of existing virtual routers for the specified service mesh.
     */
    public final List<VirtualRouterRef> virtualRouters() {
        return virtualRouters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasVirtualRouters() ? virtualRouters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualRoutersResponse)) {
            return false;
        }
        ListVirtualRoutersResponse other = (ListVirtualRoutersResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasVirtualRouters() == other.hasVirtualRouters()
                && Objects.equals(virtualRouters(), other.virtualRouters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVirtualRoutersResponse").add("NextToken", nextToken())
                .add("VirtualRouters", hasVirtualRouters() ? virtualRouters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "virtualRouters":
            return Optional.ofNullable(clazz.cast(virtualRouters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVirtualRoutersResponse, T> g) {
        return obj -> g.apply((ListVirtualRoutersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListVirtualRoutersResponse> {
        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListVirtualRouters</code> request. When the
         * results of a <code>ListVirtualRouters</code> request exceed <code>limit</code>, you can use this value to
         * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListVirtualRouters</code> request. When
         *        the results of a <code>ListVirtualRouters</code> request exceed <code>limit</code>, you can use this
         *        value to retrieve the next page of results. This value is <code>null</code> when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of existing virtual routers for the specified service mesh.
         * </p>
         * 
         * @param virtualRouters
         *        The list of existing virtual routers for the specified service mesh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualRouters(Collection<VirtualRouterRef> virtualRouters);

        /**
         * <p>
         * The list of existing virtual routers for the specified service mesh.
         * </p>
         * 
         * @param virtualRouters
         *        The list of existing virtual routers for the specified service mesh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualRouters(VirtualRouterRef... virtualRouters);

        /**
         * <p>
         * The list of existing virtual routers for the specified service mesh.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<VirtualRouterRef>.Builder} avoiding
         * the need to create one manually via {@link List<VirtualRouterRef>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VirtualRouterRef>.Builder#build()} is called immediately and
         * its result is passed to {@link #virtualRouters(List<VirtualRouterRef>)}.
         * 
         * @param virtualRouters
         *        a consumer that will call methods on {@link List<VirtualRouterRef>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualRouters(List<VirtualRouterRef>)
         */
        Builder virtualRouters(Consumer<VirtualRouterRef.Builder>... virtualRouters);
    }

    static final class BuilderImpl extends AppMeshResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<VirtualRouterRef> virtualRouters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualRoutersResponse model) {
            super(model);
            nextToken(model.nextToken);
            virtualRouters(model.virtualRouters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<VirtualRouterRef.Builder> getVirtualRouters() {
            List<VirtualRouterRef.Builder> result = VirtualRouterListCopier.copyToBuilder(this.virtualRouters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVirtualRouters(Collection<VirtualRouterRef.BuilderImpl> virtualRouters) {
            this.virtualRouters = VirtualRouterListCopier.copyFromBuilder(virtualRouters);
        }

        @Override
        public final Builder virtualRouters(Collection<VirtualRouterRef> virtualRouters) {
            this.virtualRouters = VirtualRouterListCopier.copy(virtualRouters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualRouters(VirtualRouterRef... virtualRouters) {
            virtualRouters(Arrays.asList(virtualRouters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualRouters(Consumer<VirtualRouterRef.Builder>... virtualRouters) {
            virtualRouters(Stream.of(virtualRouters).map(c -> VirtualRouterRef.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVirtualRoutersResponse build() {
            return new ListVirtualRoutersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
